/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.venus.service.feign.service.internal;

import com.bizunited.platform.common.controller.model.ResponseModel;
import com.bizunited.platform.common.util.FileUtils;
import com.bizunited.platform.common.util.JsonUtils;
import com.bizunited.platform.user.common.service.user.UserService;
import com.bizunited.platform.user.common.vo.UserVo;
import com.bizunited.platform.venus.common.service.document.DocumentService;
import com.bizunited.platform.venus.common.vo.DocumentVo;
import com.bizunited.platform.venus.service.feign.DocumentFeignClient;
import com.fasterxml.jackson.core.type.TypeReference;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import feign.Response;
import java.io.IOException;
import java.security.Principal;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service(value="DocumentServiceImpl")
public class DocumentServiceImpl
implements DocumentService {
    private static final Logger LOGGER = LoggerFactory.getLogger(DocumentServiceImpl.class);
    @Autowired
    private DocumentFeignClient documentFeignClient;
    @Autowired
    private UserService userService;

    public List<DocumentVo> findByKeyword(String keyword) {
        if (StringUtils.isBlank((CharSequence)keyword)) {
            return Lists.newArrayList();
        }
        ResponseModel response = this.documentFeignClient.findByKeyword(keyword);
        return (List)JsonUtils.convert((Object)response.getSuccessDataOrElse((Object)Lists.newArrayList()), (TypeReference)new TypeReference<List<DocumentVo>>(){});
    }

    public byte[] export() {
        Response response = this.documentFeignClient.export();
        byte[] bytes = new byte[]{};
        try {
            bytes = FileUtils.readByte((Response)response);
        }
        catch (IOException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
        return bytes;
    }

    public void importDoc(MultipartFile file) {
        Validate.notNull((Object)file, (String)"\u4e0a\u4f20\u7684\u6587\u4ef6\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        ResponseModel response = this.documentFeignClient.importDoc(file);
        Validate.isTrue((boolean)response.getSuccess(), (String)response.getErrorMsg(), (Object[])new Object[0]);
    }

    public DocumentVo create(DocumentVo documentVo, Principal principal) {
        Validate.notNull((Object)documentVo, (String)"\u6587\u6863\u5bf9\u8c61\u5fc5\u987b\u4f20\u5165\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        this.validateUser(principal);
        ResponseModel response = this.documentFeignClient.create(documentVo);
        Validate.isTrue((boolean)response.getSuccess(), (String)response.getErrorMsg(), (Object[])new Object[0]);
        return (DocumentVo)JsonUtils.convert((Object)response.getSuccessDataOrElse(null), DocumentVo.class);
    }

    private void validateUser(Principal principal) {
        String creator = principal.getName();
        Validate.notBlank((CharSequence)creator, (String)"\u6587\u6863\u63d0\u4ea4\u4eba\u5fc5\u987b\u4f20\u5165\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        UserVo user = this.userService.findByAccount(creator);
        Validate.notNull((Object)user, (String)"\u6ca1\u6709\u627e\u5230\u4efb\u4f55\u521b\u5efa\u8005\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)user.getAccount(), (String)"\u7528\u6237\u8d26\u53f7\u4fe1\u606f\u4e0d\u5b58\u5728!", (Object[])new Object[0]);
    }

    public DocumentVo update(DocumentVo documentVo, Principal principal) {
        Validate.notNull((Object)documentVo, (String)"\u6587\u6863\u5bf9\u8c61\u5fc5\u987b\u4f20\u5165\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        this.validateUser(principal);
        ResponseModel response = this.documentFeignClient.update(documentVo);
        Validate.isTrue((boolean)response.getSuccess(), (String)response.getErrorMsg(), (Object[])new Object[0]);
        return (DocumentVo)JsonUtils.convert((Object)response.getSuccessDataOrElse(null), DocumentVo.class);
    }

    public void deleteById(String id) {
        Validate.notNull((Object)id, (String)"id\u5fc5\u987b\u4f20\u5165\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        ResponseModel response = this.documentFeignClient.deleteById(id);
        Validate.isTrue((boolean)response.getSuccess(), (String)response.getErrorMsg(), (Object[])new Object[0]);
    }

    public DocumentVo findDetailsById(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        ResponseModel response = this.documentFeignClient.findDetailsById(id);
        Validate.isTrue((boolean)response.getSuccess(), (String)response.getErrorMsg(), (Object[])new Object[0]);
        return (DocumentVo)JsonUtils.convert((Object)response.getSuccessDataOrElse(null), DocumentVo.class);
    }

    public Set<DocumentVo> findTree() {
        ResponseModel response = this.documentFeignClient.findTree();
        if (!response.getSuccess().booleanValue()) {
            return Sets.newHashSet();
        }
        Validate.isTrue((boolean)response.getSuccess(), (String)response.getErrorMsg(), (Object[])new Object[0]);
        return (Set)JsonUtils.convert((Object)response.getSuccessDataOrElse(null), (TypeReference)new TypeReference<Set<DocumentVo>>(){});
    }
}

