/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.venus.service.feign.service.internal;

import com.bizunited.platform.common.controller.model.ResponseModel;
import com.bizunited.platform.common.util.JsonUtils;
import com.bizunited.platform.venus.common.service.image.FileUpdateService;
import com.bizunited.platform.venus.common.vo.OrdinaryFileVo;
import com.bizunited.platform.venus.service.feign.FileFeignClient;
import com.fasterxml.jackson.core.type.TypeReference;
import com.google.common.collect.Lists;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service(value="FileUpdateServiceImpl")
public class FileUpdateServiceImpl
implements FileUpdateService {
    @Autowired
    private FileFeignClient fileFeignClient;

    public List<OrdinaryFileVo> fileUpload(String subsystem, String creator, Integer effective, MultipartFile[] files) {
        Validate.notEmpty((Object[])files, (String)"\u6587\u4ef6\u5185\u5bb9\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        ResponseModel response = this.fileFeignClient.fileUpload(subsystem, effective, files);
        Validate.isTrue((boolean)response.getSuccess(), (String)response.getErrorMsg(), (Object[])new Object[0]);
        return (List)JsonUtils.convert((Object)response.getData(), (TypeReference)new TypeReference<List<OrdinaryFileVo>>(){});
    }

    public List<OrdinaryFileVo> fileUpload(String subsystem, String creator, Integer effective, String[] fileNanmes, String[] base64Contents) {
        ResponseModel response = this.fileFeignClient.fileUpload(subsystem, effective, fileNanmes, base64Contents);
        Validate.isTrue((boolean)response.getSuccess(), (String)response.getErrorMsg(), (Object[])new Object[0]);
        return (List)JsonUtils.convert((Object)response.getData(), (TypeReference)new TypeReference<List<OrdinaryFileVo>>(){});
    }

    public List<OrdinaryFileVo> findByEffectiveDate(Date currentDate) {
        ResponseModel response = this.fileFeignClient.findByEffectiveDate(currentDate);
        if (!response.getSuccess().booleanValue()) {
            return Lists.newArrayList();
        }
        return (List)JsonUtils.convert((Object)response.getData(), (TypeReference)new TypeReference<List<OrdinaryFileVo>>(){});
    }

    public void updateEffective(String[] fileReNames) {
        ResponseModel response = this.fileFeignClient.updatePermanentEffective(fileReNames);
        Validate.isTrue((boolean)response.getSuccess(), (String)response.getErrorMsg(), (Object[])new Object[0]);
    }

    public void deleteFiles(String[] fileIds) {
        ResponseModel response = this.fileFeignClient.deleteFiles(fileIds);
        Validate.isTrue((boolean)response.getSuccess(), (String)response.getErrorMsg(), (Object[])new Object[0]);
    }

    public void deleteFile(String filePath, String fileName) {
        ResponseModel response = this.fileFeignClient.deleteFile(filePath, fileName);
        Validate.isTrue((boolean)response.getSuccess(), (String)response.getErrorMsg(), (Object[])new Object[0]);
    }

    public List<OrdinaryFileVo> fileImageUpload(String subsystem, String creator, Integer effective, MultipartFile[] files) {
        Validate.notEmpty((Object[])files, (String)"\u6587\u4ef6\u5185\u5bb9\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        ResponseModel response = this.fileFeignClient.fileImageUpload(subsystem, effective, files);
        Validate.isTrue((boolean)response.getSuccess(), (String)response.getErrorMsg(), (Object[])new Object[0]);
        return (List)JsonUtils.convert((Object)response.getData(), (TypeReference)new TypeReference<List<OrdinaryFileVo>>(){});
    }

    public List<OrdinaryFileVo> fileImageUpload(String subsystem, String creator, Integer effective, String[] fileNanmes, String[] base64Contents) {
        Validate.notEmpty((Object[])fileNanmes, (String)"\u6587\u4ef6\u540d\u5b57\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notEmpty((Object[])base64Contents, (String)"\u6587\u4ef6\u63cf\u8ff0\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        ResponseModel response = this.fileFeignClient.fileImageUpload(subsystem, effective, fileNanmes, base64Contents);
        Validate.isTrue((boolean)response.getSuccess(), (String)response.getErrorMsg(), (Object[])new Object[0]);
        return (List)JsonUtils.convert((Object)response.getData(), (TypeReference)new TypeReference<List<OrdinaryFileVo>>(){});
    }
}

