/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.venus.service.local.repository;

import com.bizunited.platform.venus.service.local.entity.DocumentEntity;
import java.util.List;
import java.util.Set;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

@Repository(value="DocumentRepository")
public interface DocumentRepository
extends JpaRepository<DocumentEntity, String>,
JpaSpecificationExecutor<DocumentEntity> {
    @Query(value="from DocumentEntity doc where doc.parent = null order by doc.sort")
    public Set<DocumentEntity> findByNullParent();

    @Query(value="select count(*) from DocumentEntity doc where doc.title = :title and doc.parent = null")
    public long countByNullParentAndTitle(@Param(value="title") String var1);

    @Query(value="select doc from DocumentEntity doc where doc.title = :title and doc.parent = null")
    public DocumentEntity findByNullParentAndTitle(@Param(value="title") String var1);

    @Query(value="select count(*) from DocumentEntity  doc inner join doc.parent pdoc where pdoc.id = :parentId and doc.title = :title")
    public long countByParentAndTitle(@Param(value="title") String var1, @Param(value="parentId") String var2);

    @Query(value="select doc from DocumentEntity  doc inner join doc.parent pdoc where pdoc.id = :parentId and doc.title = :title")
    public DocumentEntity findByParentAndTitle(@Param(value="title") String var1, @Param(value="parentId") String var2);

    @Query(value="select doc from DocumentEntity  doc inner join doc.parent pdoc where pdoc.id = :id order by doc.sort")
    public List<DocumentEntity> findByParent(@Param(value="id") String var1);
}

