/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.venus.service.local.service.internal;

import com.bizunited.platform.common.entity.UuidEntity;
import com.bizunited.platform.common.service.NebulaToolkitService;
import com.bizunited.platform.common.util.FileUtils;
import com.bizunited.platform.common.util.ZipFileUtils;
import com.bizunited.platform.rbac.server.util.SecurityUtils;
import com.bizunited.platform.user.common.vo.UserVo;
import com.bizunited.platform.venus.common.service.document.DocumentService;
import com.bizunited.platform.venus.common.service.file.VenusFileService;
import com.bizunited.platform.venus.common.service.image.FileViewService;
import com.bizunited.platform.venus.common.vo.DocumentVo;
import com.bizunited.platform.venus.service.local.elasticsearch.repository.DocumentEsRepository;
import com.bizunited.platform.venus.service.local.entity.DocumentEntity;
import com.bizunited.platform.venus.service.local.repository.DocumentRepository;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.security.Principal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.transaction.Transactional;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.web.multipart.MultipartFile;

@Service(value="DocumentServiceImpl")
public class DocumentServiceImpl
implements DocumentService {
    private static final Logger LOGGER = LoggerFactory.getLogger(DocumentServiceImpl.class);
    private static final String MD_FILE_SUFFIX = "txt";
    private static final String ZIP_DOCUMENT_FILE_NAME = "documents.in";
    private static final Integer DEFAULT_SORT = 1000;
    @Value(value="${venus.file.fileRoot}")
    private String fileRoot;
    @Autowired
    private DocumentRepository documentRepository;
    @Autowired
    private VenusFileService venusFileService;
    @Autowired
    private NebulaToolkitService nebulaToolkitService;
    @Autowired
    private DocumentEsRepository documentEsRepository;
    @Autowired
    private FileViewService imageViewService;

    @Transactional
    public DocumentVo create(DocumentVo documentVo, Principal principal) {
        UserVo userVo = SecurityUtils.getCurrentUser();
        this.createValidation(documentVo);
        DocumentEntity document = (DocumentEntity)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)documentVo, DocumentEntity.class, HashSet.class, ArrayList.class, new String[]{"parent"}));
        document.setCreator(userVo.getAccount());
        document.setModifier(userVo.getAccount());
        Date nowDate = new Date();
        document.setCreateTime(nowDate);
        document.setModifyTime(nowDate);
        Integer sort = documentVo.getSort();
        if (sort == null) {
            document.setSort(DEFAULT_SORT);
        }
        this.saveDucomentContent(document);
        this.documentRepository.saveAndFlush((Object)document);
        this.saveEsDocument(document);
        return (DocumentVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)document, DocumentVo.class, HashSet.class, ArrayList.class, new String[0]);
    }

    private void createValidation(DocumentVo documentVo) {
        Validate.notNull((Object)documentVo, (String)"\u6587\u6863\u5bf9\u8c61\u5fc5\u987b\u4f20\u5165\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        Validate.isTrue((documentVo.getId() == null ? 1 : 0) != 0, (String)"\u65b0\u589e\u6587\u6863\u65f6\uff0c\u4e0d\u80fd\u4f20\u5165ID\uff01", (Object[])new Object[0]);
        this.commonValidation(documentVo, null);
    }

    private void createValidation(DocumentEntity document) {
        Validate.notNull((Object)((Object)document), (String)"\u6587\u6863\u5bf9\u8c61\u5fc5\u987b\u4f20\u5165\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        DocumentVo documentVo = (DocumentVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)document, DocumentVo.class, null, null, new String[]{"parent"});
        this.commonValidation(documentVo, null);
    }

    private void commonValidation(DocumentVo documentVo, String currentTitle) {
        String title = documentVo.getTitle();
        Validate.notBlank((CharSequence)title, (String)"\u6807\u9898\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        DocumentVo parent = documentVo.getParent();
        if (parent != null) {
            Validate.notBlank((CharSequence)parent.getId(), (String)"\u7236id\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            DocumentEntity parentDocument = this.documentRepository.findById(parent.getId()).orElse(null);
            Validate.notNull((Object)((Object)parentDocument), (String)"\u7236\u6587\u6863\u4e0d\u5b58\u5728\uff01", (Object[])new Object[0]);
        }
        if (currentTitle == null || !currentTitle.equals(title)) {
            if (parent == null) {
                long count = this.documentRepository.countByNullParentAndTitle(documentVo.getTitle());
                Validate.isTrue((count == 0L ? 1 : 0) != 0, (String)"title\u4e0d\u80fd\u91cd\u540d\uff0c\u8bf7\u91cd\u65b0\u4f20\u5165\uff01\uff01", (Object[])new Object[0]);
            } else {
                long count = this.documentRepository.countByParentAndTitle(documentVo.getTitle(), parent.getId());
                Validate.isTrue((count == 0L ? 1 : 0) != 0, (String)"title\u4e0d\u80fd\u91cd\u540d\uff0c\u8bf7\u91cd\u65b0\u4f20\u5165\uff01\uff01", (Object[])new Object[0]);
            }
        }
    }

    @Transactional
    public DocumentVo update(DocumentVo documentVo, Principal principal) {
        UserVo userVo = SecurityUtils.getCurrentUser();
        this.updateValidation(documentVo);
        DocumentEntity document = this.documentRepository.findById(documentVo.getId()).orElse(null);
        Validate.notNull((Object)((Object)document), (String)"\u8981\u4fee\u6539\u7684\u6587\u6863\u5bf9\u8c61\u4e0d\u5b58\u5728!!", (Object[])new Object[0]);
        this.commonValidation(documentVo, document.getTitle());
        document.setTitle(documentVo.getTitle());
        document.setContent(documentVo.getContent());
        document.setModifier(userVo.getAccount());
        document.setModifyTime(new Date());
        document.setSort(documentVo.getSort());
        DocumentVo parentVo = documentVo.getParent();
        if (parentVo != null) {
            Validate.isTrue((!parentVo.getId().equals(documentVo.getId()) ? 1 : 0) != 0, (String)"\u7981\u6b62\u5c06\u8be5\u6587\u6863\u672c\u8eab\u8bbe\u7f6e\u4e3a\u4e0a\u7ea7", (Object[])new Object[0]);
            DocumentEntity parent = new DocumentEntity();
            parent.setId(parentVo.getId());
            document.setParent(parent);
            HashSet<String> documentStack = new HashSet<String>();
            documentStack.add(parentVo.getId());
            this.validateCircular(document, documentStack);
        } else {
            document.setParent(null);
        }
        this.saveDucomentContent(document);
        this.documentRepository.saveAndFlush((Object)document);
        this.saveEsDocument(document);
        return (DocumentVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)document, DocumentVo.class, HashSet.class, ArrayList.class, new String[0]);
    }

    private void validateCircular(DocumentEntity document, Set<String> documentStack) {
        List<DocumentEntity> children = this.documentRepository.findByParent(document.getId());
        if (CollectionUtils.isEmpty(children)) {
            return;
        }
        for (DocumentEntity child : children) {
            Validate.isTrue((!documentStack.contains(child.getId()) ? 1 : 0) != 0, (String)"\u5f62\u6210\u5faa\u73af\u4f9d\u8d56\uff0c\u66f4\u65b0\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\uff01", (Object[])new Object[0]);
            documentStack.add(child.getId());
            this.validateCircular(child, documentStack);
        }
    }

    private void updateValidation(DocumentVo documentVo) {
        Validate.notNull((Object)documentVo, (String)"\u6587\u6863\u5bf9\u8c61\u5fc5\u987b\u4f20\u5165\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        String id = documentVo.getId();
        Validate.notBlank((CharSequence)id, (String)"\u6587\u6863id\u5fc5\u987b\u4f20\u5165\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
    }

    private void saveDucomentContent(DocumentEntity document) {
        if (document.getContent() == null) {
            return;
        }
        String fileName = document.getFileName();
        String relativeLocal = document.getRelativeLocal();
        byte[] documentContent = document.getContent().getBytes(StandardCharsets.UTF_8);
        if (StringUtils.isAllBlank((CharSequence[])new CharSequence[]{fileName, relativeLocal})) {
            fileName = UUID.randomUUID().toString() + "." + MD_FILE_SUFFIX;
            relativeLocal = this.randomRelativeLocal();
        }
        this.venusFileService.saveFile(relativeLocal, fileName, fileName, documentContent);
        document.setRelativeLocal(relativeLocal);
        document.setFileName(fileName);
    }

    private String randomRelativeLocal() {
        String folderName = new SimpleDateFormat("yyyyMMdd").format(new Date());
        return StringUtils.join((Object[])new Serializable[]{"/document/", folderName, "/", Integer.valueOf(new Random().nextInt(100) % 10)});
    }

    public Set<DocumentVo> findTree() {
        LinkedHashSet<DocumentVo> documentSet = new LinkedHashSet<DocumentVo>();
        Set<DocumentEntity> rootDocuments = this.documentRepository.findByNullParent();
        if (CollectionUtils.isEmpty(rootDocuments)) {
            return Sets.newHashSet();
        }
        for (DocumentEntity documentEntity : rootDocuments) {
            DocumentVo documentVo = (DocumentVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)documentEntity, DocumentVo.class, LinkedHashSet.class, ArrayList.class, new String[]{"parent"});
            documentVo.setDocuments(this.findChildren(documentEntity));
            documentSet.add(documentVo);
        }
        return documentSet;
    }

    private Set<DocumentVo> findChildren(DocumentEntity documentEntity) {
        LinkedHashSet<DocumentVo> documentVoSet = new LinkedHashSet<DocumentVo>();
        Set<DocumentEntity> children = documentEntity.getDocuments();
        if (CollectionUtils.isEmpty(children)) {
            return Sets.newHashSet();
        }
        for (DocumentEntity child : children) {
            DocumentVo documentVo = (DocumentVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)child, DocumentVo.class, HashSet.class, ArrayList.class, new String[]{"parent"});
            documentVo.setDocuments(this.findChildren(child));
            documentVoSet.add(documentVo);
        }
        return documentVoSet;
    }

    @Transactional
    public void deleteById(String id) {
        Validate.notBlank((CharSequence)id, (String)"\u5220\u9664\u65f6\u6587\u6863\u552f\u4e00\u4e3b\u952eid\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        DocumentEntity document = this.documentRepository.findById(id).orElse(null);
        if (document != null) {
            this.deleteDocument(document);
        }
    }

    private void deleteDocument(DocumentEntity document) {
        Set<DocumentEntity> children = document.getDocuments();
        if (!CollectionUtils.isEmpty(children)) {
            for (DocumentEntity documentEntity : children) {
                this.deleteDocument(documentEntity);
            }
        }
        this.documentRepository.delete((Object)document);
        this.documentEsRepository.delete((Object)document);
        this.deleteFile(document);
    }

    private void deleteFile(DocumentEntity document) {
        String fileRename = document.getFileName();
        String relativeLocal = document.getRelativeLocal();
        if (!StringUtils.isAllBlank((CharSequence[])new CharSequence[]{fileRename, relativeLocal})) {
            this.venusFileService.deleteFile(relativeLocal, fileRename, fileRename);
        }
    }

    public DocumentVo findDetailsById(String id) {
        DocumentEntity document = this.documentRepository.findById(id).orElse(null);
        if (document == null) {
            return null;
        }
        String fileRename = document.getFileName();
        String relativeLocal = document.getRelativeLocal();
        if (!StringUtils.isEmpty((CharSequence)fileRename) && !StringUtils.isEmpty((CharSequence)relativeLocal)) {
            byte[] bytes = this.venusFileService.readFileContent(relativeLocal, fileRename);
            String content = bytes == null ? "" : new String(bytes, StandardCharsets.UTF_8);
            document.setContent(content);
        }
        return (DocumentVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)document, DocumentVo.class, HashSet.class, ArrayList.class, new String[0]);
    }

    public List<DocumentVo> findByKeyword(String keyword) {
        if (StringUtils.isBlank((CharSequence)keyword)) {
            return Lists.newArrayList();
        }
        List documents = this.documentEsRepository.findByKeyword(keyword);
        if (CollectionUtils.isEmpty((Collection)documents)) {
            return Lists.newArrayList();
        }
        Collection documentVos = this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)documents, DocumentEntity.class, DocumentVo.class, HashSet.class, ArrayList.class, new String[0]);
        return Lists.newArrayList((Iterable)documentVos);
    }

    /*
     * Exception decompiling
     */
    public byte[] export() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Transactional
    public void importDoc(MultipartFile file) {
        File tmpFile;
        Validate.notNull((Object)file, (String)"\u5bfc\u5165\u7684\u6587\u4ef6\u4e3a\u7a7a", (Object[])new Object[0]);
        try {
            tmpFile = FileUtils.writeLocalFile((byte[])file.getBytes(), (String)this.fileRoot, (String)"zip");
        }
        catch (IOException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            throw new IllegalArgumentException(String.format("\u8bbf\u95ee\u672c\u5730\u78c1\u76d8\u51fa\u9519\uff1a%s", e.getMessage()));
        }
        try (ZipFile zipFile = new ZipFile(tmpFile);){
            ZipEntry entry = zipFile.getEntry(ZIP_DOCUMENT_FILE_NAME);
            Validate.notNull((Object)entry, (String)"\u672a\u627e\u5230\u6587\u6863\u6587\u4ef6\uff0c\u8bf7\u4e0a\u4f20\u6b63\u786e\u7684\u6587\u4ef6\uff01\uff01", (Object[])new Object[0]);
            try {
                InputStream is = zipFile.getInputStream(entry);
                Throwable throwable = null;
                try {
                    List documents;
                    Throwable throwable2;
                    ObjectInputStream ois;
                    block54: {
                        block55: {
                            block56: {
                                ois = new ObjectInputStream(is);
                                throwable2 = null;
                                documents = (List)ois.readObject();
                                if (!CollectionUtils.isEmpty((Collection)documents)) break block54;
                                if (ois == null) break block55;
                                if (throwable2 == null) break block56;
                                try {
                                    ois.close();
                                }
                                catch (Throwable throwable3) {
                                    throwable2.addSuppressed(throwable3);
                                }
                                break block55;
                            }
                            ois.close();
                        }
                        if (is == null) return;
                        if (throwable != null) {
                            try {
                                is.close();
                                return;
                            }
                            catch (Throwable throwable4) {
                                throwable.addSuppressed(throwable4);
                                return;
                            }
                        }
                        is.close();
                        return;
                    }
                    try {
                        List<DocumentEntity> tree = this.convert2Tree(documents);
                        this.importDocs(zipFile, tree, null);
                        return;
                    }
                    catch (Throwable throwable5) {
                        throwable2 = throwable5;
                        throw throwable5;
                    }
                    catch (Throwable throwable6) {
                        throw throwable6;
                    }
                    finally {
                        if (ois != null) {
                            if (throwable2 != null) {
                                try {
                                    ois.close();
                                }
                                catch (Throwable throwable7) {
                                    throwable2.addSuppressed(throwable7);
                                }
                            } else {
                                ois.close();
                            }
                        }
                    }
                }
                catch (Throwable throwable8) {
                    throwable = throwable8;
                    throw throwable8;
                }
                catch (Throwable throwable9) {
                    throw throwable9;
                }
            }
            catch (ClassNotFoundException e) {
                throw new IllegalArgumentException("\u5bfc\u5165\u5931\u8d25\uff0c\u672a\u627e\u5230\u76f8\u5173\u7c7b", e);
            }
        }
        catch (IOException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            throw new IllegalArgumentException("\u8bfb\u53d6\u6587\u4ef6\u5931\u8d25\uff0c\u8bf7\u91cd\u65b0\u4e0a\u4f20\uff01");
        }
        finally {
            tmpFile.delete();
        }
    }

    private void importDocs(ZipFile zipFile, List<DocumentEntity> documents, DocumentEntity parent) {
        if (CollectionUtils.isEmpty(documents)) {
            return;
        }
        for (DocumentEntity document : documents) {
            DocumentEntity dbDocument = this.findByTitleAndParent(document.getTitle(), parent);
            if (dbDocument == null) {
                document.setId(null);
                document.setParent(parent);
                this.createValidation(document);
                this.documentRepository.save((Object)document);
                this.importDocContent(zipFile, document);
                this.saveEsDocument(document);
                dbDocument = document;
            }
            if (CollectionUtils.isEmpty(document.getDocuments())) continue;
            List<DocumentEntity> children = document.getDocuments().stream().collect(Collectors.toList());
            this.importDocs(zipFile, children, dbDocument);
        }
    }

    private void importDocContent(ZipFile zipFile, DocumentEntity document) {
        String relativeLocal = document.getRelativeLocal();
        String fileName = document.getFileName();
        if (!StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{relativeLocal, fileName})) {
            try {
                byte[] bytes = ZipFileUtils.readZipFile((ZipFile)zipFile, (String)relativeLocal, (String)fileName);
                byte[] newBytes = this.importImage(zipFile, bytes);
                this.venusFileService.saveFile(relativeLocal, fileName, fileName, newBytes);
                document.setContent(new String(bytes, StandardCharsets.UTF_8));
            }
            catch (IOException e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
                throw new IllegalArgumentException(String.format("\u8bfb\u53d6\u6587\u6863\u5185\u5bb9\u5931\u8d25\uff1a%s", document.getTitle()), e);
            }
        }
    }

    private byte[] importImage(ZipFile zipFile, byte[] bytes) {
        String regex = "(?<=images).*?(?=\\))";
        Pattern p = Pattern.compile(regex);
        Matcher m = p.matcher(new String(bytes, StandardCharsets.UTF_8));
        String content = new String(bytes, StandardCharsets.UTF_8);
        while (m.find()) {
            String str = m.group();
            int index = str.lastIndexOf("/");
            String imageRelativeLocal = str.substring(0, index);
            String imageFileName = str.substring(index + 1);
            String[] arr = imageFileName.split("\\.");
            ZipEntry image = ZipFileUtils.getZipEntry((ZipFile)zipFile, (String)imageRelativeLocal, (String)imageFileName);
            InputStream inputStream = null;
            try {
                inputStream = zipFile.getInputStream(image);
                byte[] imageBytes = IOUtils.toByteArray((InputStream)inputStream);
                String folderName = new SimpleDateFormat("yyyyMMdd").format(new Date());
                String uuid = UUID.randomUUID().toString();
                String fileRename = StringUtils.join((Object[])new String[]{uuid + "." + arr[1]});
                String relativePath = StringUtils.join((Object[])new Serializable[]{"/files/", folderName, "/", Integer.valueOf(new Random().nextInt(100) % 10)});
                this.venusFileService.saveFile(relativePath, fileRename, fileRename, imageBytes);
                content = content.replace(str, relativePath + "/" + fileRename);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return content.getBytes();
    }

    private DocumentEntity findByTitleAndParent(String title, DocumentEntity parent) {
        DocumentEntity document = parent == null ? this.documentRepository.findByNullParentAndTitle(title) : this.documentRepository.findByParentAndTitle(title, parent.getId());
        return document;
    }

    private List<DocumentEntity> convert2Tree(List<DocumentEntity> documents) {
        Map<String, DocumentEntity> documentMap = documents.stream().collect(Collectors.toMap(UuidEntity::getId, d -> d));
        HashMap<String, DocumentEntity> rootMap = new HashMap<String, DocumentEntity>();
        for (DocumentEntity document : documents) {
            DocumentEntity parent = document.getParent();
            if (parent == null) {
                rootMap.put(document.getId(), document);
                continue;
            }
            DocumentEntity parentDoc = documentMap.get(parent.getId());
            if (parentDoc == null) {
                rootMap.put(document.getId(), document);
                continue;
            }
            Set<Object> children = parentDoc.getDocuments() == null ? Sets.newHashSet() : parentDoc.getDocuments();
            children.add((Object)document);
            parentDoc.setDocuments(children);
        }
        return Lists.newArrayList(rootMap.values());
    }

    private void saveEsDocument(DocumentEntity document) {
        if (StringUtils.isBlank((CharSequence)document.getContent()) && StringUtils.isNotBlank((CharSequence)document.getRelativeLocal()) && StringUtils.isNotBlank((CharSequence)document.getFileName())) {
            byte[] bytes = this.venusFileService.readFileContent(document.getRelativeLocal(), document.getFileName());
            document.setContent(new String(bytes, StandardCharsets.UTF_8));
        }
        DocumentEntity documentEs = (DocumentEntity)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)document, DocumentEntity.class, null, null, new String[0]));
        this.documentEsRepository.save((Object)documentEs);
    }
}

