/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.venus.service.local.elasticsearch.repository.internal;

import com.bizunited.platform.venus.service.local.elasticsearch.repository.internal.DocumentEsRepositoryCustom;
import com.bizunited.platform.venus.service.local.entity.DocumentEntity;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.elasticsearch.core.ElasticsearchTemplate;
import org.springframework.data.elasticsearch.core.query.NativeSearchQuery;
import org.springframework.data.elasticsearch.core.query.NativeSearchQueryBuilder;
import org.springframework.data.elasticsearch.core.query.SearchQuery;
import org.springframework.stereotype.Repository;

@Repository(value="DocumentEsRepositoryImpl")
public class DocumentEsRepositoryImpl
implements DocumentEsRepositoryCustom {
    @Autowired
    private ElasticsearchTemplate elasticsearchTemplate;

    @Override
    public List<DocumentEntity> findByKeyword(String keyword) {
        BoolQueryBuilder builder = QueryBuilders.boolQuery();
        if (StringUtils.isNotBlank((CharSequence)keyword)) {
            String parserParam = StringUtils.join((Object[])new String[]{"*", keyword, "*"});
            BoolQueryBuilder paramBuilder = QueryBuilders.boolQuery();
            paramBuilder.should((QueryBuilder)QueryBuilders.wildcardQuery((String)"title.keyword", (String)parserParam));
            paramBuilder.should((QueryBuilder)QueryBuilders.wildcardQuery((String)"content.keyword", (String)parserParam));
            builder.must((QueryBuilder)paramBuilder);
        }
        NativeSearchQueryBuilder queryBuilder = new NativeSearchQueryBuilder();
        queryBuilder.withQuery((QueryBuilder)builder);
        PageRequest pageable = PageRequest.of((int)0, (int)10000);
        queryBuilder.withPageable((Pageable)pageable);
        NativeSearchQuery query = queryBuilder.build();
        return this.elasticsearchTemplate.queryForList((SearchQuery)query, DocumentEntity.class);
    }
}

