/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.venus.service.local.service.internal;

import com.bizunited.platform.common.constant.PlatformContext;
import com.bizunited.platform.common.service.NebulaToolkitService;
import com.bizunited.platform.venus.common.service.file.FileRelativeTemplate;
import com.bizunited.platform.venus.common.service.file.VenusFileService;
import com.bizunited.platform.venus.common.service.image.FileUpdateService;
import com.bizunited.platform.venus.common.vo.OrdinaryFileVo;
import com.bizunited.platform.venus.service.local.entity.OrdinaryFileEntity;
import com.bizunited.platform.venus.service.local.repository.OrdinaryFileRepository;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import javax.transaction.Transactional;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.Base64Utils;
import org.springframework.web.multipart.MultipartFile;

@Service(value="FileUpdateServiceImpl")
public class FileUpdateServiceImpl
implements FileUpdateService {
    private static final Logger LOGGER = LoggerFactory.getLogger(FileUpdateServiceImpl.class);
    @Value(value="${venus.file.maxFileSize}")
    private Integer maxFileSize;
    @Value(value="${venus.file.whitePrefixs}")
    private String[] whitePrefixs;
    @Autowired
    private VenusFileService nebulaFileService;
    @Autowired
    private OrdinaryFileRepository ordinaryFileRepository;
    @Autowired
    private FileRelativeTemplate fileRelativeTemplate;
    @Autowired
    private NebulaToolkitService nebulaToolkitService;
    @Autowired
    private PlatformContext platformContext;

    @Transactional
    public List<OrdinaryFileVo> fileUpload(String subSystem, String creator, Integer effective, MultipartFile[] files) {
        Validate.notNull((Object)(files != null && files.length > 0 ? 1 : 0), (String)"\u4e0a\u4f20\u7684\u6587\u4ef6\u4fe1\u606f\u81f3\u5c11\u6709\u4e00\u4e2a\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)creator, (String)"\u9644\u4ef6\u7684\u63d0\u4ea4\u4eba\u5fc5\u987b\u4f20\u5165\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        LinkedList<OrdinaryFileVo> ordinaryFileVos = new LinkedList<OrdinaryFileVo>();
        for (MultipartFile file : files) {
            byte[] fileContext = null;
            try {
                fileContext = file.getBytes();
            }
            catch (Exception e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
                throw new IllegalArgumentException(e);
            }
            String originalFilename = file.getOriginalFilename();
            this.validatePrefix(originalFilename);
            int prefixIndex = originalFilename.lastIndexOf(46);
            OrdinaryFileVo result = this.saveOrdinaryFile(prefixIndex, originalFilename, subSystem, effective, creator, fileContext);
            OrdinaryFileEntity ordinaryFileEntity = (OrdinaryFileEntity)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)result, OrdinaryFileEntity.class, LinkedHashSet.class, ArrayList.class, new String[0]));
            ordinaryFileEntity.setProjectName(this.platformContext.getAppName());
            this.ordinaryFileRepository.save((Object)ordinaryFileEntity);
            result.setId(ordinaryFileEntity.getId());
            ordinaryFileVos.add(result);
        }
        return ordinaryFileVos;
    }

    @Transactional
    public List<OrdinaryFileVo> fileUpload(String subSystem, String creator, Integer effective, String[] fileNanmes, String[] base64Contents) {
        Validate.notBlank((CharSequence)creator, (String)"\u6587\u4ef6\u7684\u63d0\u4ea4\u4eba\u5fc5\u987b\u4f20\u5165\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        if (base64Contents == null || base64Contents.length == 0) {
            throw new IllegalArgumentException("\u9519\u8bef\u7684base64\u7f16\u7801\u6587\u4ef6\u5185\u5bb9!!");
        }
        if (fileNanmes == null || fileNanmes.length == 0) {
            throw new IllegalArgumentException("\u9519\u8bef\u7684\u6587\u4ef6\u540d\u6570\u91cf\u4fe1\u606f!!");
        }
        Validate.isTrue((fileNanmes.length == base64Contents.length ? 1 : 0) != 0, (String)"\u6587\u4ef6\u5185\u5bb9\u6570\u91cf\u548c\u6587\u4ef6\u540d\u6570\u91cf\u4e0d\u5339\u914d\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        LinkedList<OrdinaryFileVo> ordinaryFileVos = new LinkedList<OrdinaryFileVo>();
        for (int index = 0; index < fileNanmes.length; ++index) {
            String originalFilename = fileNanmes[index];
            this.validatePrefix(originalFilename);
            String base64Content = base64Contents[index];
            byte[] fileContext = Base64Utils.decodeFromString((String)base64Content);
            int prefixIndex = originalFilename.lastIndexOf(46);
            OrdinaryFileVo result = this.saveOrdinaryFile(prefixIndex, originalFilename, subSystem, effective, creator, fileContext);
            OrdinaryFileEntity ordinaryFileEntity = (OrdinaryFileEntity)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)result, OrdinaryFileEntity.class, LinkedHashSet.class, ArrayList.class, new String[0]));
            this.ordinaryFileRepository.save((Object)ordinaryFileEntity);
            result.setId(ordinaryFileEntity.getId());
            ordinaryFileVos.add(result);
        }
        return ordinaryFileVos;
    }

    private OrdinaryFileVo saveOrdinaryFile(int prefixIndex, String originalFilename, String subSystem, Integer effective, String creator, byte[] fileContext) {
        String prefix = null;
        if (prefixIndex != -1) {
            prefix = originalFilename.substring(prefixIndex + 1);
            prefix = prefix.toLowerCase();
        }
        String renameImage = UUID.randomUUID().toString();
        String relativePath = this.fileRelativeTemplate.generatRelativePath(subSystem, originalFilename);
        String fileRename = StringUtils.join((Object[])new String[]{renameImage, ".", prefix});
        return this.fileUpload(relativePath, originalFilename, fileRename, prefix, effective, creator, fileContext);
    }

    private void validatePrefix(String originalFilename) {
        int prefixIndex = originalFilename.lastIndexOf(46);
        Validate.isTrue((prefixIndex != -1 ? 1 : 0) != 0, (String)"\u5f53\u524d\u4e0a\u4f20\u7684\u6587\u4ef6\uff08%s\uff09\u5fc5\u987b\u643a\u5e26\u6587\u4ef6\u540e\u7f00\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[]{originalFilename});
        String prefix = originalFilename.substring(prefixIndex + 1);
        prefix = prefix.toLowerCase();
        if (!(!StringUtils.isBlank((CharSequence)prefix) && (StringUtils.equals((CharSequence)prefix, (CharSequence)"png") || StringUtils.equals((CharSequence)prefix, (CharSequence)"gif") || StringUtils.equals((CharSequence)prefix, (CharSequence)"jpg") || StringUtils.equals((CharSequence)prefix, (CharSequence)"jpeg") || StringUtils.equals((CharSequence)prefix, (CharSequence)"bmp") || StringUtils.equalsAnyIgnoreCase((CharSequence)prefix, (CharSequence[])this.whitePrefixs)))) {
            throw new IllegalArgumentException("\u53ea\u6709\u4f4d\u56fe\u6587\u4ef6(bmp/jpg/png/gif/white prefixs)\u548c\u5728\u6269\u5c55\u540d\u767d\u540d\u5355\u8bbe\u5b9a\u4e2d\u7684\u6587\u4ef6\uff0c\u624d\u80fd\u8fdb\u884c\u4e0a\u4f20\u7ba1\u7406!");
        }
    }

    private OrdinaryFileVo fileUpload(String relativePath, String originalFilename, String fileRename, String prefix, Integer effective, String creator, byte[] fileContext) {
        this.nebulaFileService.saveFile(relativePath, originalFilename, fileRename, fileContext);
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Date effectiveDate = null;
        try {
            effectiveDate = simpleDateFormat.parse("3999-01-01 00:00:00");
        }
        catch (ParseException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            throw new IllegalArgumentException(e.getMessage());
        }
        if (effective != null) {
            Validate.isTrue((effective > 0 ? 1 : 0) != 0, (String)"\u9519\u8bef\u7684\u6709\u6548\u671f\u65f6\u957f\uff08\u5355\u4f4d\u201c\u5929\u201d\uff09, \u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
            Calendar calendar = Calendar.getInstance();
            calendar.add(5, effective);
            effectiveDate = calendar.getTime();
        }
        OrdinaryFileEntity result = new OrdinaryFileEntity();
        result.setCommitUser(creator);
        result.setRelativeLocal(relativePath);
        result.setFileName(fileRename);
        result.setEffectiveDate(effectiveDate);
        result.setCreateDate(new Date());
        result.setOriginalFileName(originalFilename);
        result.setPrefix(prefix);
        return (OrdinaryFileVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)result, OrdinaryFileVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
    }

    public List<OrdinaryFileVo> findByEffectiveDate(Date currentDate) {
        if (currentDate == null) {
            return Collections.emptyList();
        }
        List<OrdinaryFileEntity> files = this.ordinaryFileRepository.findByEffectiveDate(currentDate, this.platformContext.getAppName());
        Collection collection = this.nebulaToolkitService.copyCollectionByWhiteList(files, OrdinaryFileEntity.class, OrdinaryFileVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        return new ArrayList<OrdinaryFileVo>(collection);
    }

    @Transactional
    public void updateEffective(String[] fileReNames) {
        if (fileReNames == null || fileReNames.length == 0) {
            return;
        }
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Date effectiveDate = null;
        try {
            effectiveDate = simpleDateFormat.parse("3999-01-01 00:00:00");
        }
        catch (ParseException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            throw new IllegalArgumentException(e.getMessage());
        }
        for (int index = 0; index < fileReNames.length; ++index) {
            String relativeLocal;
            String fileReNameItem = fileReNames[index];
            int targetIndex = fileReNameItem.lastIndexOf(47);
            String fileReName = fileReNameItem.substring(targetIndex + 1);
            OrdinaryFileEntity currentOrdinaryFile = this.ordinaryFileRepository.findByFileNameAndRelativeLocalAndProjectName(fileReName, relativeLocal = fileReNameItem.substring(0, targetIndex), this.platformContext.getAppName());
            if (currentOrdinaryFile == null) continue;
            currentOrdinaryFile.setEffectiveDate(effectiveDate);
            this.ordinaryFileRepository.save((Object)currentOrdinaryFile);
        }
    }

    @Transactional
    public void deleteFiles(String[] fileIds) {
        Validate.notNull((Object)fileIds, (String)"\u81f3\u5c11\u4f20\u5165\u4e00\u4e2a\u6587\u4ef6\u7684\u6570\u636e\u5e93\u7f16\u53f7\u4fe1\u606f!!", (Object[])new Object[0]);
        Validate.isTrue((fileIds.length > 0 ? 1 : 0) != 0, (String)"\u81f3\u5c11\u4f20\u5165\u4e00\u4e2a\u6587\u4ef6\u7684\u6570\u636e\u5e93\u7f16\u53f7\u4fe1\u606f!!", (Object[])new Object[0]);
        for (int index = 0; index < fileIds.length; ++index) {
            String fileId = fileIds[index];
            Optional op = this.ordinaryFileRepository.findById(fileId);
            OrdinaryFileEntity currentOrdinaryFile = op.orElse(null);
            if (currentOrdinaryFile == null) continue;
            this.nebulaFileService.deleteFile(currentOrdinaryFile.getRelativeLocal(), currentOrdinaryFile.getOriginalFileName(), currentOrdinaryFile.getFileName());
            this.ordinaryFileRepository.deleteById(fileId);
        }
    }

    @Transactional
    public void deleteFile(String filePath, String fileName) {
        Validate.notNull((Object)filePath, (String)"\u6587\u4ef6\u8def\u5f84\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)fileName, (String)"\u6587\u4ef6\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        OrdinaryFileEntity file = this.ordinaryFileRepository.findByFileNameAndRelativeLocalAndProjectName(fileName, StringUtils.trim((String)filePath), this.platformContext.getAppName());
        Validate.notNull((Object)((Object)file), (String)"\u5220\u9664\u7684\u6587\u4ef6\u4e0d\u5b58\u5728", (Object[])new Object[0]);
        this.nebulaFileService.deleteFile(file.getRelativeLocal(), file.getOriginalFileName(), file.getFileName());
        this.ordinaryFileRepository.delete((Object)file);
    }

    @Transactional
    public List<OrdinaryFileVo> fileImageUpload(String subsystem, String creator, Integer effective, MultipartFile[] files) {
        Validate.notNull((Object)(files != null && files.length > 0 ? 1 : 0), (String)"\u4e0a\u4f20\u7684\u56fe\u7247\u6587\u4ef6\u4fe1\u606f\u81f3\u5c11\u6709\u4e00\u4e2a\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)creator, (String)"\u56fe\u7247\u6587\u4ef6\u7684\u63d0\u4ea4\u4eba\u5fc5\u987b\u4f20\u5165\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        for (MultipartFile file : files) {
            String originalFilename = file.getOriginalFilename();
            String prefix = null;
            int prefixIndex = originalFilename.lastIndexOf(46);
            if (prefixIndex != -1) {
                prefix = originalFilename.substring(prefixIndex + 1);
                prefix = prefix.toLowerCase();
            }
            if (!StringUtils.isBlank(prefix) && (StringUtils.equals((CharSequence)prefix, (CharSequence)"png") || StringUtils.equals((CharSequence)prefix, (CharSequence)"gif") || StringUtils.equals((CharSequence)prefix, (CharSequence)"jpg") || StringUtils.equals((CharSequence)prefix, (CharSequence)"jpeg") || StringUtils.equals((CharSequence)prefix, (CharSequence)"bmp") || StringUtils.equalsAnyIgnoreCase((CharSequence)prefix, (CharSequence[])this.whitePrefixs))) continue;
            throw new IllegalArgumentException("file prefix not be support it(bmp/jpg/png/gif/white prefixs)!");
        }
        return this.fileUpload(subsystem, creator, effective, files);
    }

    public List<OrdinaryFileVo> fileImageUpload(String subsystem, String creator, Integer effective, String[] fileNanmes, String[] base64Contents) {
        Validate.notBlank((CharSequence)creator, (String)"\u56fe\u7247\u6587\u4ef6\u7684\u63d0\u4ea4\u4eba\u5fc5\u987b\u4f20\u5165\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        if (base64Contents == null || base64Contents.length == 0) {
            throw new IllegalArgumentException("\u9519\u8bef\u7684base64\u7f16\u7801\u6587\u4ef6\u5185\u5bb9!!");
        }
        if (fileNanmes == null || fileNanmes.length == 0) {
            throw new IllegalArgumentException("\u9519\u8bef\u7684\u6587\u4ef6\u540d\u6570\u91cf\u4fe1\u606f!!");
        }
        Validate.isTrue((fileNanmes.length == base64Contents.length ? 1 : 0) != 0, (String)"\u6587\u4ef6\u5185\u5bb9\u6570\u91cf\u548c\u6587\u4ef6\u540d\u6570\u91cf\u4e0d\u5339\u914d\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        for (int index = 0; index < fileNanmes.length; ++index) {
            String originalFilename = fileNanmes[index];
            String prefix = null;
            int prefixIndex = originalFilename.lastIndexOf(46);
            if (prefixIndex != -1) {
                prefix = originalFilename.substring(prefixIndex + 1);
                prefix = prefix.toLowerCase();
            }
            if (!StringUtils.isBlank(prefix) && (StringUtils.equals((CharSequence)prefix, (CharSequence)"png") || StringUtils.equals((CharSequence)prefix, (CharSequence)"gif") || StringUtils.equals((CharSequence)prefix, (CharSequence)"jpg") || StringUtils.equals((CharSequence)prefix, (CharSequence)"jpeg") || StringUtils.equals((CharSequence)prefix, (CharSequence)"bmp") || StringUtils.equalsAnyIgnoreCase((CharSequence)prefix, (CharSequence[])this.whitePrefixs))) continue;
            throw new IllegalArgumentException("file prefix not be support it(bmp/jpg/png/gif/white prefixs)!");
        }
        return this.fileUpload(subsystem, creator, effective, fileNanmes, base64Contents);
    }
}

