/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.activiti.model.diagram;

import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.imageio.ImageIO;
import org.activiti.bpmn.model.BpmnModel;
import org.activiti.engine.history.HistoricActivityInstance;
import org.activiti.engine.impl.HistoricActivityInstanceQueryImpl;
import org.activiti.engine.impl.Page;
import org.activiti.engine.impl.cmd.GetBpmnModelCmd;
import org.activiti.engine.impl.cmd.GetDeploymentProcessDefinitionCmd;
import org.activiti.engine.impl.context.Context;
import org.activiti.engine.impl.persistence.entity.HistoricProcessInstanceEntity;
import org.activiti.engine.impl.persistence.entity.ProcessDefinitionEntity;
import org.activiti.engine.impl.pvm.process.ActivityImpl;
import org.apache.commons.io.FilenameUtils;

public class CustomProcessDiagramPositionGenerator {
    public static final int OFFSET_SUBPROCESS = 5;
    public static final int OFFSET_TASK = 20;
    private static List<String> taskType = new ArrayList<String>();
    private static List<String> eventType = new ArrayList<String>();
    private static List<String> gatewayType = new ArrayList<String>();
    private static List<String> subProcessType = new ArrayList<String>();

    public CustomProcessDiagramPositionGenerator() {
        CustomProcessDiagramPositionGenerator.init();
    }

    protected static void init() {
        taskType.add("manualTask");
        taskType.add("receiveTask");
        taskType.add("scriptTask");
        taskType.add("sendTask");
        taskType.add("serviceTask");
        taskType.add("userTask");
        gatewayType.add("exclusiveGateway");
        gatewayType.add("inclusiveGateway");
        gatewayType.add("eventBasedGateway");
        gatewayType.add("parallelGateway");
        eventType.add("intermediateTimer");
        eventType.add("intermediateMessageCatch");
        eventType.add("intermediateSignalCatch");
        eventType.add("intermediateSignalThrow");
        eventType.add("messageStartEvent");
        eventType.add("startTimerEvent");
        eventType.add("error");
        eventType.add("startEvent");
        eventType.add("errorEndEvent");
        eventType.add("endEvent");
        subProcessType.add("subProcess");
        subProcessType.add("callActivity");
    }

    public List<ActivityImpl> generateDiagram(String processInstanceId) throws IOException {
        HistoricProcessInstanceEntity historicProcessInstance = Context.getCommandContext().getHistoricProcessInstanceEntityManager().findHistoricProcessInstance(processInstanceId);
        String processDefinitionId = historicProcessInstance.getProcessDefinitionId();
        GetBpmnModelCmd getBpmnModelCmd = new GetBpmnModelCmd(processDefinitionId);
        BpmnModel bpmnModel = getBpmnModelCmd.execute(Context.getCommandContext());
        bpmnModel.getLocationMap();
        ProcessDefinitionEntity definition = new GetDeploymentProcessDefinitionCmd(processDefinitionId).execute(Context.getCommandContext());
        String diagramResourceName = definition.getDiagramResourceName();
        String deploymentId = definition.getDeploymentId();
        byte[] bytes = Context.getCommandContext().getResourceEntityManager().findResourceByDeploymentIdAndResourceName(deploymentId, diagramResourceName).getBytes();
        ByteArrayInputStream originDiagram = new ByteArrayInputStream(bytes);
        BufferedImage image = ImageIO.read(originDiagram);
        HistoricActivityInstanceQueryImpl historicActivityInstanceQueryImpl = new HistoricActivityInstanceQueryImpl();
        historicActivityInstanceQueryImpl.processInstanceId(processInstanceId).orderByHistoricActivityInstanceStartTime().asc();
        Page page = new Page(0, 100);
        List activityInstances = Context.getCommandContext().getHistoricActivityInstanceEntityManager().findHistoricActivityInstancesByQueryCriteria(historicActivityInstanceQueryImpl, page);
        ArrayList<ActivityImpl> listResult = new ArrayList<ActivityImpl>();
        for (HistoricActivityInstance historicActivityInstance : activityInstances) {
            String historicActivityId = historicActivityInstance.getActivityId();
            String activityTypeName = historicActivityInstance.getActivityType();
            ActivityImpl activity = definition.findActivity(historicActivityId);
            if (activity == null || historicActivityInstance.getEndTime() == null || !activityTypeName.equals("userTask")) continue;
            listResult.add(activity);
        }
        return listResult;
    }

    private static String getDiagramExtension(String diagramResourceName) {
        return FilenameUtils.getExtension((String)diagramResourceName);
    }
}

