/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.activiti.runtime.controller;

import com.biz.eisp.activiti.common.WorkFlowGlobals;
import com.biz.eisp.activiti.runtime.service.TaRejectRecordService;
import com.biz.eisp.activiti.runtime.service.TaTaskService;
import com.biz.eisp.activiti.runtime.vo.CommentVo;
import com.biz.eisp.activiti.runtime.vo.HistoryTaskVo;
import com.biz.eisp.activiti.runtime.vo.MyTaskVo;
import com.biz.eisp.activiti.runtime.vo.OperationVo;
import com.biz.eisp.activiti.runtime.vo.TaRejectRecordVo;
import com.biz.eisp.base.common.exception.BusinessException;
import com.biz.eisp.base.common.jsonmodel.AjaxJson;
import com.biz.eisp.base.common.jsonmodel.DataGrid;
import com.biz.eisp.base.common.util.ResourceUtil;
import com.biz.eisp.base.core.page.EuPage;
import com.biz.eisp.base.core.web.BaseController;
import com.biz.eisp.mdm.position.vo.TmPositionVo;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

@Controller
@RequestMapping(value={"/taTaskController"})
public class TaTaskController
extends BaseController {
    @Autowired
    private TaTaskService taTaskService;
    @Autowired
    private TaRejectRecordService taRejectRecordService;

    @RequestMapping(params={"goMyTaskMain"})
    public ModelAndView goMyTaskMain(HttpServletRequest request) {
        return new ModelAndView("com/biz/eisp/activiti/task/myTaskMain");
    }

    @RequestMapping(params={"findMyTaskList"})
    @ResponseBody
    public DataGrid findMyTaskList(MyTaskVo myTaskVo, String time, HttpServletRequest request, HttpServletResponse response) {
        EuPage page = new EuPage(request);
        String positionCode = ResourceUtil.getCurrPosition().getPositionCode();
        myTaskVo.setAssignee(positionCode);
        myTaskVo.setCreateTime(time);
        List<MyTaskVo> taskList = this.taTaskService.findMyTaskList(myTaskVo, page);
        return new DataGrid(taskList, page);
    }

    @RequestMapping(params={"goMyHistoryTaskMain"})
    public ModelAndView goMyHistoryTaskMain(HttpServletRequest request) {
        return new ModelAndView("com/biz/eisp/activiti/task/myHistoryTaskMain");
    }

    @RequestMapping(params={"findMyHistoryTaskList"})
    @ResponseBody
    public DataGrid findMyHistoryTaskList(HistoryTaskVo historyTaskVo, HttpServletRequest request, HttpServletResponse response) {
        EuPage page = new EuPage(request);
        TmPositionVo tmPositionVo = ResourceUtil.getCurrPosition();
        historyTaskVo.setAssignee(tmPositionVo.getPositionCode());
        List<HistoryTaskVo> taskList = this.taTaskService.findMyHistoryTaskList(historyTaskVo, page);
        return new DataGrid(taskList, page);
    }

    @RequestMapping(params={"findMyRejectTaskList"})
    @ResponseBody
    public DataGrid findMyRejectTaskList(TaRejectRecordVo taRejectRecordVo, HttpServletRequest request, HttpServletResponse response) {
        EuPage page = new EuPage(request);
        TmPositionVo tmPositionVo = ResourceUtil.getCurrPosition();
        taRejectRecordVo.setAssignee(tmPositionVo.getPositionCode());
        List<TaRejectRecordVo> voList = this.taRejectRecordService.findMyRejectTaskList(taRejectRecordVo, page);
        return new DataGrid(voList, page);
    }

    @RequestMapping(params={"goInstanceHandleTabForm"})
    public ModelAndView goInstanceHandleTabForm(MyTaskVo myTaskVo, @RequestParam(value="isView") boolean isView, @RequestParam(value="isReadFlag") boolean isReadFlag, String recordId, HttpServletRequest request) {
        String taskId = myTaskVo.getTaskId();
        String processInstanceId = myTaskVo.getProcessInstanceId();
        request.setAttribute("taskId", (Object)taskId);
        request.setAttribute("processInstanceId", (Object)processInstanceId);
        request.setAttribute("isView", (Object)isView);
        request.setAttribute("isReadFlag", (Object)isReadFlag);
        request.setAttribute("recordId", (Object)recordId);
        return new ModelAndView("com/biz/eisp/activiti/task/taskHandleTabForm");
    }

    @RequestMapping(params={"goTaskBusinessForm"})
    public ModelAndView goTaskBusinessForm(MyTaskVo myTaskVo, HttpServletRequest request) {
        String taskId = myTaskVo.getTaskId();
        String modelAndView = null;
        modelAndView = StringUtils.isBlank((CharSequence)taskId) ? this.taTaskService.getProcessInstanceBusinessForm(myTaskVo.getProcessInstanceId()) : this.taTaskService.getTaskBusinessForm(taskId);
        request.setAttribute(WorkFlowGlobals.PROCNODE_START, (Object)modelAndView);
        return new ModelAndView("com/biz/eisp/activiti/task/taskBusinessForm");
    }

    @RequestMapping(params={"goTaskOperateForm"})
    public ModelAndView goTaskOperateForm(MyTaskVo myTaskVo, @RequestParam(value="isView") boolean isView, @RequestParam(value="isReadFlag") boolean isReadFlag, String recordId, HttpServletRequest request) {
        String taskId = myTaskVo.getTaskId();
        String processInstanceId = myTaskVo.getProcessInstanceId();
        if (StringUtils.isBlank((CharSequence)processInstanceId)) {
            throw new BusinessException("\u6d41\u7a0b\u5b9e\u4f8bID\u4e22\u5931");
        }
        List<CommentVo> list = this.taTaskService.findActHiCommentEntity(processInstanceId);
        if (!isView) {
            boolean hasRejectNodes = this.taTaskService.hasRejectNodes(taskId, processInstanceId);
            request.setAttribute("hasRejectNodes", (Object)hasRejectNodes);
            request.setAttribute("isView", (Object)isView);
        }
        request.setAttribute("taskId", (Object)taskId);
        request.setAttribute("processInstanceId", (Object)processInstanceId);
        request.setAttribute("voList", list);
        request.setAttribute("isReadFlag", (Object)isReadFlag);
        request.setAttribute("recordId", (Object)recordId);
        return new ModelAndView("com/biz/eisp/activiti/task/taskOperateForm");
    }

    @RequestMapping(params={"saveComplete"})
    @ResponseBody
    public AjaxJson saveComplete(OperationVo operationVo, HttpServletRequest request, HttpServletResponse response) {
        try {
            this.taTaskService.saveCompelte(operationVo);
        }
        catch (Exception e) {
            e.printStackTrace();
            return new AjaxJson("\u4efb\u52a1\u5904\u7406\u5931\u8d25\uff1a" + e.getMessage());
        }
        return new AjaxJson();
    }

    @RequestMapping(params={"saveReject"})
    @ResponseBody
    public AjaxJson saveReject(OperationVo operationVo, HttpServletRequest request, HttpServletResponse response) {
        try {
            this.taTaskService.saveReject(operationVo);
        }
        catch (Exception e) {
            e.printStackTrace();
            return new AjaxJson("\u4efb\u52a1\u5904\u7406\u5931\u8d25\uff1a" + e.getMessage());
        }
        return new AjaxJson();
    }

    @RequestMapping(params={"saveRejectToApply"})
    @ResponseBody
    public AjaxJson saveRejectToApply(OperationVo operationVo, HttpServletRequest request, HttpServletResponse response) {
        try {
            this.taTaskService.saveRejectToApply(operationVo);
        }
        catch (Exception e) {
            e.printStackTrace();
            return new AjaxJson("\u4efb\u52a1\u5904\u7406\u5931\u8d25\uff1a" + e.getMessage());
        }
        return new AjaxJson();
    }

    @RequestMapping(params={"saveReadRejectStatus"})
    @ResponseBody
    public AjaxJson saveReadRejectStatus(String recordId, HttpServletRequest request, HttpServletResponse response) {
        try {
            this.taRejectRecordService.updateTaRejectRecordStatus(recordId);
        }
        catch (Exception e) {
            e.printStackTrace();
            return new AjaxJson("\u4efb\u52a1\u5904\u7406\u5931\u8d25\uff1a" + e.getMessage());
        }
        return new AjaxJson();
    }

    @RequestMapping(params={"goReassignForm"})
    public ModelAndView goReassignForm(MyTaskVo myTaskVo, HttpServletRequest request) {
        String taskId = myTaskVo.getTaskId();
        request.setAttribute("taskId", (Object)taskId);
        return new ModelAndView("com/biz/eisp/activiti/task/reassignForm");
    }

    @RequestMapping(params={"reassign"})
    @ResponseBody
    public AjaxJson reassign(MyTaskVo myTaskVo, String reassignComment, HttpServletRequest request, HttpServletResponse response) {
        try {
            String reassignPositionCode = request.getParameter("id");
            this.taTaskService.reassign(myTaskVo, reassignComment, reassignPositionCode);
            return new AjaxJson();
        }
        catch (Exception e) {
            e.printStackTrace();
            return new AjaxJson(e.getMessage());
        }
    }

    @RequestMapping(params={"goPositionList"})
    public ModelAndView goPositionList(MyTaskVo myTaskVo, HttpServletRequest request) {
        String taskId = myTaskVo.getTaskId();
        request.setAttribute("taskId", (Object)taskId);
        return new ModelAndView("com/biz/eisp/activiti/task/positionList");
    }

    @RequestMapping(params={"goTaskAbstractForm"})
    public ModelAndView goTaskAbstractForm(MyTaskVo myTaskVo, HttpServletRequest request) {
        this.taTaskService.findProcessBasicInfoByProcinstId(myTaskVo, request);
        this.taTaskService.findAttachmentListByProcinstId(myTaskVo.getProcessInstanceId(), request);
        return new ModelAndView("com/biz/eisp/activiti/task/taskAbstractForm");
    }

    @RequestMapping(params={"goTaskDetailForm"})
    public ModelAndView goTaskDetailForm(MyTaskVo myTaskVo, HttpServletRequest request, @RequestParam(value="isView") boolean isView) {
        request.setAttribute("taskId", (Object)myTaskVo.getTaskId());
        request.setAttribute("processInstanceId", (Object)myTaskVo.getProcessInstanceId());
        request.setAttribute("isReadFlag", (Object)request.getParameter("isReadFlag"));
        request.setAttribute("isView", (Object)isView);
        if (!isView) {
            boolean hasRejectNodes = this.taTaskService.hasRejectNodes(myTaskVo.getTaskId(), myTaskVo.getProcessInstanceId());
            request.setAttribute("hasRejectNodes", (Object)hasRejectNodes);
            this.taTaskService.findRejectNode(myTaskVo.getTaskId(), myTaskVo.getProcessInstanceId(), request);
        }
        this.taTaskService.findKeyIndicators(myTaskVo, request);
        this.taTaskService.findApprovalLogs(myTaskVo, request);
        return new ModelAndView("com/biz/eisp/activiti/task/taskDetailForm");
    }
}

