/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.activiti.runtime.service.impl;

import com.biz.eisp.activiti.common.WorkFlowGlobals;
import com.biz.eisp.activiti.designer.businessconf.entity.TaProcessBusinessObjConfigEntity;
import com.biz.eisp.activiti.designer.businessconf.vo.TaProcessBusinessObjConfigVo;
import com.biz.eisp.activiti.model.diagram.HistoryProcessInstanceDiagramCmd;
import com.biz.eisp.activiti.model.diagram.HistoryProcessInstanceDiagramPositionCmd;
import com.biz.eisp.activiti.runtime.dao.TaProcessInstanceDao;
import com.biz.eisp.activiti.runtime.entity.TaBaseBusinessObjEntity;
import com.biz.eisp.activiti.runtime.entity.TaBaseBusinessObjQueryEntity;
import com.biz.eisp.activiti.runtime.entity.TaProcessApprovalLogEntity;
import com.biz.eisp.activiti.runtime.entity.TaRuntimeStatusEntity;
import com.biz.eisp.activiti.runtime.service.TaProcessInstanceService;
import com.biz.eisp.activiti.runtime.transformer.HistoricTaskInstanceToHistoryTaskVo;
import com.biz.eisp.activiti.runtime.vo.HistoryTaskVo;
import com.biz.eisp.activiti.runtime.vo.MyInstanceVo;
import com.biz.eisp.activiti.runtime.vo.ProcessInstanceVo;
import com.biz.eisp.activiti.util.CommentUtil;
import com.biz.eisp.base.common.exception.BusinessException;
import com.biz.eisp.base.common.util.ResourceUtil;
import com.biz.eisp.base.common.util.StringUtil;
import com.biz.eisp.base.core.page.Page;
import com.biz.eisp.base.core.service.impl.BaseServiceImpl;
import com.biz.eisp.base.utils.DateUtils;
import com.biz.eisp.mdm.position.entity.TmPositionEntity;
import com.biz.eisp.mdm.user.entity.TmUserEntity;
import com.biz.eisp.mdm.user.service.TmUserService;
import com.biz.eisp.mdm.user.vo.UserInfoEntity;
import com.biz.eisp.mdm.web.pojo.Client;
import com.biz.eisp.mdm.web.pojo.ClientManager;
import com.google.common.base.Function;
import com.google.common.collect.Lists;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.activiti.engine.HistoryService;
import org.activiti.engine.IdentityService;
import org.activiti.engine.ProcessEngine;
import org.activiti.engine.ProcessEngines;
import org.activiti.engine.RepositoryService;
import org.activiti.engine.RuntimeService;
import org.activiti.engine.TaskService;
import org.activiti.engine.impl.interceptor.Command;
import org.activiti.engine.impl.persistence.entity.ExecutionEntity;
import org.activiti.engine.impl.pvm.process.ActivityImpl;
import org.activiti.engine.runtime.Execution;
import org.activiti.engine.runtime.ProcessInstance;
import org.activiti.engine.task.Task;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="taProcessInstanceService")
@Transactional
public class TaProcessInstanceServiceImpl
extends BaseServiceImpl
implements TaProcessInstanceService {
    @Autowired
    private IdentityService identityService;
    @Autowired
    private RuntimeService runtimeService;
    @Autowired
    private HistoryService historyService;
    @Autowired(required=false)
    private RepositoryService repositoryService;
    @Autowired
    private TaskService taskService;
    @Autowired
    private TaProcessInstanceDao taProcessInstanceDao;
    @Autowired
    private TmUserService tmUserService;

    private UserInfoEntity findUserInfo(String posId) {
        UserInfoEntity userInfoEntity = this.tmUserService.findUserInfoEntityByPosId(posId);
        return userInfoEntity;
    }

    private String getCreateName(String posId) {
        if (StringUtil.isNotEmpty((String)ResourceUtil.getCreateName())) {
            return ResourceUtil.getCreateName();
        }
        UserInfoEntity userInfoEntity = this.findUserInfo(posId);
        if (StringUtil.isNotEmpty(userInfoEntity)) {
            return String.valueOf(userInfoEntity.getRealName()) + "(" + userInfoEntity.getPosName() + ")";
        }
        return "";
    }

    @Override
    public void saveStartWorkflow(String processKey, String positionCode, String businessKey, Map<String, Object> variables) {
        this.identityService.setAuthenticatedUserId(positionCode);
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey(processKey, businessKey, variables);
        this.taskService.addComment(null, processInstance.getId(), CommentUtil.buildApplyComment(ResourceUtil.getCreateName()));
        TmUserEntity user = ClientManager.getInstance().getClient().getUser();
        TaProcessApprovalLogEntity log = new TaProcessApprovalLogEntity();
        log.setCreateDate(new Date());
        log.setAccount(user.getUserName());
        log.setContent("\u53d1\u8d77\u6d41\u7a0b");
        log.setName(user.getFullName());
        log.setProcessInstId(processInstance.getId());
        try {
            log.setTaskDefKey(null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        log.setType(1);
        this.save(log);
        TaBaseBusinessObjEntity taBaseBusinessObjEntity = this.get(TaBaseBusinessObjEntity.class, (Serializable)((Object)businessKey));
        TaRuntimeStatusEntity runStatus = this.findUniqueByProperty(TaRuntimeStatusEntity.class, "code", "doing");
        taBaseBusinessObjEntity.setTaRuntimeStatusEntity(runStatus);
        this.saveOrUpdate(taBaseBusinessObjEntity);
    }

    @Override
    public void saveStartWorkflow(TaProcessBusinessObjConfigVo configVo, TaBaseBusinessObjEntity baseEntity) {
        TaProcessBusinessObjConfigEntity taProcessBusinessObjConfigEntity = this.get(TaProcessBusinessObjConfigEntity.class, (Serializable)((Object)configVo.getId()));
        if (taProcessBusinessObjConfigEntity != null) {
            TaBaseBusinessObjEntity taBaseBusinessObjEntity = baseEntity;
            TaRuntimeStatusEntity runtimeStatusEntity = this.findUniqueByProperty(TaRuntimeStatusEntity.class, "code", "new");
            TaRuntimeStatusEntity rejectRuntimeStatusEntity = this.findUniqueByProperty(TaRuntimeStatusEntity.class, "code", "reject");
            TaRuntimeStatusEntity businessObjRuntimeStatus = taBaseBusinessObjEntity.getTaRuntimeStatusEntity();
            if (businessObjRuntimeStatus.getCode().equals(rejectRuntimeStatusEntity.getCode())) {
                Map<String, Object> variables = configVo.getVariables();
                this.saveStartWorkflow(taBaseBusinessObjEntity, variables, taProcessBusinessObjConfigEntity);
                TaRuntimeStatusEntity runStatus = this.findUniqueByProperty(TaRuntimeStatusEntity.class, "code", "doing");
                taBaseBusinessObjEntity.setTaRuntimeStatusEntity(runStatus);
                this.saveOrUpdate(taBaseBusinessObjEntity);
            } else if (businessObjRuntimeStatus.getCode().equals(runtimeStatusEntity.getCode())) {
                Map<String, Object> variables = configVo.getVariables();
                this.saveStartWorkflow(taBaseBusinessObjEntity, variables, taProcessBusinessObjConfigEntity);
                TaRuntimeStatusEntity runStatus = this.findUniqueByProperty(TaRuntimeStatusEntity.class, "code", "doing");
                taBaseBusinessObjEntity.setTaRuntimeStatusEntity(runStatus);
                this.saveOrUpdate(taBaseBusinessObjEntity);
            } else {
                throw new BusinessException("\u5df2\u7ecf\u5728\u6d41\u7a0b\u529e\u7406\u4e2d");
            }
        }
    }

    @Override
    public ProcessInstance saveStartWorkflow(TaBaseBusinessObjEntity baseEntity, Map<String, Object> variables, TaProcessBusinessObjConfigEntity configEntity) {
        TmPositionEntity tmPositionEntity = baseEntity.getTmPositionEntity();
        this.identityService.setAuthenticatedUserId(tmPositionEntity.getPositionCode());
        String processKey = configEntity.getTaProcessEntity().getProcessKey();
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey(processKey, baseEntity.getId(), variables);
        Client client = ClientManager.getInstance().getClient();
        TmUserEntity user = null;
        if (StringUtil.isEmpty(client)) {
            UserInfoEntity userInfoEntity = this.findUserInfo(tmPositionEntity.getId());
            user = new TmUserEntity();
            user.setUserName(userInfoEntity.getUserName());
            user.setFullName(userInfoEntity.getRealName());
        } else {
            user = client.getUser();
        }
        TaProcessApprovalLogEntity log = new TaProcessApprovalLogEntity();
        log.setCreateDate(new Date());
        log.setAccount(user.getUserName());
        log.setContent("\u53d1\u8d77\u6d41\u7a0b");
        log.setName(user.getFullName());
        log.setProcessInstId(processInstance.getId());
        try {
            log.setTaskDefKey(null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        log.setType(1);
        this.save(log);
        return processInstance;
    }

    @Override
    public ProcessInstance saveStartWorkflow(TaBaseBusinessObjQueryEntity taBaseBusinessObjEntity, String businessObjId, Map<String, Object> variables, TaProcessBusinessObjConfigEntity taProcessBusinessObjConfigEntity) {
        TmPositionEntity tmPositionEntity = taBaseBusinessObjEntity.getTmPositionEntity();
        this.identityService.setAuthenticatedUserId(tmPositionEntity.getPositionCode());
        String processKey = taProcessBusinessObjConfigEntity.getTaProcessEntity().getProcessKey();
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey(processKey, businessObjId, variables);
        this.taskService.addComment(null, processInstance.getId(), CommentUtil.buildApplyComment(ResourceUtil.getCreateName()));
        TmUserEntity user = ClientManager.getInstance().getClient().getUser();
        TaProcessApprovalLogEntity log = new TaProcessApprovalLogEntity();
        log.setCreateDate(new Date());
        log.setAccount(user.getUserName());
        log.setContent("\u53d1\u8d77\u6d41\u7a0b");
        log.setName(user.getFullName());
        log.setProcessInstId(processInstance.getId());
        try {
            log.setTaskDefKey(null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        log.setType(1);
        this.save(log);
        return processInstance;
    }

    @Override
    public void saveStartWorkflow(TaProcessBusinessObjConfigVo taProcessBusinessObjConfigVo) {
        TaProcessBusinessObjConfigEntity taProcessBusinessObjConfigEntity = this.get(TaProcessBusinessObjConfigEntity.class, (Serializable)((Object)taProcessBusinessObjConfigVo.getId()));
        if (taProcessBusinessObjConfigEntity != null) {
            TaBaseBusinessObjQueryEntity taBaseBusinessObjEntity = this.get(TaBaseBusinessObjQueryEntity.class, (Serializable)((Object)taProcessBusinessObjConfigVo.getBusinessObjId()));
            TaRuntimeStatusEntity runtimeStatusEntity = this.findUniqueByProperty(TaRuntimeStatusEntity.class, "code", "new");
            TaRuntimeStatusEntity rejectRuntimeStatusEntity = this.findUniqueByProperty(TaRuntimeStatusEntity.class, "code", "reject");
            TaRuntimeStatusEntity recoverRuntimeStatusEntity = this.findUniqueByProperty(TaRuntimeStatusEntity.class, "code", "recover");
            TaRuntimeStatusEntity businessObjRuntimeStatus = taBaseBusinessObjEntity.getTaRuntimeStatusEntity();
            if (businessObjRuntimeStatus.getCode().equals(rejectRuntimeStatusEntity.getCode()) || businessObjRuntimeStatus.getCode().equals(recoverRuntimeStatusEntity.getCode())) {
                Map<String, Object> variables = taProcessBusinessObjConfigVo.getVariables();
                this.saveStartWorkflow(taBaseBusinessObjEntity, taProcessBusinessObjConfigVo.getBusinessObjId(), variables, taProcessBusinessObjConfigEntity);
                TaRuntimeStatusEntity runtimeStatusEntity1 = this.findUniqueByProperty(TaRuntimeStatusEntity.class, "code", "doing");
                taBaseBusinessObjEntity.setTaRuntimeStatusEntity(runtimeStatusEntity1);
                this.saveOrUpdate(taBaseBusinessObjEntity);
            } else if (businessObjRuntimeStatus.getCode().equals(runtimeStatusEntity.getCode())) {
                Map<String, Object> variables = taProcessBusinessObjConfigVo.getVariables();
                this.saveStartWorkflow(taBaseBusinessObjEntity, taProcessBusinessObjConfigVo.getBusinessObjId(), variables, taProcessBusinessObjConfigEntity);
                TaRuntimeStatusEntity runtimeStatusEntity1 = this.findUniqueByProperty(TaRuntimeStatusEntity.class, "code", "doing");
                taBaseBusinessObjEntity.setTaRuntimeStatusEntity(runtimeStatusEntity1);
                this.saveOrUpdate(taBaseBusinessObjEntity);
            } else {
                throw new BusinessException("\u5df2\u7ecf\u5728\u6d41\u7a0b\u529e\u7406\u4e2d");
            }
        }
    }

    @Override
    public List<MyInstanceVo> findMyStartedProcessList(MyInstanceVo myInstanceVo, Page page) {
        List<MyInstanceVo> myInstanceVoList = this.taProcessInstanceDao.findMyStartedProcessList(myInstanceVo, page);
        this.calSpendTimes(myInstanceVoList);
        return myInstanceVoList;
    }

    private void calSpendTimes(List<MyInstanceVo> myInstanceVoList) {
        if (myInstanceVoList != null) {
            for (MyInstanceVo vo : myInstanceVoList) {
                vo.setSpendTimes(DateUtils.calSpendTimes(vo.getStartTime(), vo.getEndTime()));
            }
        }
    }

    @Override
    public List<ProcessInstanceVo> findProcessInstanceList(ProcessInstanceVo processInstanceVo, Page page) {
        List<ProcessInstanceVo> processInstanceVoList = this.taProcessInstanceDao.findProcessInstanceList(processInstanceVo, page);
        this.calProcessInstanceSpendTimes(processInstanceVoList);
        return processInstanceVoList;
    }

    private void calProcessInstanceSpendTimes(List<ProcessInstanceVo> processInstanceVoList) {
        if (processInstanceVoList != null) {
            for (ProcessInstanceVo processInstanceVo : processInstanceVoList) {
            }
        }
    }

    @Override
    public InputStream getProcessInstancePicInfo(String processInstanceId) {
        HistoryProcessInstanceDiagramCmd cmd = new HistoryProcessInstanceDiagramCmd(processInstanceId);
        ProcessEngine processEngine = ProcessEngines.getDefaultProcessEngine();
        InputStream is = (InputStream)processEngine.getManagementService().executeCommand((Command)cmd);
        return is;
    }

    @Override
    public String getProcessInstanceIdByTaskId(String taskId) {
        Task task = (Task)this.taskService.createTaskQuery().taskId(taskId).singleResult();
        return task.getProcessInstanceId();
    }

    public List<String> highLight(String processInstanceId) {
        ArrayList<String> highLihth = new ArrayList<String>();
        List executions = this.runtimeService.createExecutionQuery().processInstanceId(processInstanceId).list();
        for (Execution execution : executions) {
            ExecutionEntity entity = (ExecutionEntity)this.runtimeService.createExecutionQuery().executionId(execution.getId()).singleResult();
            highLihth.add(entity.getActivityId());
        }
        return highLihth;
    }

    @Override
    public List<HistoryTaskVo> findProcessInstanceHistoryTaskList(HistoryTaskVo historyTaskVo, Page page) {
        String processInstanceId = historyTaskVo.getProcessInstanceId();
        if (StringUtils.isBlank((CharSequence)processInstanceId)) {
            throw new BusinessException("\u6d41\u7a0b\u5b9e\u4f8bID\uff08processInstanceId\uff09\u4e3a\u7a7a");
        }
        List historicTaskInstanceList = this.historyService.createHistoricTaskInstanceQuery().processInstanceId(processInstanceId).list();
        List voList = Lists.transform((List)historicTaskInstanceList, (Function)new HistoricTaskInstanceToHistoryTaskVo());
        return voList;
    }

    @Override
    public List<ActivityImpl> findDiagramPositionList(String processInstanceId) {
        HistoryProcessInstanceDiagramPositionCmd cmd = new HistoryProcessInstanceDiagramPositionCmd(processInstanceId);
        ProcessEngine processEngine = ProcessEngines.getDefaultProcessEngine();
        List list = (List)processEngine.getManagementService().executeCommand((Command)cmd);
        return list;
    }

    @Override
    public void deleteProcessInstance(MyInstanceVo myInstanceVo) {
        String createName = ResourceUtil.getCreateName();
        this.runtimeService.deleteProcessInstance(myInstanceVo.getProcessInstanceId(), "\u53d1\u8d77\u4eba" + createName + "\u5220\u9664\u6d41\u7a0b\u5b9e\u4f8b");
    }

    @Override
    public void suspendProcessInstance(MyInstanceVo myInstanceVo) {
        this.runtimeService.suspendProcessInstanceById(myInstanceVo.getProcessInstanceId());
    }

    @Override
    public void activateProcessInstance(MyInstanceVo myInstanceVo) {
        this.runtimeService.activateProcessInstanceById(myInstanceVo.getProcessInstanceId());
    }

    @Override
    public void callBackProcess(MyInstanceVo myInstanceVo) {
        String createName = ResourceUtil.getCreateName();
        ProcessInstance pi = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().processInstanceId(myInstanceVo.getProcessInstanceId()).singleResult();
        Execution execution = (Execution)this.runtimeService.createExecutionQuery().processInstanceId(myInstanceVo.getProcessInstanceId()).singleResult();
        String businessObjId = pi.getBusinessKey();
        TaBaseBusinessObjQueryEntity entity = this.get(TaBaseBusinessObjQueryEntity.class, (Serializable)((Object)businessObjId));
        String runtimeStatus = entity.getTaRuntimeStatusEntity().getCode();
        if (runtimeStatus.equals("completed")) {
            throw new BusinessException("\u6d41\u7a0b\u5df2\u5b8c\u6210\u4e0d\u80fd\u8ffd\u56de");
        }
        if (runtimeStatus.equals("reject")) {
            throw new BusinessException("\u6d41\u7a0b\u5df2\u9a73\u56de\u4e0d\u80fd\u8ffd\u56de");
        }
        this.taskService.addComment(null, pi.getProcessInstanceId(), CommentUtil.buildRecoverComment(ResourceUtil.getCreateName(), "\u8ffd\u56de\u6d41\u7a0b"));
        TaRuntimeStatusEntity recoverStatas = this.findUniqueByProperty(TaRuntimeStatusEntity.class, "code", "recover");
        entity.setTaRuntimeStatusEntity(recoverStatas);
        this.updateEntity(entity);
        this.runtimeService.setVariable(execution.getId(), "aborts", (Object)WorkFlowGlobals.BPM_BUS_STATUS_5);
        this.runtimeService.deleteProcessInstance(myInstanceVo.getProcessInstanceId(), "recover");
    }

    @Override
    public void closeProcessInstance(MyInstanceVo myInstanceVo) {
        String createName = ResourceUtil.getCreateName();
        this.taskService.addComment(null, myInstanceVo.getProcessInstanceId(), CommentUtil.buildCloseComment(ResourceUtil.getCreateName(), "\u5173\u95ed\u6d41\u7a0b"));
        this.runtimeService.deleteProcessInstance(myInstanceVo.getProcessInstanceId(), String.valueOf(createName) + "\u5173\u95ed\u6d41\u7a0b\u5b9e\u4f8b");
    }
}

