/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.mdm.custorg.service.impl;

import com.biz.eisp.base.common.constant.Globals;
import com.biz.eisp.base.common.util.StringUtil;
import com.biz.eisp.base.core.page.EuPage;
import com.biz.eisp.base.importer.ImpEventHandler;
import com.biz.eisp.base.importer.validator.ValidateException;
import com.biz.eisp.base.importer.validator.ValidatorFactory;
import com.biz.eisp.base.utils.ApplicationContextUtils;
import com.biz.eisp.mdm.config.entity.TmMdmTableConfigEntity;
import com.biz.eisp.mdm.config.util.DynamicConfigUtil;
import com.biz.eisp.mdm.custorg.entity.TmCustomerOrgEntity;
import com.biz.eisp.mdm.custorg.service.TmCustOrgService;
import com.biz.eisp.mdm.custorg.vo.TmCustomerOrgVo;
import java.util.List;
import java.util.Map;

public class TmCustOrgEventHandler
extends ImpEventHandler<TmCustomerOrgVo> {
    private TmCustOrgService tmCustOrgService = (TmCustOrgService)ApplicationContextUtils.getContext().getBean("tmCustOrgService");

    @Override
    public void endRow(Map<String, Object> row, TmCustomerOrgVo bean) throws ValidateException {
        try {
            EuPage page = new EuPage();
            this.tmCustOrgService.saveOrUpdateCustOrg(bean, page);
        }
        catch (Exception e) {
            this.addError("\u7b2c" + this.getRowNumber() + "\u884c\u9047\u5230\u9519\u8bef:" + e.getMessage());
            e.printStackTrace();
        }
        this.setSuccNum(this.getSuccNum() + 1);
    }

    @Override
    public void end() {
        this.tmCustOrgService.updateIsLeafColumn(Globals.TABLE_CUSTOMER_ORG);
    }

    @Override
    public void validate(Map<String, Object> row) throws ValidateException {
        List<TmMdmTableConfigEntity> list = DynamicConfigUtil.allTableConfigImpColumn.get(this.tableName.toUpperCase());
        for (TmMdmTableConfigEntity tableConfig : list) {
            List count1;
            String hql;
            List counts;
            Object fieldValue;
            String errorMsg = ValidatorFactory.validateDynamicImplData(tableConfig, fieldValue = row.get(tableConfig.getField()));
            if (StringUtil.isNotEmpty((String)errorMsg)) {
                this.addError("\u7b2c" + this.getRowNumber() + "\u884c:" + errorMsg);
            }
            if (StringUtil.equals("customerOrgName", tableConfig.getField()) && (counts = this.tmCustOrgService.findByHql(hql = "from TmCustomerOrgEntity where enableStatus=0 and  customerOrgName=?", fieldValue)) != null && counts.size() > 0) {
                this.addError("\u7b2c" + this.getRowNumber() + "\u884c:\u5ba2\u6237\u7ec4\u7ec7\u540d\u79f0" + fieldValue + "\u5df2\u5b58\u5728");
            }
            if (StringUtil.equals("custOrgCode", tableConfig.getField()) && (count1 = this.tmCustOrgService.findByHql(hql = "from TmCustomerOrgEntity where enableStatus=0 and  custOrgCode=?", fieldValue)) != null && count1.size() > 0) {
                this.addError("\u7b2c" + this.getRowNumber() + "\u884c,\u5ba2\u6237\u7ec4\u7ec7\u7f16\u7801" + fieldValue + "\u5df2\u5b58\u5728");
            }
            if (!StringUtil.equals("parentId", tableConfig.getField())) continue;
            String superOrgCodeHql = "from TmCustomerOrgEntity where custOrgCode=? and enableStatus=?";
            TmCustomerOrgEntity custOrgEntity = this.tmCustOrgService.getUniqueByHql(TmCustomerOrgEntity.class, superOrgCodeHql, fieldValue, Globals.ZERO);
            if (StringUtil.isEmpty(custOrgEntity)) {
                this.addError("\u7b2c" + this.getRowNumber() + "\u884c,\u4e0a\u7ea7\u5ba2\u6237\u7ec4\u7ec7\u7f16\u7801\u5728\u7cfb\u7edf\u4e2d\u4e0d\u5b58\u5728");
                continue;
            }
            row.put(tableConfig.getField(), custOrgEntity.getId());
        }
    }
}

