/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.mdm.org.service.impl;

import com.biz.eisp.base.common.constant.Globals;
import com.biz.eisp.base.common.exception.BusinessException;
import com.biz.eisp.base.common.jsonmodel.AjaxJson;
import com.biz.eisp.base.common.jsonmodel.ComboBox;
import com.biz.eisp.base.common.jsonmodel.ComboTree;
import com.biz.eisp.base.common.jsonmodel.TreeGrid;
import com.biz.eisp.base.common.tag.bean.ComboTreeModel;
import com.biz.eisp.base.common.tag.bean.TreeGridModel;
import com.biz.eisp.base.common.util.StringUtil;
import com.biz.eisp.base.common.util.TreeGridUtil;
import com.biz.eisp.base.core.page.Page;
import com.biz.eisp.base.core.service.impl.BaseServiceImpl;
import com.biz.eisp.mdm.config.util.DynamicConfigUtil;
import com.biz.eisp.mdm.org.dao.TmOrgDao;
import com.biz.eisp.mdm.org.entity.TmOrgEntity;
import com.biz.eisp.mdm.org.service.TmOrgExtendService;
import com.biz.eisp.mdm.org.service.TmOrgService;
import com.biz.eisp.mdm.org.transform.TmOrgEntityToTmOrgVo;
import com.biz.eisp.mdm.org.transform.TmOrgVoTransFormPo;
import com.biz.eisp.mdm.org.vo.QueryTmOrgVo;
import com.biz.eisp.mdm.org.vo.TmOrgVo;
import com.biz.eisp.mdm.position.entity.TmPositionEntity;
import com.biz.eisp.mdm.system.service.InitListenerService;
import com.google.common.base.Function;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.hibernate.criterion.SimpleExpression;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service(value="tmOrgService")
@Transactional
public class TmOrgServiceImpl
extends BaseServiceImpl
implements TmOrgService {
    @Autowired
    private TmOrgDao tmOrgDao;
    @Autowired(required=false)
    private TmOrgExtendService tmOrgExtendService;
    @Autowired
    private InitListenerService initListenerService;

    @Override
    public List<TreeGrid> findOrgMainGrid(HttpServletRequest request, TreeGrid treeGrid, TmOrgVo tmOrgVo) {
        ArrayList<TreeGrid> treeGrids = new ArrayList();
        SimpleExpression cr1 = null;
        SimpleExpression cr2 = Restrictions.eq((String)"enableStatus", (Object)Globals.ZERO);
        List<Object> orgList = new ArrayList();
        if (StringUtil.isNotEmpty((String)tmOrgVo.getOrgName()) || StringUtil.isNotEmpty((String)tmOrgVo.getOrgCode())) {
            String hql = "select t from TmOrgEntity t where 1 = 1 and t.enableStatus = ? ";
            if (StringUtil.isNotEmpty((String)tmOrgVo.getOrgName())) {
                hql = String.valueOf(hql) + " and t.orgName like '%" + tmOrgVo.getOrgName() + "%'";
            }
            if (StringUtil.isNotEmpty((String)tmOrgVo.getOrgCode())) {
                hql = String.valueOf(hql) + " and t.orgCode like '%" + tmOrgVo.getOrgCode() + "%'";
            }
            List temp = this.findByHql(hql, Globals.ZERO);
            for (TmOrgEntity tmOrgEntity : temp) {
                orgList.add(tmOrgEntity);
                this.addParentsEntity(tmOrgEntity, orgList);
            }
        } else {
            if (StringUtil.isNotEmpty((String)treeGrid.getId())) {
                cr1 = Restrictions.eq((String)"tmOrg.id", (Object)treeGrid.getId());
            }
            if (StringUtil.isEmpty(treeGrid.getId())) {
                cr1 = Restrictions.isNull((String)"tmOrg");
            }
            orgList = this.findByCriteria(TmOrgEntity.class, new Criterion[]{cr1, cr2});
        }
        ArrayList<TmOrgVo> orgVoList = new ArrayList<TmOrgVo>();
        TmOrgEntityToTmOrgVo orgTransForm = new TmOrgEntityToTmOrgVo(this);
        for (TmOrgEntity tmOrgEntity : orgList) {
            orgVoList.add(orgTransForm.apply(tmOrgEntity));
        }
        TreeGridModel treeGridModel = new TreeGridModel();
        treeGridModel.setTextField("orgName");
        treeGridModel.setParentText("tmOrg_orgName");
        treeGridModel.setParentId("tmOrg_id");
        treeGridModel.setSrc("orgDesc");
        treeGridModel.setIdField("id");
        treeGridModel.setChildList("tmOrgList");
        treeGridModel.setCode("orgCode");
        HashMap<String, Object> fieldMap = new HashMap<String, Object>();
        this.addField(fieldMap, TmOrgVo.class);
        treeGridModel.setFieldMap(fieldMap);
        treeGrids = this.treegrid(orgVoList, treeGridModel);
        return treeGrids;
    }

    private void addField(Map<String, Object> fieldMap, Class clazz) {
        Field[] fields;
        Field[] fieldArray = fields = clazz.getDeclaredFields();
        int n = fields.length;
        int n2 = 0;
        while (n2 < n) {
            Field field = fieldArray[n2];
            String fieldName = field.getName();
            if (!StringUtil.equals("tmOrgList", fieldName)) {
                fieldMap.put(fieldName, fieldName);
            }
            ++n2;
        }
    }

    private void addParentsEntity(TmOrgEntity tt, List<TmOrgEntity> orgList) {
        String parent_id;
        TmOrgEntity tempEntity;
        String sql = "select parent_id from tm_org where id=?";
        Map<String, Object> map = this.findForMap(sql, tt.getId());
        if (StringUtil.isNotEmpty(map.get("parent_id")) && (tempEntity = super.get(TmOrgEntity.class, (Serializable)((Object)(parent_id = (String)map.get("parent_id"))))) != null) {
            if (!orgList.contains(tempEntity)) {
                orgList.add(tempEntity);
            }
            this.addParentsEntity(tempEntity, orgList);
        }
    }

    @Override
    public List<TmOrgVo> findOrgSelectGrid(TmOrgVo tmOrgVo, Page page) {
        return this.tmOrgDao.findTmOrgList(tmOrgVo, page);
    }

    @Override
    public List<ComboTree> getParentOrg(TmOrgVo orgVo, ComboTree comboTree, HttpServletRequest request) {
        List<Object> tmOrgList = new ArrayList();
        SimpleExpression cr1 = null;
        String selfId = request.getParameter("selfId");
        if (StringUtil.isNotEmpty((String)selfId)) {
            tmOrgList = this.findByProperty(TmOrgEntity.class, "id", selfId);
        } else if (StringUtil.isNotEmpty((String)orgVo.getOrgId())) {
            cr1 = Restrictions.ne((String)"id", (Object)orgVo.getOrgId());
        }
        SimpleExpression cr4 = Restrictions.eq((String)"enableStatus", (Object)Globals.ZERO);
        if (StringUtil.isNotEmpty((String)comboTree.getId())) {
            SimpleExpression cr2 = Restrictions.eq((String)"tmOrg.id", (Object)comboTree.getId());
            if (StringUtil.isNotEmpty(cr1)) {
                tmOrgList.addAll(this.findByCriteria(TmOrgEntity.class, new Criterion[]{cr1, cr2, cr4}));
            } else {
                tmOrgList.addAll(this.findByCriteria(TmOrgEntity.class, new Criterion[]{cr2, cr4}));
            }
        } else {
            Object cr3 = null;
            cr3 = StringUtil.isNotEmpty((String)orgVo.getPid()) ? Restrictions.eq((String)"id", (Object)orgVo.getPid()) : Restrictions.isNull((String)"tmOrg.id");
            if (StringUtil.isNotEmpty(cr1)) {
                tmOrgList.addAll(this.findByCriteria(TmOrgEntity.class, new Criterion[]{cr1, cr3, cr4}));
            } else {
                tmOrgList.addAll(this.findByCriteria(TmOrgEntity.class, new Criterion[]{cr3, cr4}));
            }
        }
        ComboTreeModel comboTreeModel = new ComboTreeModel("id", "orgName", "tmOrgList");
        List<ComboTree> comboTrees = this.comboTree(tmOrgList, comboTreeModel, null, false);
        return comboTrees;
    }

    @Override
    public void saveOrUpdateOrg(TmOrgVo tmOrgVo, Page page) {
        String id;
        TmOrgEntity oldOrgEntity;
        String oldParnetId;
        TmOrgEntity tmOrgEntity = null;
        if (StringUtil.isNotEmpty(this.tmOrgExtendService)) {
            try {
                this.tmOrgExtendService.validate(tmOrgVo, page);
            }
            catch (Exception e) {
                throw new BusinessException("\u9a8c\u8bc1\u6570\u636e\u5931\u8d25:" + e.getMessage());
            }
            tmOrgEntity = this.tmOrgExtendService.saveBefore(tmOrgVo, page);
        }
        if (StringUtil.isEmpty(tmOrgEntity)) {
            TmOrgVoTransFormPo formPo = new TmOrgVoTransFormPo();
            tmOrgEntity = formPo.apply(tmOrgVo);
        }
        if (StringUtil.isNotEmpty(this.tmOrgExtendService)) {
            tmOrgEntity = this.tmOrgExtendService.saveBefore(tmOrgEntity, tmOrgVo, page);
        }
        this.saveOrUpdate(tmOrgEntity);
        this.initListenerService.refleshDepart(tmOrgEntity.getId(), tmOrgEntity.getTmOrg().getId(), tmOrgEntity.getOrgName(), 2);
        if (StringUtil.isNotEmpty(this.tmOrgExtendService)) {
            tmOrgEntity = this.tmOrgExtendService.savePost(tmOrgEntity, tmOrgVo, page);
        }
        if (StringUtil.isNotEmpty((String)tmOrgVo.getId()) && !(oldParnetId = (oldOrgEntity = this.get(TmOrgEntity.class, (Serializable)((Object)(id = tmOrgEntity.getId())))).getTmOrg().getId()).equals(tmOrgVo.getPid())) {
            String sql = "update tm_position set parent_id = null where org_id = ? ";
            this.executeSql(sql, id);
        }
    }

    @Override
    public AjaxJson delOrg(String ids) {
        String[] orgIds;
        AjaxJson j = new AjaxJson();
        String[] stringArray = orgIds = ids.split(",");
        int n = orgIds.length;
        int n2 = 0;
        while (n2 < n) {
            String id = stringArray[n2];
            TmOrgEntity orgEntity = this.get(TmOrgEntity.class, (Serializable)((Object)id));
            if (CollectionUtils.isEmpty(orgEntity.getTmOrgList())) {
                List<TmPositionEntity> positions = this.findByProperty(TmPositionEntity.class, "tmOrg.id", id);
                if (!CollectionUtils.isEmpty(positions)) {
                    j.setMsg("\u5220\u9664\u7684\u5f53\u524d\u7ec4\u7ec7\u3010" + orgEntity.getOrgName() + "\u3011\u6709\u5173\u8054\u7684\u804c\u4f4d\u4e0d\u80fd\u5220\u9664\uff01");
                    j.setSuccess(false);
                    return j;
                }
            } else {
                j.setMsg("\u5220\u9664\u7684\u5f53\u524d\u7ec4\u7ec7\u3010" + orgEntity.getOrgName() + "\u3011\u4e0b\u7ea7\u7ec4\u7ec7\u4e0d\u80fd\u5220\u9664\uff01");
                j.setSuccess(false);
                return j;
            }
            orgEntity.setEnableStatus(Globals.ONE);
            this.updateEntity(orgEntity);
            this.initListenerService.refleshDepart(orgEntity.getId(), orgEntity.getTmOrg().getId(), orgEntity.getOrgName(), 3);
            ++n2;
        }
        j.setMsg("\u5220\u9664\u6210\u529f\uff01");
        return j;
    }

    @Override
    public TmOrgVo getTmOrgByPostionId(String postionId) {
        String sql = "select t1.* from tm_org t1 where t1.id = (select t2.org_id from tm_position t2 where t2.id = ?)";
        TmOrgEntity org = this.getUniqueBySql(TmOrgEntity.class, sql, postionId);
        TmOrgVo result = new TmOrgEntityToTmOrgVo(this).apply(org);
        return result;
    }

    @Override
    public void importOrg(TmOrgVo tmOrgVo) {
        TmOrgVoTransFormPo formPo = new TmOrgVoTransFormPo();
        TmOrgEntity tmOrgEntity = formPo.apply(tmOrgVo);
        this.saveOrUpdate(tmOrgEntity);
    }

    @Override
    public List<TmOrgVo> findTmOrgByAllPossible(QueryTmOrgVo queryTmOrgVo, Page page) {
        return this.tmOrgDao.findTmOrgByAllPossible(queryTmOrgVo, page);
    }

    @Override
    public List<TmOrgVo> findAllOrg() {
        List<TmOrgEntity> orgs = super.findByCriteria(TmOrgEntity.class, new Criterion[0]);
        return Lists.transform(orgs, (Function)new TmOrgEntityToTmOrgVo(this));
    }

    @Override
    public List<TmOrgVo> findOrgMainList(TmOrgVo tmOrgVo) {
        String sql = DynamicConfigUtil.getInstance().buildTreeGridQuerySql(Globals.TABLE_ORG, tmOrgVo);
        List<TmOrgVo> tmOrgList = this.findBySql(TmOrgVo.class, sql, new Object[0]);
        if (DynamicConfigUtil.getInstance().isHaveQuery(Globals.TABLE_ORG, tmOrgVo)) {
            tmOrgList = this.findQueryCustomerOrgList(tmOrgVo, tmOrgList);
        }
        return tmOrgList;
    }

    private List<TmOrgVo> findQueryCustomerOrgList(TmOrgVo tmOrgVo, List<TmOrgVo> voList) {
        if (tmOrgVo.getExportExcel().equals("true")) {
            return voList;
        }
        List allQueryVolist = TreeGridUtil.buildTreeGrid(voList);
        return allQueryVolist;
    }

    private boolean hasQueryValue(TmOrgVo tmOrgVo) {
        return !StringUtil.isEmpty(tmOrgVo.getOrgCode()) || !StringUtil.isEmpty(tmOrgVo.getOrgName()) || !StringUtil.isEmpty(tmOrgVo.getOrgDesc()) || !StringUtil.isEmpty(tmOrgVo.getOrgType()) || !StringUtil.isEmpty(tmOrgVo.getHeadString()) || !StringUtil.isEmpty(tmOrgVo.getExtChar1()) || !StringUtil.isEmpty(tmOrgVo.getExtChar2()) || !StringUtil.isEmpty(tmOrgVo.getExtChar3()) || !StringUtil.isEmpty(tmOrgVo.getExtChar4()) || !StringUtil.isEmpty(tmOrgVo.getExtChar5()) || tmOrgVo.getExtDate1() != null || tmOrgVo.getExtDate2() != null || tmOrgVo.getExtNumber1() != null || tmOrgVo.getExtNumber2() != null || tmOrgVo.getExtNumber3() != null || tmOrgVo.getEnableStatus() != null;
    }

    @Override
    public List<ComboBox> getSalesArae(TmOrgVo orgVo) {
        String sql = "select id value,org_name text from tm_org where 1=1";
        if (StringUtil.isNotEmpty((String)orgVo.getOrgType())) {
            sql = String.valueOf(sql) + " and org_type=" + orgVo.getOrgType();
        }
        if (StringUtil.isNotEmpty((String)orgVo.getPid())) {
            sql = String.valueOf(sql) + " and parent_id ='" + orgVo.getPid() + "'";
        }
        return this.findBySql(ComboBox.class, sql, new Object[0]);
    }

    @Override
    public boolean validate(String id, String param, String fieldName) {
        SimpleExpression cr1 = Restrictions.eq((String)fieldName, (Object)param);
        List<Object> tmtbas = new ArrayList();
        if (StringUtil.isNotEmpty((String)id)) {
            SimpleExpression cr2 = Restrictions.ne((String)"id", (Object)id);
            tmtbas = this.findByCriteria(TmOrgEntity.class, new Criterion[]{cr1, cr2});
        } else {
            tmtbas = this.findByCriteria(TmOrgEntity.class, new Criterion[]{cr1});
        }
        return !CollectionUtils.isEmpty(tmtbas);
    }

    @Override
    public List<ComboBox> getSalesAraeOrgCode(TmOrgVo orgVo) {
        String sql = "select org_code value,org_name text from tm_org where 1=1";
        if (StringUtil.isNotEmpty((String)orgVo.getOrgType())) {
            sql = String.valueOf(sql) + " and org_type=" + orgVo.getOrgType();
        }
        if (StringUtil.isNotEmpty((String)orgVo.getPid())) {
            sql = String.valueOf(sql) + " and parent_id ='" + orgVo.getPid() + "'";
        }
        return this.findBySql(ComboBox.class, sql, new Object[0]);
    }
}

