/*
 * Decompiled with CFR 0.152.
 */
package iam.oidc.sdk;

import java.util.Collection;
import java.util.Map;
import kong.unirest.Cookie;
import kong.unirest.GetRequest;
import kong.unirest.HttpRequestWithBody;
import kong.unirest.JsonNode;
import kong.unirest.RequestBodyEntity;
import kong.unirest.Unirest;
import kong.unirest.json.JSONElement;

public class HttpUtils {
    public static HTTP get(String url) {
        GetRequest getRequest = Unirest.get(url);
        return new HTTP(getRequest);
    }

    public static HTTP post(String url) {
        HttpRequestWithBody post = Unirest.post(url);
        return new HTTP(post);
    }

    public static class HTTP {
        private GetRequest getRequest;
        private HttpRequestWithBody post;
        private RequestBodyEntity requestBodyEntity;

        public HTTP(GetRequest getRequest) {
            this.getRequest = getRequest;
        }

        public HTTP(HttpRequestWithBody post) {
            this.post = post;
        }

        public HTTP header(String var1, String var2) {
            if (this.getRequest != null) {
                this.getRequest.header(var1, var2);
            } else if (this.post != null) {
                this.post.header(var1, var2);
            }
            return this;
        }

        public HTTP headers(Map<String, String> var1) {
            if (this.getRequest != null) {
                this.getRequest.headers(var1);
            } else if (this.post != null) {
                this.post.headers(var1);
            }
            return this;
        }

        public HTTP cookie(Cookie var1) {
            if (this.getRequest != null) {
                this.getRequest.cookie(var1);
            } else if (this.post != null) {
                this.post.cookie(var1);
            }
            return this;
        }

        public HTTP cookie(Collection<Cookie> var1) {
            if (this.getRequest != null) {
                this.getRequest.cookie(var1);
            } else if (this.post != null) {
                this.post.cookie(var1);
            }
            return this;
        }

        public String asString() {
            if (this.getRequest != null) {
                return this.getRequest.asString().getBody();
            }
            if (this.post != null) {
                return this.requestBodyEntity != null ? this.requestBodyEntity.asString().getBody() : this.post.asString().getBody();
            }
            throw new RuntimeException("HTTP \u8bf7\u6c42\u53d1\u751f\u53c2\u6570\u9519\u8bef");
        }

        public <T> T asObject(Class<T> clazz) {
            if (this.getRequest != null) {
                return this.getRequest.asObject(clazz).getBody();
            }
            if (this.post != null) {
                return this.requestBodyEntity != null ? this.requestBodyEntity.asObject(clazz).getBody() : this.post.asObject(clazz).getBody();
            }
            throw new RuntimeException("HTTP \u8bf7\u6c42\u53d1\u751f\u53c2\u6570\u9519\u8bef");
        }

        public HTTP body(String body) {
            this.requestBodyEntity = this.post.body(body);
            return this;
        }

        public HTTP body(Object body) {
            this.requestBodyEntity = this.post.body(body);
            return this;
        }

        public HTTP body(byte[] body) {
            this.requestBodyEntity = this.post.body(body);
            return this;
        }

        public HTTP body(JsonNode body) {
            this.requestBodyEntity = this.post.body(body);
            return this;
        }

        public HTTP body(JSONElement body) {
            this.requestBodyEntity = this.post.body(body);
            return this;
        }
    }
}

