/*
 * Decompiled with CFR 0.152.
 */
package iam.oidc.sdk;

import com.google.gson.Gson;
import iam.oidc.sdk.HttpUtils;
import iam.oidc.sdk.RespToken;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;
import org.jose4j.jwk.JsonWebKey;
import org.jose4j.jws.JsonWebSignature;
import org.jose4j.jwt.JwtClaims;
import org.jose4j.jwt.NumericDate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OidcUtils {
    private static final Logger logger = LoggerFactory.getLogger(OidcUtils.class);

    public RespToken exchangeIdToken(String serverUrl, String clientId, String clientSecret, String code, String publicKeyStr, String redirectUri) throws Exception {
        RespToken token = new RespToken();
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("client_id", clientId);
        String encodeValue = this.encodeValue(clientSecret);
        paramMap.put("client_secret", encodeValue);
        paramMap.put("code", code);
        paramMap.put("redirect_uri", redirectUri);
        paramMap.put("grant_type", "authorization_code");
        String resp = OidcUtils.sendPost(serverUrl, paramMap);
        Map respMap = new Gson().fromJson(resp, Map.class);
        logger.info("response ==> {}", (Object)respMap);
        String idToken = (String)respMap.get("id_token");
        token.setId_token(idToken);
        token.setAccess_token((String)respMap.get("access_token"));
        token.setRefresh_token((String)respMap.get("refresh_token"));
        token.setExpires_in(((Number)respMap.get("expires_in")).longValue());
        JwtClaims jwtClaims = this.validateToken(idToken, publicKeyStr);
        String subject = jwtClaims.getSubject();
        token.setSubject(subject);
        token.setJwtClaims(jwtClaims);
        return token;
    }

    private String encodeValue(String value) throws UnsupportedEncodingException {
        return URLEncoder.encode(value, Charset.forName("UTF-8").displayName());
    }

    public JwtClaims validateToken(String jwtTicket, String publicKeyStr) throws Exception {
        JsonWebSignature jws = new JsonWebSignature();
        jws.setCompactSerialization(jwtTicket);
        JsonWebKey jsonWebKey = JsonWebKey.Factory.newJwk(publicKeyStr);
        String keyId = jsonWebKey.getKeyId();
        jws.setKey(jsonWebKey.getKey());
        boolean verifySignature = jws.verifySignature();
        if (!verifySignature) {
            logger.error("Invalid signature! jwtTicket:{} keyId: {} ", (Object)jwtTicket, (Object)keyId);
            throw new Exception("Invalid signature!");
        }
        String payload = jws.getPayload();
        JwtClaims claims = JwtClaims.parse(payload);
        NumericDate expirationTime = claims.getExpirationTime();
        if (expirationTime == null) {
            logger.error("Invalid signature! jwtTicket:{} keyId: {} ", (Object)jwtTicket, (Object)keyId);
            throw new Exception("Invalid signature!");
        }
        if (!expirationTime.isAfter(NumericDate.now())) {
            logger.error("Jwt ticket expired! jwtTicket:{} keyId: {} ", (Object)jwtTicket, (Object)keyId);
            throw new Exception("Jwt ticket expired!");
        }
        return claims;
    }

    public static String sendPost(String url, Map<String, ?> paramMap) throws IOException {
        String param = "";
        for (String key : paramMap.keySet()) {
            param = param + key + "=" + paramMap.get(key) + "&";
        }
        String result = HttpUtils.post(url + "?" + param).asString();
        String string = HttpUtils.get(url).asString();
        return result;
    }
}

