/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.sso.client.ltpa;

import com.kingdee.shr.sso.client.ltpa.ConfigurationError;
import com.kingdee.shr.sso.client.ltpa.LtpaToken;
import com.kingdee.shr.sso.client.util.BASE64Util;
import com.kingdee.shr.sso.client.util.LMBCSUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.util.Calendar;
import java.util.Date;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.servlet.http.Cookie;

public class LtpaTokenManager {
    public static final String COOKIE_DOMAIN = "cookie.domain";
    public static final String COOKIE_NAME = "LtpaToken";
    public static final String DOMINO_SECRET = "domino.secret";
    public static final String TOKEN_EXPIRATION = "token.expiration";
    public static final String ISLMBCSENCODE = "isLMBCSEncode";
    private static Properties properties = null;
    private static boolean isConfigLoaded = false;

    public static void loadConfig(String configFile) {
        if (!LtpaTokenManager.isConfigLoaded()) {
            block21: {
                properties = new Properties();
                InputStream is = null;
                File file = new File(configFile);
                if (!file.exists()) {
                    System.err.println("load jar ltpatoken.properties");
                    InputStream input = new LtpaTokenManager().getClass().getResourceAsStream("LtpaToken.properties");
                    try {
                        try {
                            properties.load(input);
                            isConfigLoaded = true;
                            break block21;
                        }
                        catch (IOException e) {
                            throw new ConfigurationError("LtpaToken.properties not found. file = " + configFile);
                        }
                    }
                    finally {
                        try {
                            input.close();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                }
                try {
                    try {
                        is = new FileInputStream(configFile);
                        properties.load(is);
                        isConfigLoaded = true;
                    }
                    catch (IOException ioe) {
                        throw new ConfigurationError("LtpaToken.properties not found. file = " + configFile);
                    }
                }
                finally {
                    try {
                        is.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
            if (properties.getProperty(DOMINO_SECRET) == null || properties.getProperty(COOKIE_DOMAIN) == null || properties.getProperty(TOKEN_EXPIRATION) == null) {
                throw new ConfigurationError("LtpaToken.properties not configured properly. file = " + configFile);
            }
        }
    }

    public static LtpaToken generate(String canonicalUser) {
        String configFile = LtpaTokenManager.getDefaultConfigFile();
        return LtpaTokenManager.generate(canonicalUser, configFile);
    }

    public static LtpaToken generate(String canonicalUser, String configFile) {
        LtpaTokenManager.initConfig(configFile);
        Date creationDate = new Date();
        Date expirationDate = new Date();
        int interval = Integer.parseInt(properties.getProperty(TOKEN_EXPIRATION));
        expirationDate.setTime(creationDate.getTime() + (long)(60000 * interval));
        return LtpaTokenManager.generate(canonicalUser, creationDate, expirationDate, configFile, null);
    }

    public static LtpaToken generate(String canonicalUser, String configFile, String authPattern) {
        LtpaTokenManager.initConfig(configFile);
        Date creationDate = new Date();
        Date expirationDate = new Date();
        int interval = 0;
        interval = properties.containsKey(String.valueOf(authPattern.toLowerCase()) + "." + TOKEN_EXPIRATION) ? Integer.parseInt(String.valueOf(authPattern.toLowerCase()) + "." + TOKEN_EXPIRATION) : Integer.parseInt(properties.getProperty(TOKEN_EXPIRATION));
        expirationDate.setTime(creationDate.getTime() + (long)(60000 * interval));
        return LtpaTokenManager.generate(canonicalUser, creationDate, expirationDate, configFile, authPattern);
    }

    public static LtpaToken generate(String canonicalUser, Date tokenCreation, Date tokenExpires) {
        String configFile = LtpaTokenManager.getDefaultConfigFile();
        return LtpaTokenManager.generate(canonicalUser, tokenCreation, tokenExpires, configFile, null);
    }

    private static String getDefaultConfigFile() {
        Properties prop = new Properties();
        String configFile = "";
        String defaultConfigFileName = "config.properties";
        InputStream is = LtpaTokenManager.class.getResourceAsStream(defaultConfigFileName);
        try {
            try {
                prop.load(is);
                configFile = prop.getProperty("config.path");
            }
            catch (IOException e) {
                e.printStackTrace();
                try {
                    is.close();
                }
                catch (IOException e2) {
                    e2.printStackTrace();
                }
            }
        }
        finally {
            try {
                is.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return configFile;
    }

    public static LtpaToken generate(String canonicalUser, Date tokenCreation, Date tokenExpires, String configFile, String authPattern) {
        String isLMBC;
        boolean isLMBCSEncode = false;
        if (properties != null && (isLMBC = properties.getProperty(ISLMBCSENCODE)) != null && "true".equals(isLMBC)) {
            isLMBCSEncode = true;
        }
        return LtpaTokenManager.generate(canonicalUser, tokenCreation, tokenExpires, configFile, isLMBCSEncode, authPattern);
    }

    public static LtpaToken generate(String canonicalUser, Date tokenCreation, Date tokenExpires, String configFile, boolean isLMBCSEncode, String authPattern) {
        LtpaTokenManager.initConfig(configFile);
        LtpaToken ltpa = new LtpaToken();
        Calendar calendar = Calendar.getInstance();
        MessageDigest md = ltpa.getMessageDigest();
        byte[] byArray = new byte[4];
        byArray[1] = 1;
        byArray[2] = 2;
        byArray[3] = 3;
        ltpa.setHeader(byArray);
        if (isLMBCSEncode) {
            ltpa.setUser(LMBCSUtil.getLMBCSLocalGroupBytes(canonicalUser));
        } else {
            try {
                ltpa.setUser(canonicalUser.getBytes("UTF-8"));
            }
            catch (UnsupportedEncodingException e) {
                ltpa.setUser(canonicalUser.getBytes());
            }
        }
        byte[] token = null;
        calendar.setTime(tokenCreation);
        ltpa.setCreation(Long.toHexString(calendar.getTime().getTime() / 1000L).toUpperCase().getBytes());
        calendar.setTime(tokenExpires);
        ltpa.setExpires(Long.toHexString(calendar.getTime().getTime() / 1000L).toUpperCase().getBytes());
        token = LMBCSUtil.concatenate(token, ltpa.getHeader());
        token = LMBCSUtil.concatenate(token, ltpa.getCreation());
        token = LMBCSUtil.concatenate(token, ltpa.getExpires());
        token = LMBCSUtil.concatenate(token, ltpa.getUser());
        md.update(token);
        String secret = null;
        secret = authPattern != null && properties.containsKey(String.valueOf(authPattern.toLowerCase()) + "." + DOMINO_SECRET) ? properties.getProperty(String.valueOf(authPattern.toLowerCase()) + "." + DOMINO_SECRET) : properties.getProperty(DOMINO_SECRET);
        byte[] digest = md.digest(BASE64Util.decodeAsBytes(secret));
        String di = LtpaTokenManager.byte2hex(digest);
        ltpa.setDigest(di.getBytes());
        token = LMBCSUtil.concatenate(token, di.getBytes());
        String tokenStr = BASE64Util.encode(token);
        String result = "";
        StringTokenizer st = new StringTokenizer(tokenStr);
        while (st.hasMoreTokens()) {
            result = String.valueOf(result) + st.nextToken();
        }
        return new LtpaToken(result);
    }

    public static String byte2hex(byte[] b) {
        String hs = "";
        String stmp = "";
        int n = 0;
        while (n < b.length) {
            stmp = Integer.toHexString(b[n] & 0xFF);
            hs = stmp.length() == 1 ? String.valueOf(hs) + "0" + stmp : String.valueOf(hs) + stmp;
            ++n;
        }
        return hs.toUpperCase();
    }

    private static void initConfig(String configFile) {
        LtpaTokenManager.loadConfig(configFile);
    }

    public static boolean isValid(String ltpaToken) {
        LtpaTokenManager.checkConfig();
        LtpaToken ltpa = new LtpaToken(LtpaToken.decodeToken(ltpaToken));
        boolean result = ltpa.isValid(properties.getProperty(DOMINO_SECRET));
        System.out.println("LTPA token isValid result:" + result);
        if (!result) {
            System.out.println("LTPA token compare false, token:" + ltpaToken);
        }
        return result;
    }

    public static boolean isValid(String ltpaToken, String authPattern) {
        LtpaTokenManager.checkConfig();
        LtpaToken ltpa = new LtpaToken(LtpaToken.decodeToken(ltpaToken));
        String secret = null;
        secret = properties.containsKey(String.valueOf(authPattern.toLowerCase()) + "." + DOMINO_SECRET) ? properties.getProperty(String.valueOf(authPattern.toLowerCase()) + "." + DOMINO_SECRET) : properties.getProperty(DOMINO_SECRET);
        boolean result = ltpa.isValid(secret);
        System.out.println("LTPA token isValid result:" + result);
        if (!result) {
            System.out.println("LTPA token compare false, token:" + ltpaToken);
        }
        return result;
    }

    public static Cookie toCookie(String ltpaToken) {
        LtpaTokenManager.checkConfig();
        Cookie cookie = new Cookie(COOKIE_NAME, ltpaToken);
        String domain = properties.getProperty(COOKIE_DOMAIN);
        if (domain != null && !"".equals(domain)) {
            cookie.setDomain(domain);
        }
        cookie.setPath("/");
        cookie.setSecure(false);
        cookie.setMaxAge(-1);
        return cookie;
    }

    private static void checkConfig() {
        if (!LtpaTokenManager.isConfigLoaded()) {
            throw new ConfigurationError("LtpaToken properties is unloaded properly. ");
        }
    }

    private static boolean isConfigLoaded() {
        return isConfigLoaded;
    }

    public static String getDefaultLtpaConfig() {
        return "LtpaToken.properties";
    }

    public static synchronized void loadDefaultConfig() {
        LtpaTokenManager.loadConfig(LtpaTokenManager.getDefaultLtpaConfig());
    }

    public static boolean compare(String token, String userNumber) {
        boolean result = false;
        LtpaToken lt = new LtpaToken(LtpaToken.decodeToken(token));
        String username = lt.getUsername();
        result = username == null ? false : username.equals(userNumber);
        System.out.println("LTPA token compare result:" + result);
        if (!result) {
            System.out.println("LTPA token compare false, token:" + token);
        }
        return result;
    }

    public static boolean verifyToken(String path, String token, String userNumber) {
        boolean result = false;
        if (path == null || path.trim().length() == 0) {
            LtpaTokenManager.loadDefaultConfig();
        } else {
            LtpaTokenManager.loadConfig(path);
        }
        boolean isValid = LtpaTokenManager.isValid(LtpaToken.decodeToken(token));
        if (isValid) {
            result = LtpaTokenManager.compare(LtpaToken.decodeToken(token), userNumber);
            if (!result) {
                System.out.println("LTPA token compare false, token:" + token);
            }
        } else {
            System.out.println("LTPA token isValid false, token:" + token);
        }
        return result;
    }

    public static boolean verifyToken(String path, String token, String userNumber, String authPattern) {
        boolean result = false;
        if (path == null || path.trim().length() == 0) {
            LtpaTokenManager.loadDefaultConfig();
        } else {
            LtpaTokenManager.loadConfig(path);
        }
        boolean isValid = LtpaTokenManager.isValid(LtpaToken.decodeToken(token), authPattern);
        if (isValid) {
            result = LtpaTokenManager.compare(LtpaToken.decodeToken(token), userNumber);
            if (!result) {
                System.out.println("LTPA token compare false, token:" + token);
            }
        } else {
            System.out.println("LTPA token isValid false, token:" + token);
        }
        return result;
    }
}

