/*
 * Decompiled with CFR 0.152.
 */
package cn.com.bizunited.wine.base.jpa.config;

import com.alibaba.druid.pool.DruidDataSource;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.stereotype.Component;

@Configuration
@Component
public class DruidDataSourceConfig {
    private static final Logger log = LoggerFactory.getLogger(DruidDataSourceConfig.class);
    @Value(value="${spring.datasource.url}")
    private String dbUrl;
    @Value(value="${spring.datasource.username}")
    private String username;
    @Value(value="${spring.datasource.password}")
    private String password;
    @Value(value="${spring.datasource.driverClassName}")
    private String driverClassName;
    @Value(value="${spring.datasource.druid.initialSize}")
    private Integer initialSize;
    @Value(value="${spring.datasource.druid.minIdle}")
    private Integer minIdle;
    @Value(value="${spring.datasource.druid.maxActive}")
    private Integer maxActive;
    @Value(value="${spring.datasource.druid.maxWait}")
    private Integer maxWait;
    @Value(value="${spring.datasource.druid.timeBetweenEvictionRunsMillis}")
    private Integer timeBetweenEvictionRunsMillis;
    @Value(value="${spring.datasource.druid.minEvictableIdleTimeMillis}")
    private Integer minEvictableIdleTimeMillis;
    @Value(value="${spring.datasource.druid.validationQuery}")
    private String validationQuery;
    @Value(value="${spring.datasource.druid.testWhileIdle}")
    private Boolean testWhileIdle;
    @Value(value="${spring.datasource.druid.testOnBorrow}")
    private Boolean testOnBorrow;
    @Value(value="${spring.datasource.druid.testOnReturn}")
    private Boolean testOnReturn;
    @Value(value="${spring.datasource.druid.poolPreparedStatements}")
    private Boolean poolPreparedStatements;
    @Value(value="${spring.datasource.druid.maxPoolPreparedStatementPerConnectionSize}")
    private Integer maxPoolPreparedStatementPerConnectionSize;
    @Value(value="${spring.datasource.druid.filters}")
    private String filters;
    @Value(value="{spring.datasource.druid.connectionProperties}")
    private String connectionProperties;
    @Value(value="{spring.datasource.druid.useGlobalDataSourceStat}")
    private Boolean useGlobalDataSourceStat;

    @Bean
    @Primary
    public DataSource dataSource() {
        DruidDataSource datasource = new DruidDataSource();
        datasource.setUrl(this.dbUrl);
        datasource.setUsername(this.username);
        datasource.setPassword(this.password);
        datasource.setDriverClassName(this.driverClassName);
        datasource.setInitialSize(this.initialSize == null ? 5 : this.initialSize);
        datasource.setMinIdle(this.minIdle == null ? 1 : this.minIdle);
        datasource.setMaxActive(this.maxActive == null ? 20 : this.minIdle);
        datasource.setMaxWait(this.maxWait == null ? 60000L : (long)this.maxWait.intValue());
        datasource.setTimeBetweenEvictionRunsMillis(this.timeBetweenEvictionRunsMillis == null ? 60000L : (long)this.timeBetweenEvictionRunsMillis.intValue());
        datasource.setMinEvictableIdleTimeMillis(this.minEvictableIdleTimeMillis == null ? 300000L : (long)this.minEvictableIdleTimeMillis.intValue());
        datasource.setValidationQuery(this.validationQuery == null || "".equals(this.validationQuery.trim()) ? "SELECT 1 FROM DUAL" : this.validationQuery);
        datasource.setTestWhileIdle(this.testWhileIdle != null);
        datasource.setTestOnBorrow(this.testOnBorrow != null);
        datasource.setTestOnReturn(this.testOnReturn != null);
        datasource.setPoolPreparedStatements(this.poolPreparedStatements != null);
        datasource.setMaxPoolPreparedStatementPerConnectionSize(this.maxPoolPreparedStatementPerConnectionSize == null ? 20 : this.maxPoolPreparedStatementPerConnectionSize);
        try {
            datasource.setFilters(this.filters == null || "".equals(this.filters.trim()) ? "stat,wall,log4j" : this.filters);
        }
        catch (SQLException e) {
            e.printStackTrace();
            log.error("druid configuration initialization filter", (Throwable)e);
        }
        datasource.setConnectionProperties(this.connectionProperties == null || "".equals(this.connectionProperties.trim()) ? "druid.stat.mergeSql=true;druid.stat.slowSqlMillis=5000" : this.connectionProperties);
        datasource.setUseGlobalDataSourceStat(this.useGlobalDataSourceStat != null);
        return datasource;
    }
}

