/*
 * Decompiled with CFR 0.152.
 */
package cn.wine.common.excel;

import java.util.List;

public interface ExcelDataLoader<T> {
    public ExcelDataLoadResult<T> load();

    public static class ExcelDataLoadResult<T> {
        private boolean hasMoreData;
        private List<T> data;

        ExcelDataLoadResult(boolean hasMoreData, List<T> data) {
            this.hasMoreData = hasMoreData;
            this.data = data;
        }

        public static <T> ExcelDataLoadResultBuilder<T> builder() {
            return new ExcelDataLoadResultBuilder();
        }

        public boolean isHasMoreData() {
            return this.hasMoreData;
        }

        public List<T> getData() {
            return this.data;
        }

        public static class ExcelDataLoadResultBuilder<T> {
            private boolean hasMoreData;
            private List<T> data;

            ExcelDataLoadResultBuilder() {
            }

            public ExcelDataLoadResultBuilder<T> hasMoreData(boolean hasMoreData) {
                this.hasMoreData = hasMoreData;
                return this;
            }

            public ExcelDataLoadResultBuilder<T> data(List<T> data) {
                this.data = data;
                return this;
            }

            public ExcelDataLoadResult<T> build() {
                return new ExcelDataLoadResult<T>(this.hasMoreData, this.data);
            }

            public String toString() {
                return "ExcelDataLoader.ExcelDataLoadResult.ExcelDataLoadResultBuilder(hasMoreData=" + this.hasMoreData + ", data=" + this.data + ")";
            }
        }
    }
}

