/*
 * Decompiled with CFR 0.152.
 */
package cn.wine.common.jackson.serialize;

import cn.wine.common.exception.LongValueFormatException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import java.io.IOException;
import org.apache.commons.lang3.StringUtils;

public class StringifyAnnotationFieldJsonDeserializer
extends JsonDeserializer<Long> {
    private String nullString = String.valueOf(null);

    public Long deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
        String value = p.getValueAsString();
        if (StringUtils.isBlank((CharSequence)value) || this.nullString.equals(value)) {
            return null;
        }
        if (!StringUtils.isNumeric((CharSequence)value)) {
            throw new LongValueFormatException(String.format("\u89e3\u6790 \"%s\":\"%s\" \u51fa\u73b0\u5f02\u5e38,\u8bf7\u68c0\u67e5\u6570\u636e\u662f\u5426\u6b63\u786e", p.getParsingContext().getCurrentName(), value));
        }
        try {
            return Long.valueOf(value);
        }
        catch (NumberFormatException e) {
            throw new LongValueFormatException(String.format("\u89e3\u6790 \"%s\":\"%s\" \u51fa\u73b0\u5f02\u5e38,\u8bf7\u68c0\u67e5\u6570\u636e\u662f\u5426\u6b63\u786e", p.getParsingContext().getCurrentName(), value));
        }
    }
}

