/*
 * Decompiled with CFR 0.152.
 */
package cn.wine.common.service.impl;

import cn.wine.common.network.IpUtils;
import cn.wine.common.service.IIdService;
import java.net.UnknownHostException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultIdServiceImpl
implements IIdService {
    private static final long twepoch = 1409030641843L;
    private static final long workerIdBits = 9L;
    private static final long dataCenterIdBits = 1L;
    private static final long maxWorkerId = 511L;
    private static final long sequenceBits = 12L;
    private static final long workerIdShift = 12L;
    private static final long dataCenterIdShift = 21L;
    private static final long timestampLeftShift = 22L;
    private static final long sequenceMask = 4095L;
    private static long lastTimestamp = -1L;
    private long sequence = 0L;
    private long workerId = -1L;
    private long dataCenterId = 0L;
    private static final Logger logger = LoggerFactory.getLogger(DefaultIdServiceImpl.class);

    public DefaultIdServiceImpl() {
        String ipAddress;
        try {
            ipAddress = IpUtils.getLocalHostLanIpAddress().getHostAddress();
        }
        catch (UnknownHostException e) {
            throw new RuntimeException(e);
        }
        String[] ipArray = ipAddress.split("\\.");
        this.dataCenterId = 1L;
        this.workerId = Long.valueOf(ipArray[3]);
        logger.warn("Init IdService by dataCenterId:{} and workerId:{}, it maybe duplicate.", (Object)this.dataCenterId, (Object)this.workerId);
    }

    public synchronized long getNextId() {
        if (this.workerId == -1L) {
            throw new IllegalStateException("id service \u6ca1\u6709\u521d\u59cb\u5316\u5b8c\u6210");
        }
        long timestamp = this.timeGen();
        if (timestamp < lastTimestamp) {
            try {
                throw new Exception("Clock moved backwards.  Refusing to generate id for " + (lastTimestamp - timestamp) + " milliseconds");
            }
            catch (Exception e) {
                logger.info("Got an exception when generate next id.", (Throwable)e);
            }
        }
        if (lastTimestamp == timestamp) {
            this.sequence = this.sequence + 1L & 0xFFFL;
            if (this.sequence == 0L) {
                timestamp = this.tilNextMillis(lastTimestamp);
            }
        } else {
            this.sequence = 0L;
        }
        lastTimestamp = timestamp;
        long nextId = timestamp - 1409030641843L << 22 | this.dataCenterId << 21 | this.workerId << 12 | this.sequence;
        return nextId;
    }

    private long tilNextMillis(long lastTimestamp) {
        long timestamp = this.timeGen();
        while (timestamp <= lastTimestamp) {
            timestamp = this.timeGen();
        }
        return timestamp;
    }

    private long timeGen() {
        return System.currentTimeMillis();
    }

    @Override
    public synchronized Long nextLongId() {
        return this.getNextId();
    }

    @Override
    public synchronized String nextStringId() {
        return String.valueOf(this.getNextId());
    }
}

