/*
 * Decompiled with CFR 0.152.
 */
package cn.wine.common.utils;

import cn.wine.common.exception.GzipException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;

public class GzipUtils {
    public static int BUFFER_SIZE = 256;

    public static byte[] compress(byte[] data) {
        if (ArrayUtils.isEmpty((byte[])data)) {
            return data;
        }
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            GZIPOutputStream gzip = new GZIPOutputStream(out);
            gzip.write(data);
            gzip.close();
            return out.toByteArray();
        }
        catch (IOException e) {
            throw new GzipException("Gzip compress failed.", e);
        }
    }

    public static byte[] compress(String data) {
        if (StringUtils.isEmpty((CharSequence)data)) {
            return null;
        }
        return GzipUtils.compress(GzipUtils.getBytes(data));
    }

    private static byte[] getBytes(String data) {
        try {
            return data.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new GzipException("\u4e0d\u652f\u6301\u7684\u5b57\u7b26\u96c6", e);
        }
    }

    public static byte[] decompress(byte[] data) {
        if (ArrayUtils.isEmpty((byte[])data)) {
            return data;
        }
        try {
            int n;
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            ByteArrayInputStream in = new ByteArrayInputStream(data);
            GZIPInputStream gzipInputStream = new GZIPInputStream(in);
            byte[] buffer = new byte[BUFFER_SIZE];
            while ((n = gzipInputStream.read(buffer)) >= 0) {
                out.write(buffer, 0, n);
            }
            gzipInputStream.close();
            in.close();
            return out.toByteArray();
        }
        catch (IOException e) {
            throw new GzipException("Gzip compress failed.", e);
        }
    }
}

