/*
 * Decompiled with CFR 0.152.
 */
package cn.wine.common.utils;

import cn.wine.common.vo.JsonResult;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.type.TypeFactory;
import com.fasterxml.jackson.datatype.guava.GuavaModule;
import com.fasterxml.jackson.datatype.jdk8.Jdk8Module;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.google.common.collect.Maps;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

public class JsonUtils {
    public static final String JSON_DESERIALIZE_ERROR_MSG = "Json\u53cd\u5e8f\u5217\u5316\u51fa\u9519";
    public static final String JSON_SERIALIZE_ERROR_MSG = "Json\u5e8f\u5217\u5316\u51fa\u9519";
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper().registerModule((Module)new Jdk8Module()).registerModule((Module)new JavaTimeModule()).registerModule((Module)new GuavaModule()).setSerializationInclusion(JsonInclude.Include.NON_NULL).configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false).configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);

    public static Object json2Obj(String jsonStr) {
        return JsonUtils.json2Obj(jsonStr, Object.class);
    }

    public static <T> T json2Obj(String jsonStr, Class<T> clazz) {
        if (jsonStr == null) {
            return null;
        }
        try {
            return (T)OBJECT_MAPPER.readValue(jsonStr, clazz);
        }
        catch (Exception e) {
            throw new RuntimeException(JSON_DESERIALIZE_ERROR_MSG, e);
        }
    }

    public static void writeJson2Obj2OutputStream(Object content, OutputStream outputStream) {
        if (Objects.isNull(content)) {
            return;
        }
        try {
            OBJECT_MAPPER.writeValue(outputStream, content);
        }
        catch (Exception e) {
            throw new RuntimeException(JSON_SERIALIZE_ERROR_MSG, e);
        }
    }

    public static <T> T json2Obj(String content, Class<T> clazzItem, Class ... classes) {
        if (StringUtils.isBlank((CharSequence)content)) {
            return null;
        }
        JavaType javaType = OBJECT_MAPPER.getTypeFactory().constructParametricType(clazzItem, classes);
        try {
            return (T)OBJECT_MAPPER.readValue(content, javaType);
        }
        catch (Exception e) {
            throw new RuntimeException(JSON_DESERIALIZE_ERROR_MSG, e);
        }
    }

    public static TypeFactory getTypeFactory() {
        return OBJECT_MAPPER.getTypeFactory();
    }

    public static <T> JsonResult<T> parseJsonResult(String content, Class<T> clazzItem, Class ... classes) {
        if (StringUtils.isBlank((CharSequence)content)) {
            return null;
        }
        JavaType javaType = OBJECT_MAPPER.getTypeFactory().constructParametricType(clazzItem, classes);
        JavaType finalJavaType = OBJECT_MAPPER.getTypeFactory().constructParametricType(JsonResult.class, new JavaType[]{javaType});
        try {
            return (JsonResult)OBJECT_MAPPER.readValue(content, finalJavaType);
        }
        catch (Exception e) {
            throw new RuntimeException(JSON_DESERIALIZE_ERROR_MSG, e);
        }
    }

    public static <T> T json2Obj(String content, JavaType javaType) {
        if (StringUtils.isBlank((CharSequence)content)) {
            return null;
        }
        try {
            return (T)OBJECT_MAPPER.readValue(content, javaType);
        }
        catch (Exception e) {
            throw new RuntimeException(JSON_DESERIALIZE_ERROR_MSG, e);
        }
    }

    public static <K, V> Map<K, V> json2Map(String content, Class<K> keyCls, Class<V> valueCls) {
        Map jsonMap = JsonUtils.json2Obj(content, Map.class);
        if (jsonMap == null) {
            return null;
        }
        HashMap result = Maps.newHashMap();
        jsonMap.forEach((key, value) -> {
            Object keyObj = JsonUtils.json2Obj(key, keyCls);
            Object valueObj = JsonUtils.json2Obj(value.toString(), valueCls);
            result.put(keyObj, valueObj);
        });
        return result;
    }

    public static String obj2Json(Object obj) {
        try {
            return OBJECT_MAPPER.writeValueAsString(obj);
        }
        catch (Exception e) {
            throw new RuntimeException(JSON_SERIALIZE_ERROR_MSG, e);
        }
    }
}

