/*
 * Decompiled with CFR 0.152.
 */
package cn.wine.common.utils.network;

import cn.wine.common.utils.JsonUtils;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.lang.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sun.net.util.IPAddressUtil;

public class IpAddressMatcher {
    private static final Logger log = LoggerFactory.getLogger(IpAddressMatcher.class);
    private Set<IpRange> ipRanges = new HashSet<IpRange>();
    private boolean matchAll = false;

    public IpAddressMatcher(String ... ipRangeTexts) {
        if (ArrayUtils.isNotEmpty((Object[])ipRangeTexts)) {
            for (String ipRangeText : ipRangeTexts) {
                if (ipRangeText.indexOf(44) > 0) {
                    String[] subIpRangeTexts;
                    for (String subIpRangeText : subIpRangeTexts = ipRangeText.split(",")) {
                        this.addIpRange(subIpRangeText);
                    }
                    continue;
                }
                this.addIpRange(ipRangeText);
            }
        }
    }

    public void addIpRange(String ipRangeText) {
        IpRange ipRange = new IpRange(ipRangeText);
        this.ipRanges.add(ipRange);
        this.matchAll = this.matchAll || ipRange.isMatchAll();
    }

    public void addAllInternalIpRange() {
        this.ipRanges.add(new IpRange("10.0.0.1/8"));
        this.ipRanges.add(new IpRange("172.16.0.1/12"));
        this.ipRanges.add(new IpRange("192.168.0.1/16"));
    }

    public boolean isInRange(String ipAddress) {
        if (this.matchAll) {
            return true;
        }
        for (IpRange ipRange : this.ipRanges) {
            if (!ipRange.isInRange(ipAddress)) continue;
            return true;
        }
        return false;
    }

    public static class IpRange {
        private static final char NET_MASK_FLAG = '/';
        private static final String ALL_FLAG = "*";
        private static final int OXFF = 255;
        private static final int IPV4_LAST_INDEX = 3;
        private int[][] rangeArray = new int[4][2];
        private boolean matchAll = false;

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            IpRange ipRange = (IpRange)o;
            return this.matchAll == ipRange.matchAll && Arrays.equals((Object[])this.rangeArray, (Object[])ipRange.rangeArray);
        }

        public int hashCode() {
            int result = Objects.hash(this.matchAll);
            result = 31 * result + Arrays.hashCode((Object[])this.rangeArray);
            return result;
        }

        private IpRange(String originIpRange) {
            if (originIpRange == null) {
                throw new IllegalArgumentException("IpRange is null");
            }
            String ipRange = originIpRange.trim();
            if (ipRange.equals(ALL_FLAG)) {
                this.matchAll = true;
                return;
            }
            int netMaskFlagIndex = ipRange.indexOf(47);
            if (netMaskFlagIndex > 0) {
                String ipAddress = ipRange.substring(0, netMaskFlagIndex);
                byte[] ipBytes = IPAddressUtil.textToNumericFormatV4(ipAddress);
                String netMask = ipRange.substring(netMaskFlagIndex + 1);
                int nMaskBits = Integer.parseInt(netMask);
                int oddBits = nMaskBits % 8;
                int nMaskBytes = nMaskBits / 8 + (oddBits == 0 ? 0 : 1);
                byte[] mask = new byte[nMaskBytes];
                Arrays.fill(mask, 0, oddBits == 0 ? mask.length : mask.length - 1, (byte)-1);
                if (oddBits != 0) {
                    int finalByte = (1 << oddBits) - 1;
                    mask[mask.length - 1] = (byte)(finalByte <<= 8 - oddBits);
                }
                for (int i = 0; i <= 3; ++i) {
                    int ip = ipBytes[i] & 0xFF;
                    if (i < mask.length) {
                        if (mask[i] == -1) {
                            this.rangeArray[i] = new int[]{ip, ip};
                            continue;
                        }
                        int startIp = mask[i] & ip;
                        if (i == 3) {
                            int ipLeft = startIp + 1;
                            int ipRight = startIp + 255 - mask[i] & 0xFE;
                            this.rangeArray[i] = new int[]{Math.min(ipLeft, ipRight), Math.max(ipLeft, ipRight)};
                            continue;
                        }
                        this.rangeArray[i] = new int[]{startIp, startIp + 255 - mask[i] & 0xFF};
                        continue;
                    }
                    this.rangeArray[i] = new int[]{i == 3 ? 1 : 0, i == 3 ? 254 : 255};
                }
                if (log.isTraceEnabled()) {
                    log.trace(ipRange + ": " + JsonUtils.obj2Json(this.rangeArray));
                }
                return;
            }
            String[] ipDataArray = ipRange.split("\\.");
            for (int i = 0; i <= 3; ++i) {
                String ipData = ipDataArray[i];
                if (ipData.matches("\\d{1,3}")) {
                    int ipValue = Integer.parseInt(ipData);
                    if (ipValue > 255) {
                        throw new IllegalArgumentException("Please input correct ip range, ip must between 0,255");
                    }
                    if (ipValue == 0) {
                        if (i == 0) {
                            throw new IllegalArgumentException("Please input correct ip range, 0 is not allow first.");
                        }
                        if (i == 3) {
                            this.rangeArray[i] = new int[]{1, 254};
                            continue;
                        }
                        this.rangeArray[i] = new int[]{0, 0};
                        continue;
                    }
                    this.rangeArray[i] = new int[]{ipValue, ipValue};
                    continue;
                }
                if (ipData.matches("\\d{1,3}-\\d{1,3}")) {
                    String[] ipValueArray = ipData.split("-");
                    int ipLower = Integer.parseInt(ipValueArray[0]);
                    if (ipLower < 1 || ipLower > 254) {
                        throw new IllegalArgumentException("Please input correct ip range, ip must between 1,254");
                    }
                    int ipHigher = Integer.parseInt(ipValueArray[1]);
                    if (ipHigher > 254 || ipLower > ipHigher) {
                        throw new IllegalArgumentException("Please input correct ip range");
                    }
                    this.rangeArray[i] = new int[]{ipLower, ipHigher};
                    continue;
                }
                throw new IllegalArgumentException(String.format("Please input correct ip range:%s", ipRange));
            }
        }

        boolean isMatchAll() {
            return this.matchAll;
        }

        boolean isInRange(String ip) {
            InetAddress inetAddress;
            if (ip == null) {
                return false;
            }
            try {
                inetAddress = InetAddress.getByName(ip);
            }
            catch (UnknownHostException e) {
                return false;
            }
            if (this.matchAll) {
                return true;
            }
            byte[] address = inetAddress.getAddress();
            for (int i = 0; i <= 3; ++i) {
                int addr = address[i] & 0xFF;
                if (addr >= this.rangeArray[i][0] && addr <= this.rangeArray[i][1]) continue;
                return false;
            }
            return true;
        }
    }
}

