/*
 * Decompiled with CFR 0.152.
 */
package cn.wine.common.utils.network;

import cn.wine.common.exception.BusinessSilentException;
import cn.wine.common.exception.CommonExceptions;
import cn.wine.common.exception.ExceptionType;
import org.apache.commons.lang.ArrayUtils;

public class UrlUtils {
    public static final String PATH_JOIN_SYMBOL = "/";

    public static String join(String ... pathSections) {
        if (ArrayUtils.isEmpty((Object[])pathSections)) {
            throw new BusinessSilentException((ExceptionType)CommonExceptions.PARAM_ERROR, "\u8bf7\u4f20\u5165\u6b63\u786e\u7684path");
        }
        if (pathSections.length == 1) {
            return pathSections[0];
        }
        String previousPath = pathSections[0];
        StringBuilder sb = new StringBuilder(previousPath);
        for (int i = 1; i < pathSections.length; ++i) {
            String currentPathSection = pathSections[i];
            if (currentPathSection == null) continue;
            if (previousPath.endsWith(PATH_JOIN_SYMBOL)) {
                if (currentPathSection.startsWith(PATH_JOIN_SYMBOL)) {
                    sb.append(currentPathSection.substring(1));
                } else {
                    sb.append(currentPathSection);
                }
            } else if (currentPathSection.startsWith(PATH_JOIN_SYMBOL)) {
                sb.append(currentPathSection);
            } else {
                sb.append(PATH_JOIN_SYMBOL).append(currentPathSection);
            }
            previousPath = currentPathSection;
        }
        return sb.toString();
    }
}

