/*
 * Decompiled with CFR 0.152.
 */
package cn.wine.common.utils.security;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.security.MessageDigest;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;

public class DigestHelper {
    public static String digest(MessageDigest digest, File source) throws IOException {
        FileInputStream in = new FileInputStream(source);
        FileChannel ch = in.getChannel();
        MappedByteBuffer byteBuffer = ch.map(FileChannel.MapMode.READ_ONLY, 0L, source.length());
        digest.update(byteBuffer);
        String bufferToHex = Hex.encodeHexString((byte[])digest.digest());
        ch.close();
        in.close();
        return bufferToHex;
    }

    public static String digest(MessageDigest digest, String source) {
        if (StringUtils.isBlank((CharSequence)source)) {
            return null;
        }
        return DigestHelper.digest(digest, source.getBytes());
    }

    public static String digest(MessageDigest digest, byte[] source) {
        if (ArrayUtils.isEmpty((byte[])source)) {
            return null;
        }
        digest.update(source);
        return Hex.encodeHexString((byte[])digest.digest());
    }
}

