/*
 * Decompiled with CFR 0.152.
 */
package cn.wine.common.utils.security;

import cn.wine.common.utils.security.DigestHelper;
import cn.wine.common.utils.security.IDigestUtils;
import java.io.File;
import java.io.IOException;
import java.security.MessageDigest;
import org.apache.commons.codec.digest.DigestUtils;

public class SHA256Utils
implements IDigestUtils {
    private static final ThreadLocal<MessageDigest> MESSAGE_DIGEST_THREAD_LOCAL = new ThreadLocal();

    private static MessageDigest getMessageDigest() {
        if (MESSAGE_DIGEST_THREAD_LOCAL.get() == null) {
            MESSAGE_DIGEST_THREAD_LOCAL.set(DigestUtils.getSha256Digest());
        }
        return MESSAGE_DIGEST_THREAD_LOCAL.get();
    }

    public static SHA256Utils instance() {
        return Md5UtilsInstanceHolder.INSTANCE;
    }

    @Override
    public String digest(File source) throws IOException {
        return DigestHelper.digest(SHA256Utils.getMessageDigest(), source);
    }

    @Override
    public String digest(String source) {
        return DigestHelper.digest(SHA256Utils.getMessageDigest(), source);
    }

    @Override
    public String digest(byte[] source) {
        return DigestHelper.digest(SHA256Utils.getMessageDigest(), source);
    }

    private static class Md5UtilsInstanceHolder {
        private static final SHA256Utils INSTANCE = new SHA256Utils();

        private Md5UtilsInstanceHolder() {
        }
    }
}

