/*
 * Decompiled with CFR 0.152.
 */
package cn.wine.common.vo;

import cn.wine.common.exception.BusinessException;
import cn.wine.common.exception.CommonExceptions;
import cn.wine.common.exception.ExceptionType;
import com.fasterxml.jackson.annotation.JsonIgnore;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

@ApiModel(description="RPC\u8c03\u7528\u7ed3\u679c")
public class JsonResult<T> {
    @ApiModelProperty(value="\u670d\u52a1\u5668RPC\u54cd\u5e94code", example="200")
    private int code = 200;
    @ApiModelProperty(value="\u6267\u884c\u7ed3\u679c\u63cf\u8ff0", example="success")
    private String msg = "success";
    @ApiModelProperty(value="\u670d\u52a1\u5668\u7ed3\u679c\u8fd4\u56de\u65f6\u7684 Unix timestamp,\u5355\u4f4d\u6beb\u79d2", example="1356019200000")
    private long ts = System.currentTimeMillis();
    @ApiModelProperty(name="data", value="\u54cd\u5e94\u7ed3\u679c", example="{}")
    private T data;

    public JsonResult(int code, String msg) {
        this.code = code;
        this.msg = msg;
    }

    public JsonResult(int code, String msg, T data) {
        this.code = code;
        this.msg = msg;
        this.data = data;
    }

    @JsonIgnore
    public boolean isOK() {
        return this.code == 200 || this.code == 0;
    }

    public JsonResult(T data) {
        this.data = data;
    }

    public JsonResult(ExceptionType exceptionType) {
        this(exceptionType.getCode(), exceptionType.getDescription());
    }

    public JsonResult(BusinessException bisinessException) {
        this(bisinessException.getCode(), bisinessException.getDescription());
    }

    public static <T> JsonResult<T> of(T data) {
        return new JsonResult<T>(data);
    }

    public static JsonResult of(Exception ex) {
        if (ex instanceof BusinessException) {
            return new JsonResult<String>(((BusinessException)((Object)ex)).getCode(), ((BusinessException)((Object)ex)).getDescription(), ex.getMessage());
        }
        return new JsonResult(CommonExceptions.SERVER_ERROR.getCode(), ex.getMessage());
    }

    public int getCode() {
        return this.code;
    }

    public String getMsg() {
        return this.msg;
    }

    public long getTs() {
        return this.ts;
    }

    public T getData() {
        return this.data;
    }

    public JsonResult() {
    }
}

