/*
 * Decompiled with CFR 0.152.
 */
package cn.wine.common.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;

@ApiModel(description="\u5206\u9875\u6570\u636e")
public class SpringPageVO<T>
implements Serializable {
    private static final long serialVersionUID = -6344449330097328246L;
    @ApiModelProperty(value="\u5185\u5bb9")
    private List<T> content = Collections.emptyList();
    @ApiModelProperty(value="\u603b\u6761\u6570", example="0")
    private Long totalElements = 0L;
    @ApiModelProperty(value="\u6bcf\u9875\u591a\u5c11\u6761\u6570\u636e", example="10")
    private Integer size = 0;
    @ApiModelProperty(value="\u5f53\u524d\u9875", example="1")
    private Integer number = 0;

    @ApiModelProperty(value="\u603b\u9875\u6570", example="1")
    public Integer getTotalPages() {
        return this.getSize() == 0 ? 1 : (int)Math.ceil((double)this.totalElements.longValue() / (double)this.getSize().intValue());
    }

    @ApiModelProperty(value="\u662f\u5426\u6709\u4e0a\u4e00\u9875", example="false")
    public Boolean hasPrevious() {
        return this.number > 1;
    }

    @ApiModelProperty(value="\u662f\u5426\u6709\u4e0b\u4e00\u9875", example="false")
    public Boolean hasNext() {
        return this.getNumber() < this.getTotalPages();
    }

    @ApiModelProperty(value="\u5f53\u524d\u8fd4\u56de\u7684\u6570\u636e\u6761\u6570", example="0")
    public Integer getNumberOfElements() {
        return this.content.size();
    }

    public static <T> Builder<T> builder() {
        return new Builder();
    }

    public SpringPageVO() {
    }

    public SpringPageVO(List<T> content, Long totalElements, Integer size, Integer number) {
        this.content = content;
        this.totalElements = totalElements;
        this.size = size;
        this.number = number;
    }

    public List<T> getContent() {
        return this.content;
    }

    public Long getTotalElements() {
        return this.totalElements;
    }

    public Integer getSize() {
        return this.size;
    }

    public Integer getNumber() {
        return this.number;
    }

    public void setContent(List<T> content) {
        this.content = content;
    }

    public void setTotalElements(Long totalElements) {
        this.totalElements = totalElements;
    }

    public void setSize(Integer size) {
        this.size = size;
    }

    public void setNumber(Integer number) {
        this.number = number;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SpringPageVO)) {
            return false;
        }
        SpringPageVO other = (SpringPageVO)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<T> this$content = this.getContent();
        List<T> other$content = other.getContent();
        if (this$content == null ? other$content != null : !((Object)this$content).equals(other$content)) {
            return false;
        }
        Long this$totalElements = this.getTotalElements();
        Long other$totalElements = other.getTotalElements();
        if (this$totalElements == null ? other$totalElements != null : !((Object)this$totalElements).equals(other$totalElements)) {
            return false;
        }
        Integer this$size = this.getSize();
        Integer other$size = other.getSize();
        if (this$size == null ? other$size != null : !((Object)this$size).equals(other$size)) {
            return false;
        }
        Integer this$number = this.getNumber();
        Integer other$number = other.getNumber();
        return !(this$number == null ? other$number != null : !((Object)this$number).equals(other$number));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SpringPageVO;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<T> $content = this.getContent();
        result = result * 59 + ($content == null ? 43 : ((Object)$content).hashCode());
        Long $totalElements = this.getTotalElements();
        result = result * 59 + ($totalElements == null ? 43 : ((Object)$totalElements).hashCode());
        Integer $size = this.getSize();
        result = result * 59 + ($size == null ? 43 : ((Object)$size).hashCode());
        Integer $number = this.getNumber();
        result = result * 59 + ($number == null ? 43 : ((Object)$number).hashCode());
        return result;
    }

    public String toString() {
        return "SpringPageVO(content=" + this.getContent() + ", totalElements=" + this.getTotalElements() + ", size=" + this.getSize() + ", number=" + this.getNumber() + ")";
    }

    public static class Builder<T> {
        private SpringPageVO<T> vo = new SpringPageVO();

        public Builder<T> content(List<T> content) {
            this.vo.setContent(content);
            return this;
        }

        public Builder<T> totalElements(Long totalElements) {
            this.vo.setTotalElements(totalElements);
            return this;
        }

        public Builder<T> size(Integer size) {
            this.vo.setSize(size);
            return this;
        }

        public Builder<T> number(Integer number) {
            this.vo.setNumber(number);
            return this;
        }

        public SpringPageVO<T> build() {
            return this.vo;
        }
    }
}

