/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.pool.ha.selector;

import com.alibaba.druid.pool.DruidDataSource;
import com.alibaba.druid.pool.DruidPooledConnection;
import com.alibaba.druid.pool.ha.selector.RandomDataSourceSelector;
import com.alibaba.druid.support.logging.Log;
import com.alibaba.druid.support.logging.LogFactory;
import com.alibaba.druid.util.JdbcUtils;
import javax.sql.DataSource;

public class RandomDataSourceRecoverThread
implements Runnable {
    private static final Log LOG = LogFactory.getLog(RandomDataSourceRecoverThread.class);
    private RandomDataSourceSelector selector;
    private int sleepSeconds = 120;
    private int validationSleepSeconds = 0;

    public RandomDataSourceRecoverThread(RandomDataSourceSelector selector) {
        this.selector = selector;
    }

    @Override
    public void run() {
        while (true) {
            if (this.selector != null && this.selector.getBlacklist() != null && !this.selector.getBlacklist().isEmpty()) {
                LOG.info(this.selector.getBlacklist().size() + " DataSource in blacklist.");
                for (DataSource dataSource : this.selector.getBlacklist()) {
                    if (!(dataSource instanceof DruidDataSource)) continue;
                    this.tryOneDataSource((DruidDataSource)dataSource);
                }
            }
            this.sleep();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void tryOneDataSource(DruidDataSource dataSource) {
        if (dataSource == null) {
            return;
        }
        DruidPooledConnection connection = null;
        try {
            connection = dataSource.getConnection();
            this.sleepBeforeValidation();
            dataSource.validateConnection(connection);
            LOG.info(dataSource.getName() + " is available now.");
            this.selector.removeBlacklist(dataSource);
        }
        catch (Exception e) {
            LOG.warn("DataSource[" + dataSource.getName() + "] is still unavailable. Exception: " + e.getMessage());
        }
        finally {
            JdbcUtils.close(connection);
        }
    }

    private void sleepBeforeValidation() {
        if (this.validationSleepSeconds > 0) {
            try {
                LOG.debug("Sleep " + this.validationSleepSeconds + " second(s) before validation.");
                Thread.sleep(this.validationSleepSeconds * 1000);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    private void sleep() {
        try {
            Thread.sleep(this.sleepSeconds * 1000);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public int getSleepSeconds() {
        return this.sleepSeconds;
    }

    public void setSleepSeconds(int sleepSeconds) {
        this.sleepSeconds = sleepSeconds;
    }

    public int getValidationSleepSeconds() {
        return this.validationSleepSeconds;
    }

    public void setValidationSleepSeconds(int validationSleepSeconds) {
        this.validationSleepSeconds = validationSleepSeconds;
    }
}

