/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dubbo.governance.service.impl;

import com.alibaba.dubbo.common.Constants;
import com.alibaba.dubbo.common.utils.StringUtils;
import com.alibaba.dubbo.governance.service.OverrideService;
import com.alibaba.dubbo.governance.service.OwnerService;
import com.alibaba.dubbo.governance.service.ProviderService;
import com.alibaba.dubbo.governance.service.impl.AbstractService;
import com.alibaba.dubbo.registry.common.domain.Override;
import com.alibaba.dubbo.registry.common.domain.Owner;
import com.alibaba.dubbo.registry.common.domain.Provider;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;

public class OwnerServiceImpl
extends AbstractService
implements OwnerService {
    @Autowired
    ProviderService providerService;
    @Autowired
    OverrideService overrideService;

    public List<String> findAllServiceNames() {
        return null;
    }

    public List<String> findServiceNamesByUsername(String username) {
        return null;
    }

    public List<String> findUsernamesByServiceName(String serviceName) {
        return null;
    }

    public List<Owner> findByService(String serviceName) {
        List pList = this.providerService.findByService(serviceName);
        List cList = this.overrideService.findByServiceAndAddress(serviceName, "0.0.0.0");
        return this.toOverrideLiset(pList, cList);
    }

    public List<Owner> findAll() {
        List pList = this.providerService.findAll();
        List cList = this.overrideService.findAll();
        return this.toOverrideLiset(pList, cList);
    }

    public Owner findById(Long id) {
        return null;
    }

    private List<Owner> toOverrideLiset(List<Provider> pList, List<Override> cList) {
        HashMap<String, Owner> oList = new HashMap<String, Owner>();
        for (Provider p : pList) {
            if (p.getUsername() == null) continue;
            for (String username : Constants.COMMA_SPLIT_PATTERN.split(p.getUsername())) {
                Owner o = new Owner();
                o.setService(p.getService());
                o.setUsername(username);
                oList.put(o.getService() + "/" + o.getUsername(), o);
            }
        }
        for (Override c : cList) {
            Map params = StringUtils.parseQueryString((String)c.getParams());
            String usernames = (String)params.get("owner");
            if (usernames == null || usernames.length() <= 0) continue;
            for (String username : Constants.COMMA_SPLIT_PATTERN.split(usernames)) {
                Owner o = new Owner();
                o.setService(c.getService());
                o.setUsername(username);
                oList.put(o.getService() + "/" + o.getUsername(), o);
            }
        }
        return new ArrayList<Owner>(oList.values());
    }

    public void saveOwner(Owner owner) {
        List overrides = this.overrideService.findByServiceAndAddress(owner.getService(), "0.0.0.0");
        if (overrides == null || overrides.size() == 0) {
            Override override = new Override();
            override.setAddress("0.0.0.0");
            override.setService(owner.getService());
            override.setEnabled(true);
            override.setParams("owner=" + owner.getUsername());
            this.overrideService.saveOverride(override);
        } else {
            for (Override override : overrides) {
                Map params = StringUtils.parseQueryString((String)override.getParams());
                String usernames = (String)params.get("owner");
                usernames = usernames == null || usernames.length() == 0 ? owner.getUsername() : usernames + "," + owner.getUsername();
                params.put("owner", usernames);
                override.setParams(StringUtils.toQueryString((Map)params));
                this.overrideService.updateOverride(override);
            }
        }
    }

    public void deleteOwner(Owner owner) {
        List overrides = this.overrideService.findByServiceAndAddress(owner.getService(), "0.0.0.0");
        if (overrides == null || overrides.size() == 0) {
            Override override = new Override();
            override.setAddress("0.0.0.0");
            override.setService(owner.getService());
            override.setEnabled(true);
            override.setParams("owner=" + owner.getUsername());
            this.overrideService.saveOverride(override);
        } else {
            for (Override override : overrides) {
                Map params = StringUtils.parseQueryString((String)override.getParams());
                String usernames = (String)params.get("owner");
                if (usernames == null || usernames.length() <= 0) continue;
                if (usernames.equals(owner.getUsername())) {
                    params.remove("owner");
                } else {
                    usernames = usernames.replace(owner.getUsername() + ",", "").replace("," + owner.getUsername(), "");
                    params.put("owner", usernames);
                }
                if (params.size() > 0) {
                    override.setParams(StringUtils.toQueryString((Map)params));
                    this.overrideService.updateOverride(override);
                    continue;
                }
                this.overrideService.deleteOverride(override.getId());
            }
        }
    }
}

