/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dubbo.governance.web.governance.module.screen;

import com.alibaba.dubbo.common.URL;
import com.alibaba.dubbo.common.utils.CollectionUtils;
import com.alibaba.dubbo.common.utils.StringUtils;
import com.alibaba.dubbo.governance.service.ConsumerService;
import com.alibaba.dubbo.governance.service.OverrideService;
import com.alibaba.dubbo.governance.service.ProviderService;
import com.alibaba.dubbo.governance.web.common.module.screen.Restful;
import com.alibaba.dubbo.registry.common.domain.Override;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.springframework.beans.factory.annotation.Autowired;

/*
 * Exception performing whole class analysis ignored.
 */
public class Overrides
extends Restful {
    @Autowired
    private OverrideService overrideService;
    @Autowired
    private ProviderService providerService;
    @Autowired
    private ConsumerService consumerService;
    static final Pattern AND = Pattern.compile("\\&");
    static final Pattern EQUAL = Pattern.compile("([^=\\s]*)\\s*=\\s*(\\S*)");
    static final String DEFAULT_MOCK_JSON_KEY = "mock";
    static final String MOCK_JSON_KEY_POSTFIX = ".mock";
    static final String FORM_OVERRIDE_KEY = "overrideKey";
    static final String FORM_OVERRIDE_VALUE = "overrideValue";
    static final String FORM_DEFAULT_MOCK_METHOD_FORCE = "mockDefaultMethodForce";
    static final String FORM_DEFAULT_MOCK_METHOD_JSON = "mockDefaultMethodJson";
    static final String FORM_ORIGINAL_METHOD_FORCE_PREFIX = "mockMethodForce.";
    static final String FORM_ORIGINAL_METHOD_PREFIX = "mockMethod.";
    static final String FORM_DYNAMIC_METHOD_NAME_PREFIX = "mockMethodName";
    static final String FORM_DYNAMIC_METHOD_FORCE_PREFIX = "mockMethodForce";
    static final String FORM_DYNAMIC_METHOD_JSON_PREFIX = "mockMethodJson";

    public void index(Map<String, Object> context) {
        String service = (String)context.get("service");
        String application = (String)context.get("application");
        String address = (String)context.get("address");
        List overrides = StringUtils.isNotEmpty((String)service) ? this.overrideService.findByService(service) : (StringUtils.isNotEmpty((String)application) ? this.overrideService.findByApplication(application) : (StringUtils.isNotEmpty((String)address) ? this.overrideService.findByAddress(address) : this.overrideService.findAll()));
        context.put("overrides", overrides);
    }

    public void show(Long id, Map<String, Object> context) {
        Override override = this.overrideService.findById(id);
        Map parameters = Overrides.parseQueryString((String)override.getParams());
        if (parameters.get("mock") != null) {
            String mock = URL.decode((String)((String)parameters.get("mock")));
            String[] tokens = this.parseMock(mock);
            context.put("mockDefaultMethodForce", tokens[0]);
            context.put("mockDefaultMethodJson", tokens[1]);
            parameters.remove("mock");
        }
        LinkedHashMap method2Force = new LinkedHashMap();
        LinkedHashMap method2Json = new LinkedHashMap();
        Iterator iterator = parameters.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry e = iterator.next();
            String key = (String)e.getKey();
            if (!key.endsWith(".mock")) continue;
            String m = key.substring(0, key.length() - ".mock".length());
            this.parseMock(m, (String)e.getValue(), method2Force, method2Json);
            iterator.remove();
        }
        context.put("methodForces", method2Force);
        context.put("methodJsons", method2Json);
        context.put("parameters", parameters);
        context.put("override", override);
    }

    public void add(Map<String, Object> context) {
        ArrayList serviceList = new ArrayList();
        ArrayList applicationList = new ArrayList();
        String service = (String)context.get("service");
        String application = (String)context.get("application");
        if (StringUtils.isNotEmpty((String)application)) {
            serviceList.addAll(this.providerService.findServicesByApplication(application));
            serviceList.addAll(this.consumerService.findServicesByApplication(application));
            context.put("serviceList", serviceList);
        } else if (StringUtils.isNotEmpty((String)service)) {
            applicationList.addAll(this.providerService.findApplicationsByServiceName(service));
            applicationList.addAll(this.consumerService.findApplicationsByServiceName(service));
            context.put("applicationList", applicationList);
        } else {
            serviceList.addAll(this.providerService.findServices());
            serviceList.addAll(this.consumerService.findServices());
            this.providerService.findServicesByApplication(application);
            this.consumerService.findServicesByApplication(application);
        }
        context.put("serviceList", serviceList);
        if (StringUtils.isNotEmpty((String)service) && !service.contains("*")) {
            context.put("methods", CollectionUtils.sort(new ArrayList(this.providerService.findMethodsByService(service))));
        }
    }

    static Map<String, String> parseQueryString(String query) {
        String[] kvs;
        HashMap<String, String> ret = new HashMap<String, String>();
        if (query == null || (query = query.trim()).length() == 0) {
            return ret;
        }
        for (String kv : kvs = AND.split(query)) {
            Matcher matcher = EQUAL.matcher(kv);
            if (!matcher.matches()) continue;
            String key = matcher.group(1);
            String value = matcher.group(2);
            ret.put(key, value);
        }
        return ret;
    }

    public void edit(Long id, Map<String, Object> context) {
        Override override = this.overrideService.findById(id);
        Map parameters = Overrides.parseQueryString((String)override.getParams());
        if (parameters.get("mock") != null) {
            String mock = URL.decode((String)((String)parameters.get("mock")));
            String[] tokens = this.parseMock(mock);
            context.put("mockDefaultMethodForce", tokens[0]);
            context.put("mockDefaultMethodJson", tokens[1]);
            parameters.remove("mock");
        }
        LinkedHashMap method2Force = new LinkedHashMap();
        LinkedHashMap method2Json = new LinkedHashMap();
        List methods = CollectionUtils.sort(new ArrayList(this.providerService.findMethodsByService(override.getService())));
        if (methods != null && methods.isEmpty()) {
            for (String m : methods) {
                this.parseMock(m, (String)parameters.get(m + ".mock"), method2Force, method2Json);
                parameters.remove(m + ".mock");
            }
        }
        Iterator iterator = parameters.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry e = iterator.next();
            String key = (String)e.getKey();
            if (!key.endsWith(".mock")) continue;
            String m = key.substring(0, key.length() - ".mock".length());
            this.parseMock(m, (String)e.getValue(), method2Force, method2Json);
            iterator.remove();
        }
        context.put("methods", methods);
        context.put("methodForces", method2Force);
        context.put("methodJsons", method2Json);
        context.put("parameters", parameters);
        context.put("override", override);
    }

    private void parseMock(String m, String mock, Map<String, String> method2Force, Map<String, String> method2Json) {
        String[] tokens = this.parseMock(mock);
        method2Force.put(m, tokens[0]);
        method2Json.put(m, tokens[1]);
    }

    private String[] parseMock(String mock) {
        String force;
        if ((mock = URL.decode((String)mock)).startsWith("force:")) {
            force = "force";
            mock = mock.substring("force:".length());
        } else if (mock.startsWith("fail:")) {
            force = "fail";
            mock = mock.substring("fail:".length());
        } else {
            force = "fail";
        }
        String[] tokens = new String[]{force, mock};
        return tokens;
    }

    boolean catchParams(Override override, Map<String, Object> context) {
        String service = (String)context.get("service");
        if (service == null || service.trim().length() == 0) {
            context.put("message", this.getMessage("service is blank!", new Object[0]));
            return false;
        }
        if (!this.currentUser.hasServicePrivilege(service)) {
            context.put("message", this.getMessage("HaveNoServicePrivilege", new Object[]{service}));
            return false;
        }
        String defaultMockMethodForce = (String)context.get("mockDefaultMethodForce");
        String defaultMockMethodJson = (String)context.get("mockDefaultMethodJson");
        HashMap<String, String> override2Value = new HashMap<String, String>();
        HashMap<String, String> method2Json = new HashMap<String, String>();
        for (Map.Entry<String, Object> param : context.entrySet()) {
            String force;
            String index;
            String key = param.getKey().trim();
            if (!(param.getValue() instanceof String)) continue;
            String value = (String)param.getValue();
            if (key.startsWith("overrideKey") && value != null && value.trim().length() > 0) {
                index = key.substring("overrideKey".length());
                String overrideValue = (String)context.get("overrideValue" + index);
                if (overrideValue != null && overrideValue.trim().length() > 0) {
                    override2Value.put(value.trim(), overrideValue.trim());
                }
            }
            if (key.startsWith("mockMethod.") && value != null && value.trim().length() > 0) {
                String method = key.substring("mockMethod.".length());
                force = (String)context.get("mockMethodForce." + method);
                method2Json.put(method, force + ":" + value.trim());
            }
            if (!key.startsWith("mockMethodName") || value == null || value.trim().length() <= 0) continue;
            index = key.substring("mockMethodName".length());
            force = (String)context.get("mockMethodForce" + index);
            String json = (String)context.get("mockMethodJson" + index);
            if (json == null || json.trim().length() <= 0) continue;
            method2Json.put(value.trim(), force + ":" + json.trim());
        }
        StringBuilder paramters = new StringBuilder();
        boolean isFirst = true;
        if (defaultMockMethodJson != null && defaultMockMethodJson.trim().length() > 0) {
            paramters.append("mock=").append(URL.encode((String)(defaultMockMethodForce + ":" + defaultMockMethodJson.trim())));
            isFirst = false;
        }
        for (Map.Entry e : method2Json.entrySet()) {
            if (isFirst) {
                isFirst = false;
            } else {
                paramters.append("&");
            }
            paramters.append((String)e.getKey()).append(".mock").append("=").append(URL.encode((String)((String)e.getValue())));
        }
        for (Map.Entry e : override2Value.entrySet()) {
            if (isFirst) {
                isFirst = false;
            } else {
                paramters.append("&");
            }
            paramters.append((String)e.getKey()).append("=").append(URL.encode((String)((String)e.getValue())));
        }
        String p = paramters.toString();
        if (p.trim().length() == 0) {
            context.put("message", this.getMessage("Please enter Parameters!", new Object[0]));
            return false;
        }
        override.setParams(p);
        return true;
    }

    public boolean create(Override override, Map<String, Object> context) {
        if (!this.catchParams(override, context)) {
            return false;
        }
        this.overrideService.saveOverride(override);
        return true;
    }

    public boolean update(Override override, Map<String, Object> context) {
        Override o = this.overrideService.findById(override.getId());
        override.setService(o.getService());
        override.setAddress(o.getAddress());
        override.setApplication(o.getApplication());
        if (!this.catchParams(override, context)) {
            return false;
        }
        this.overrideService.updateOverride(override);
        return true;
    }

    public boolean delete(Long[] ids, Map<String, Object> context) {
        for (Long id : ids) {
            this.overrideService.deleteOverride(id);
        }
        return true;
    }

    public boolean enable(Long[] ids, Map<String, Object> context) {
        for (Long id : ids) {
            Override override = this.overrideService.findById(id);
            if (override == null) {
                context.put("message", this.getMessage("NoSuchOperationData", new Object[]{id}));
                return false;
            }
            if (this.currentUser.hasServicePrivilege(override.getService())) continue;
            context.put("message", this.getMessage("HaveNoServicePrivilege", new Object[]{override.getService()}));
            return false;
        }
        for (Long id : ids) {
            this.overrideService.enableOverride(id);
        }
        return true;
    }

    public boolean disable(Long[] ids, Map<String, Object> context) {
        for (Long id : ids) {
            Override override = this.overrideService.findById(id);
            if (override == null) {
                context.put("message", this.getMessage("NoSuchOperationData", new Object[]{id}));
                return false;
            }
            if (this.currentUser.hasServicePrivilege(override.getService())) continue;
            context.put("message", this.getMessage("HaveNoServicePrivilege", new Object[]{override.getService()}));
            return false;
        }
        for (Long id : ids) {
            this.overrideService.disableOverride(id);
        }
        return true;
    }
}

