/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dubbo.governance.web.sysinfo.module.screen;

import com.alibaba.dubbo.common.utils.StringUtils;
import com.alibaba.dubbo.governance.service.ConsumerService;
import com.alibaba.dubbo.governance.service.ProviderService;
import com.alibaba.dubbo.governance.web.common.module.screen.Restful;
import com.alibaba.dubbo.registry.common.domain.Consumer;
import com.alibaba.dubbo.registry.common.domain.Provider;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;

public class Dump
extends Restful {
    @Autowired
    ProviderService providerDAO;
    @Autowired
    ConsumerService consumerDAO;
    @Autowired
    HttpServletResponse response;

    public void noProviders(Map<String, Object> context) throws IOException {
        PrintWriter writer = this.response.getWriter();
        List sortedService = this.getNoProviders();
        Collections.sort(sortedService);
        writer.println(sortedService.size() + " services don't have provider");
        for (String noProvider : sortedService) {
            writer.println(noProvider);
        }
        writer.flush();
        this.response.setContentType("text/plain");
    }

    public void services(Map<String, Object> context) throws IOException {
        PrintWriter writer = this.response.getWriter();
        List sortedService = this.providerDAO.findServices();
        Collections.sort(sortedService);
        writer.println(sortedService.size() + " services");
        for (String service : sortedService) {
            writer.println(service + this.providerDAO.findByService(service).size());
        }
        writer.flush();
        this.response.setContentType("text/plain");
    }

    public void providers(Map<String, Object> context) throws IOException {
        PrintWriter writer = this.response.getWriter();
        List providers = this.providerDAO.findAll();
        ArrayList<String> sortedProviders = new ArrayList<String>();
        for (Provider provider : providers) {
            sortedProviders.add(provider.getUrl() + " " + provider.getService());
        }
        Collections.sort(sortedProviders);
        writer.println(sortedProviders.size() + " provider instance");
        for (String string : sortedProviders) {
            writer.println(string);
        }
        writer.flush();
        this.response.setContentType("text/plain");
    }

    public void consumers(Map<String, Object> context) throws IOException {
        PrintWriter writer = this.response.getWriter();
        List consumers = this.consumerDAO.findAll();
        ArrayList<String> sortedConsumerss = new ArrayList<String>();
        for (Consumer consumer : consumers) {
            sortedConsumerss.add(consumer.getAddress() + " " + consumer.getService());
        }
        Collections.sort(sortedConsumerss);
        writer.println(sortedConsumerss.size() + " consumer instance");
        for (String string : sortedConsumerss) {
            writer.println(string);
        }
        writer.flush();
        this.response.setContentType("text/plain");
    }

    public void versions(Map<String, Object> context) throws IOException {
        PrintWriter writer = this.response.getWriter();
        List providers = this.providerDAO.findAll();
        List consumers = this.consumerDAO.findAll();
        HashSet<String> parametersSet = new HashSet<String>();
        HashMap versions = new HashMap();
        for (Provider provider : providers) {
            parametersSet.add(provider.getParameters());
        }
        for (Consumer consumer : consumers) {
            parametersSet.add(consumer.getParameters());
        }
        Iterator temp = parametersSet.iterator();
        while (temp.hasNext()) {
            Map parameter = StringUtils.parseQueryString((String)((String)temp.next()));
            if (parameter == null) continue;
            String dubboversion = (String)parameter.get("dubbo");
            String app = (String)parameter.get("application");
            if (versions.get(dubboversion) == null) {
                HashSet apps = new HashSet();
                versions.put(dubboversion, apps);
            }
            ((Set)versions.get(dubboversion)).add(app);
        }
        for (String version : versions.keySet()) {
            writer.println("dubbo version: " + version);
            writer.println(StringUtils.join((Collection)((Collection)versions.get(version)), (String)"\n"));
            writer.println("\n");
        }
        context.put("versions", versions);
        writer.flush();
        this.response.setContentType("text/plain");
    }

    private List<String> getNoProviders() {
        List providerServices = this.providerDAO.findServices();
        List consumerServices = this.consumerDAO.findServices();
        ArrayList<String> noProviderServices = new ArrayList<String>();
        if (consumerServices != null) {
            noProviderServices.addAll(consumerServices);
            noProviderServices.removeAll(providerServices);
        }
        return noProviderServices;
    }
}

