/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dubbo.governance.web.sysinfo.module.screen;

import com.alibaba.dubbo.common.Version;
import com.alibaba.dubbo.common.utils.NetUtils;
import com.alibaba.dubbo.governance.web.common.module.screen.Restful;
import java.lang.management.ManagementFactory;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;

public class Envs
extends Restful {
    private static final long SECOND = 1000L;
    private static final long MINUTE = 60000L;
    private static final long HOUR = 3600000L;
    private static final long DAY = 86400000L;

    public void index(Map<String, Object> context) throws Exception {
        TreeMap<String, String> properties = new TreeMap<String, String>();
        StringBuilder msg = new StringBuilder();
        msg.append("Version: ");
        msg.append(Version.getVersion(Envs.class, (String)"2.2.0"));
        properties.put("Registry", msg.toString());
        String address = NetUtils.getLocalHost();
        properties.put("Host", NetUtils.getHostName((String)address) + "/" + address);
        properties.put("Java", System.getProperty("java.runtime.name") + " " + System.getProperty("java.runtime.version"));
        properties.put("OS", System.getProperty("os.name") + " " + System.getProperty("os.version"));
        properties.put("CPU", System.getProperty("os.arch", "") + ", " + String.valueOf(Runtime.getRuntime().availableProcessors()) + " cores");
        properties.put("Locale", Locale.getDefault().toString() + "/" + System.getProperty("file.encoding"));
        properties.put("Uptime", this.formatUptime(ManagementFactory.getRuntimeMXBean().getUptime()) + " From " + new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS Z").format(new Date(ManagementFactory.getRuntimeMXBean().getStartTime())) + " To " + new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS Z").format(new Date()));
        context.put("properties", properties);
    }

    private String formatUptime(long uptime) {
        StringBuilder buf = new StringBuilder();
        if (uptime > 86400000L) {
            long days = (uptime - uptime % 86400000L) / 86400000L;
            buf.append(days);
            buf.append(" Days");
            uptime %= 86400000L;
        }
        if (uptime > 3600000L) {
            long hours = (uptime - uptime % 3600000L) / 3600000L;
            if (buf.length() > 0) {
                buf.append(", ");
            }
            buf.append(hours);
            buf.append(" Hours");
            uptime %= 3600000L;
        }
        if (uptime > 60000L) {
            long minutes = (uptime - uptime % 60000L) / 60000L;
            if (buf.length() > 0) {
                buf.append(", ");
            }
            buf.append(minutes);
            buf.append(" Minutes");
            uptime %= 60000L;
        }
        if (uptime > 1000L) {
            long seconds = (uptime - uptime % 1000L) / 1000L;
            if (buf.length() > 0) {
                buf.append(", ");
            }
            buf.append(seconds);
            buf.append(" Seconds");
            uptime %= 1000L;
        }
        if (uptime > 0L) {
            if (buf.length() > 0) {
                buf.append(", ");
            }
            buf.append(uptime);
            buf.append(" Milliseconds");
        }
        return buf.toString();
    }
}

