/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dubbo.registry.common.util;

import com.alibaba.dubbo.common.URL;
import com.alibaba.dubbo.common.utils.NetUtils;
import com.alibaba.dubbo.common.utils.StringUtils;
import com.alibaba.dubbo.registry.common.util.StringEscapeUtils;
import java.lang.reflect.Array;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;

public class Tool {
    private static final Pattern IP_PATTERN = Pattern.compile("\\d{1,3}(\\.\\d{1,3}){3,5}$");
    private static final Comparator<String> SIMPLE_NAME_COMPARATOR = new /* Unavailable Anonymous Inner Class!! */;

    public static boolean startWith(String value, String prefix) {
        return value.startsWith(prefix);
    }

    public static boolean isContains(String[] values, String value) {
        return StringUtils.isContains((String[])values, (String)value);
    }

    public static boolean isValidAddress(String address) {
        return IP_PATTERN.matcher(address).matches();
    }

    public static String getHostName(String address) {
        String hostname;
        if (address != null && address.length() > 0 && !address.equals(hostname = NetUtils.getHostName((String)address))) {
            return hostname + "/";
        }
        return "";
    }

    public static String getIP(String address) {
        if (address != null && address.length() > 0) {
            int i = address.indexOf("://");
            if (i >= 0) {
                address = address.substring(i + 3);
            }
            if ((i = address.indexOf(47)) >= 0) {
                address = address.substring(0, i);
            }
            if ((i = address.indexOf(64)) >= 0) {
                address = address.substring(i + 1);
            }
            if ((i = address.indexOf(58)) >= 0) {
                address = address.substring(0, i);
            }
            if (address.matches("[a-zA-Z]+")) {
                try {
                    address = InetAddress.getByName(address).getHostAddress();
                }
                catch (UnknownHostException unknownHostException) {
                    // empty catch block
                }
            }
        }
        return address;
    }

    public static String encodeUrl(String url) {
        return URL.encode((String)url);
    }

    public static String decodeUrl(String url) {
        return URL.decode((String)url);
    }

    public static String encodeHtml(String html) {
        return StringEscapeUtils.escapeHtml((String)html);
    }

    public static String decodeHtml(String html) {
        return StringEscapeUtils.unescapeHtml((String)html);
    }

    public static int countMapValues(Map<?, ?> map) {
        int total = 0;
        if (map != null && map.size() > 0) {
            for (Object value : map.values()) {
                if (value == null) continue;
                if (value instanceof Number) {
                    total += ((Number)value).intValue();
                    continue;
                }
                if (value.getClass().isArray()) {
                    total += Array.getLength(value);
                    continue;
                }
                if (value instanceof Collection) {
                    total += ((Collection)value).size();
                    continue;
                }
                if (value instanceof Map) {
                    total += ((Map)value).size();
                    continue;
                }
                ++total;
            }
        }
        return total;
    }

    public static List<String> sortSimpleName(List<String> list) {
        if (list != null && list.size() > 0) {
            Collections.sort(list, SIMPLE_NAME_COMPARATOR);
        }
        return list;
    }

    public static String getSimpleName(String name) {
        if (name != null && name.length() > 0) {
            int j;
            int ip = name.indexOf(47);
            String v = ip != -1 ? name.substring(0, ip + 1) : "";
            int i = name.lastIndexOf(58);
            int n = j = i >= 0 ? name.lastIndexOf(46, i) : name.lastIndexOf(46);
            if (j >= 0) {
                name = name.substring(j + 1);
            }
            name = v + name;
        }
        return name;
    }
}

