/*
 * Decompiled with CFR 0.152.
 */
package com.edas.ext.web;

import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.Filter;
import javax.servlet.FilterRegistration;
import javax.servlet.ServletContainerInitializer;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;

public class EdasCommonFilterInitializer
implements ServletContainerInitializer {
    private final Logger logger = Logger.getLogger("edas-common-filter");

    public void onStartup(Set<Class<?>> c, ServletContext ctx) throws ServletException {
        Properties properties = EdasCommonFilterInitializer.loadEdasCommonFilter();
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            String filterClass = (String)entry.getValue();
            String filterName = (String)entry.getKey();
            if (filterClass == null || filterClass.trim().length() == 0) continue;
            try {
                Class<?> clazz = Class.forName(filterClass);
                if (!Filter.class.isAssignableFrom(clazz)) {
                    String logInfo = String.format("the calss for [%s] is not assignable from javax.servlet.Filter", clazz.getName());
                    this.logger.warning(logInfo);
                    continue;
                }
                this.logger.info("filter=" + filterName + "; filter class=" + filterClass);
                FilterRegistration.Dynamic filterDynamic = ctx.addFilter(filterName, filterClass);
                filterDynamic.addMappingForUrlPatterns(null, true, new String[]{"/*"});
            }
            catch (ClassNotFoundException e) {
                this.logger.log(Level.SEVERE, e.getMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Properties loadEdasCommonFilter() {
        Properties properties = new Properties();
        InputStream resource = null;
        try {
            resource = EdasCommonFilterInitializer.class.getClassLoader().getResourceAsStream("META-INF/EdasCommonFilter.properties");
            properties.load(resource);
        }
        catch (Exception e) {
        }
        finally {
            if (resource != null) {
                try {
                    resource.close();
                }
                catch (IOException e) {}
            }
        }
        return properties;
    }
}

