/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.spring.context.event.config;

import com.alibaba.nacos.api.config.ConfigService;
import com.alibaba.nacos.api.config.listener.Listener;
import com.alibaba.nacos.spring.context.event.config.NacosConfigReceivedEvent;
import java.util.concurrent.Executor;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;

final class DelegatingEventPublishingListener
implements Listener {
    private final ConfigService configService;
    private final String dataId;
    private final String groupId;
    private final ApplicationEventPublisher applicationEventPublisher;
    private final Executor executor;
    private final Listener delegate;

    DelegatingEventPublishingListener(ConfigService configService, String dataId, String groupId, ApplicationEventPublisher applicationEventPublisher, Executor executor, Listener delegate) {
        this.configService = configService;
        this.dataId = dataId;
        this.groupId = groupId;
        this.applicationEventPublisher = applicationEventPublisher;
        this.executor = executor;
        this.delegate = delegate;
    }

    public Executor getExecutor() {
        Executor executor = this.delegate.getExecutor();
        if (executor == null) {
            executor = this.executor;
        }
        return executor;
    }

    public void receiveConfigInfo(String content) {
        this.publishEvent(content);
        this.onReceived(content);
    }

    private void publishEvent(String content) {
        NacosConfigReceivedEvent event = new NacosConfigReceivedEvent(this.configService, this.dataId, this.groupId, content);
        this.applicationEventPublisher.publishEvent((ApplicationEvent)event);
    }

    private void onReceived(String content) {
        this.delegate.receiveConfigInfo(content);
    }
}

