/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.spring.util;

import com.alibaba.nacos.api.annotation.NacosProperties;
import com.alibaba.nacos.api.config.ConfigService;
import com.alibaba.nacos.api.exception.NacosException;
import com.alibaba.nacos.spring.util.PropertiesPlaceholderResolver;
import java.io.IOException;
import java.io.StringReader;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.LinkedList;
import java.util.Map;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.core.env.PropertyResolver;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;

public abstract class NacosUtils {
    public static final String DEFAULT_STRING_ATTRIBUTE_VALUE = "";
    public static final boolean DEFAULT_BOOLEAN_ATTRIBUTE_VALUE = false;
    public static final String SEPARATOR = "|";
    public static final long DEFAULT_TIMEOUT = Long.getLong("nacos.default.timeout", 5000L);
    private static final Logger logger = LoggerFactory.getLogger(NacosUtils.class);

    public static String buildDefaultPropertySourceName(String dataId, String groupId, Map<?, ?> properties) {
        return NacosUtils.build(dataId, groupId, NacosUtils.identify(properties));
    }

    public static String identify(NacosProperties nacosProperties) {
        return NacosUtils.identify(AnnotationUtils.getAnnotationAttributes((Annotation)nacosProperties));
    }

    public static String identify(Map<?, ?> properties) {
        String namespace = (String)properties.get("namespace");
        String serverAddress = (String)properties.get("serverAddr");
        String contextPath = (String)properties.get("contextPath");
        String clusterName = (String)properties.get("clusterName");
        String endpoint = (String)properties.get("endpoint");
        String accessKey = (String)properties.get("accessKey");
        String secretKey = (String)properties.get("secretKey");
        String encode = (String)properties.get("encode");
        return NacosUtils.build(namespace, clusterName, serverAddress, contextPath, endpoint, accessKey, secretKey, encode);
    }

    private static String build(Object ... values) {
        StringBuilder stringBuilder = new StringBuilder();
        for (Object value : values) {
            String stringValue;
            String string = stringValue = value == null ? null : String.valueOf(value);
            if (StringUtils.hasText((String)stringValue)) {
                stringBuilder.append(stringValue);
            }
            stringBuilder.append(SEPARATOR);
        }
        return stringBuilder.toString();
    }

    public static boolean isDefault(final NacosProperties nacosProperties) {
        final LinkedList records = new LinkedList();
        ReflectionUtils.doWithMethods((Class)nacosProperties.annotationType(), (ReflectionUtils.MethodCallback)new ReflectionUtils.MethodCallback(){

            public void doWith(Method method) throws IllegalArgumentException, IllegalAccessException {
                Object defaultValue;
                if (Modifier.isPublic(method.getModifiers()) && method.getParameterTypes().length == 0 && (defaultValue = method.getDefaultValue()) != null) {
                    try {
                        Object returnValue = method.invoke((Object)nacosProperties, new Object[0]);
                        if (!defaultValue.equals(returnValue)) {
                            records.add(returnValue);
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        });
        return records.isEmpty();
    }

    public static Properties resolveProperties(NacosProperties nacosProperties, PropertyResolver propertyResolver) {
        return NacosUtils.resolveProperties(nacosProperties, propertyResolver, null);
    }

    public static Properties resolveProperties(NacosProperties nacosProperties, PropertyResolver propertyResolver, Properties defaultProperties) {
        Map attributes = AnnotationUtils.getAnnotationAttributes((Annotation)nacosProperties);
        return NacosUtils.resolveProperties(attributes, propertyResolver, defaultProperties);
    }

    public static Properties resolveProperties(Map<String, Object> attributes, PropertyResolver propertyResolver, Properties defaultProperties) {
        if (CollectionUtils.isEmpty(attributes)) {
            return defaultProperties;
        }
        Properties resolveProperties = NacosUtils.resolveProperties(attributes, propertyResolver);
        NacosUtils.merge(resolveProperties, defaultProperties);
        return resolveProperties;
    }

    public static Properties resolveProperties(Map<?, ?> properties, PropertyResolver propertyResolver) {
        PropertiesPlaceholderResolver propertiesPlaceholderResolver = new PropertiesPlaceholderResolver(propertyResolver);
        return propertiesPlaceholderResolver.resolve(properties);
    }

    protected static void merge(Properties targetProperties, Properties sourceProperties) {
        if (CollectionUtils.isEmpty((Map)sourceProperties)) {
            return;
        }
        for (Map.Entry<Object, Object> entry : sourceProperties.entrySet()) {
            String propertyName = (String)entry.getKey();
            if (targetProperties.containsKey(propertyName)) continue;
            String propertyValue = (String)entry.getValue();
            targetProperties.setProperty(propertyName, propertyValue);
        }
    }

    public static String getContent(ConfigService configService, String dataId, String groupId) {
        String content;
        block2: {
            content = null;
            try {
                content = configService.getConfig(dataId, groupId, DEFAULT_TIMEOUT);
            }
            catch (NacosException e) {
                if (!logger.isErrorEnabled()) break block2;
                logger.error("Can't get content from dataId : " + dataId + " , groupId : " + groupId, (Throwable)e);
            }
        }
        return content;
    }

    public static <T> Class<T> resolveGenericType(Class<?> declaredClass) {
        ParameterizedType parameterizedType = (ParameterizedType)declaredClass.getGenericSuperclass();
        Type[] actualTypeArguments = parameterizedType.getActualTypeArguments();
        return (Class)actualTypeArguments[0];
    }

    public static Properties toProperties(String text) {
        Properties properties;
        block3: {
            properties = new Properties();
            try {
                if (StringUtils.hasText((String)text)) {
                    properties.load(new StringReader(text));
                }
            }
            catch (IOException e) {
                if (!logger.isErrorEnabled()) break block3;
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
        return properties;
    }
}

