/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dubbo.spring.boot;

import com.alibaba.dubbo.config.ApplicationConfig;
import com.alibaba.dubbo.config.MonitorConfig;
import com.alibaba.dubbo.config.RegistryConfig;
import com.alibaba.dubbo.config.annotation.Reference;
import com.alibaba.dubbo.config.annotation.Service;
import com.alibaba.dubbo.config.spring.ReferenceBean;
import com.alibaba.dubbo.spring.boot.DubboAutoConfiguration;
import com.alibaba.dubbo.spring.boot.DubboProperties;
import com.alibaba.dubbo.spring.boot.annotation.EnableDubboConfiguration;
import com.alibaba.dubbo.spring.boot.domain.ClassIdBean;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.aop.support.AopUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnClass(value={Service.class})
@ConditionalOnBean(annotation={EnableDubboConfiguration.class})
@AutoConfigureAfter(value={DubboAutoConfiguration.class})
@EnableConfigurationProperties(value={DubboProperties.class})
public class DubboConsumerAutoConfiguration {
    private static final Map<ClassIdBean, Object> DUBBO_REFERENCES_MAP = new ConcurrentHashMap<ClassIdBean, Object>();
    @Autowired
    private ApplicationContext applicationContext;
    @Autowired
    private DubboProperties properties;
    @Autowired
    private ApplicationConfig applicationConfig;
    @Autowired(required=false)
    private RegistryConfig registryConfig;
    @Autowired(required=false)
    private MonitorConfig monitorConfig;

    public static Object getDubboReference(ClassIdBean classIdBean) {
        return DUBBO_REFERENCES_MAP.get(classIdBean);
    }

    @Bean
    public BeanPostProcessor beanPostProcessor() {
        return new BeanPostProcessor(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
                Class objClz = bean.getClass();
                if (AopUtils.isAopProxy((Object)bean)) {
                    objClz = AopUtils.getTargetClass((Object)bean);
                }
                try {
                    for (Field field : objClz.getDeclaredFields()) {
                        Reference reference = field.getAnnotation(Reference.class);
                        if (reference == null) continue;
                        ReferenceBean referenceBean = DubboConsumerAutoConfiguration.this.getConsumerBean(field.getType(), reference);
                        Class interfaceClass = referenceBean.getInterfaceClass();
                        String group = referenceBean.getGroup();
                        String version = referenceBean.getVersion();
                        ClassIdBean classIdBean = new ClassIdBean(interfaceClass, group, version);
                        Object dubboReference = DUBBO_REFERENCES_MAP.get(classIdBean);
                        if (dubboReference == null) {
                            1 var15_16 = this;
                            synchronized (var15_16) {
                                dubboReference = DUBBO_REFERENCES_MAP.get(classIdBean);
                                if (dubboReference == null) {
                                    referenceBean.afterPropertiesSet();
                                    dubboReference = referenceBean.getObject();
                                    DUBBO_REFERENCES_MAP.put(classIdBean, dubboReference);
                                }
                            }
                        }
                        field.setAccessible(true);
                        field.set(bean, dubboReference);
                    }
                }
                catch (Exception e) {
                    throw new BeanCreationException(beanName, (Throwable)e);
                }
                return bean;
            }

            public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
                return bean;
            }
        };
    }

    private <T> ReferenceBean<T> getConsumerBean(Class<T> interfaceClazz, Reference reference) throws BeansException {
        String[] registrys;
        String group;
        String version;
        ReferenceBean referenceBean = new ReferenceBean(reference);
        if (!(reference.interfaceClass() != null && reference.interfaceClass() != Void.TYPE || reference.interfaceName() != null && !"".equals(reference.interfaceName()))) {
            referenceBean.setInterface(interfaceClazz);
        }
        if (((version = reference.version()) == null || "".equals(version)) && (version = this.properties.getVersion()) != null && !"".equals(version)) {
            referenceBean.setVersion(version);
        }
        if (((group = reference.group()) == null || "".equals(group)) && (group = this.properties.getGroup()) != null && !"".equals(group)) {
            referenceBean.setGroup(group);
        }
        if ((registrys = reference.registry()) != null && registrys.length > 0) {
            ArrayList<RegistryConfig> registrieList = new ArrayList<RegistryConfig>();
            for (String registry : registrys) {
                RegistryConfig registryConfig = new RegistryConfig();
                registryConfig.setAddress(registry);
                registrieList.add(registryConfig);
            }
            referenceBean.setRegistries(registrieList);
        } else {
            referenceBean.setRegistry(this.registryConfig);
        }
        if (this.monitorConfig != null) {
            referenceBean.setMonitor(this.monitorConfig);
        }
        referenceBean.setApplicationContext(this.applicationContext);
        referenceBean.setApplication(this.applicationConfig);
        return referenceBean;
    }
}

