/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.ttl.threadpool;

import com.alibaba.ttl.threadpool.ExecutorServiceTtlWrapper;
import com.alibaba.ttl.threadpool.ExecutorTtlWrapper;
import com.alibaba.ttl.threadpool.ScheduledExecutorServiceTtlWrapper;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import javax.annotation.Nullable;

public final class TtlExecutors {
    @Nullable
    public static Executor getTtlExecutor(@Nullable Executor executor) {
        if (null == executor || executor instanceof ExecutorTtlWrapper) {
            return executor;
        }
        return new ExecutorTtlWrapper(executor);
    }

    @Nullable
    public static ExecutorService getTtlExecutorService(@Nullable ExecutorService executorService) {
        if (executorService == null || executorService instanceof ExecutorServiceTtlWrapper) {
            return executorService;
        }
        return new ExecutorServiceTtlWrapper(executorService);
    }

    @Nullable
    public static ScheduledExecutorService getTtlScheduledExecutorService(@Nullable ScheduledExecutorService scheduledExecutorService) {
        if (scheduledExecutorService == null || scheduledExecutorService instanceof ScheduledExecutorServiceTtlWrapper) {
            return scheduledExecutorService;
        }
        return new ScheduledExecutorServiceTtlWrapper(scheduledExecutorService);
    }

    public static <T extends Executor> boolean isTtlWrapper(@Nullable T executor) {
        return executor instanceof ExecutorTtlWrapper;
    }

    @Nullable
    public static <T extends Executor> T unwrap(@Nullable T executor) {
        if (!TtlExecutors.isTtlWrapper(executor)) {
            return executor;
        }
        return (T)((ExecutorTtlWrapper)executor).unwrap();
    }

    private TtlExecutors() {
    }
}

