/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.ttl.threadpool.agent;

import com.alibaba.ttl.threadpool.agent.TtlTransformer;
import com.alibaba.ttl.threadpool.agent.internal.logging.Logger;
import com.alibaba.ttl.threadpool.agent.internal.transformlet.JavassistTransformlet;
import com.alibaba.ttl.threadpool.agent.internal.transformlet.impl.TtlExecutorTransformlet;
import com.alibaba.ttl.threadpool.agent.internal.transformlet.impl.TtlForkJoinTransformlet;
import com.alibaba.ttl.threadpool.agent.internal.transformlet.impl.TtlTimerTaskTransformlet;
import java.lang.instrument.Instrumentation;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class TtlAgent {
    private static final String TTL_AGENT_ENABLE_TIMER_TASK_KEY = "ttl.agent.enable.timer.task";

    private TtlAgent() {
        throw new InstantiationError("Must not instantiate this class");
    }

    public static void premain(String agentArgs, @Nonnull Instrumentation inst) {
        Map<String, String> kvs = TtlAgent.splitCommaColonStringToKV(agentArgs);
        Logger.setLoggerImplType(TtlAgent.getLogImplTypeFromAgentArgs(kvs));
        Logger logger = Logger.getLogger(TtlAgent.class);
        try {
            logger.info("[TtlAgent.premain] begin, agentArgs: " + agentArgs + ", Instrumentation: " + inst);
            ArrayList<Class<? extends JavassistTransformlet>> transformletList = new ArrayList<Class<? extends JavassistTransformlet>>();
            transformletList.add(TtlExecutorTransformlet.class);
            transformletList.add(TtlForkJoinTransformlet.class);
            if (TtlAgent.enableTimerTask(kvs)) {
                transformletList.add(TtlTimerTaskTransformlet.class);
            }
            TtlTransformer transformer = new TtlTransformer(transformletList);
            inst.addTransformer(transformer, true);
            logger.info("[TtlAgent.premain] addTransformer " + transformer.getClass() + " success");
            logger.info("[TtlAgent.premain] end");
        }
        catch (Exception e) {
            String msg = "Fail to load TtlAgent , cause: " + e.toString();
            logger.log(Level.SEVERE, msg, e);
            throw new IllegalStateException(msg, e);
        }
    }

    private static String getLogImplTypeFromAgentArgs(@Nonnull Map<String, String> kvs) {
        return kvs.get("ttl.agent.logger");
    }

    private static boolean enableTimerTask(@Nonnull Map<String, String> kvs) {
        boolean hasEnableKey = kvs.containsKey(TTL_AGENT_ENABLE_TIMER_TASK_KEY);
        if (!hasEnableKey) {
            return false;
        }
        return !"false".equalsIgnoreCase(kvs.get(TTL_AGENT_ENABLE_TIMER_TASK_KEY));
    }

    @Nonnull
    static Map<String, String> splitCommaColonStringToKV(@Nullable String commaColonString) {
        String[] splitKvArray;
        HashMap<String, String> ret = new HashMap<String, String>();
        if (commaColonString == null || commaColonString.trim().length() == 0) {
            return ret;
        }
        for (String kvString : splitKvArray = commaColonString.trim().split("\\s*,\\s*")) {
            String[] kv = kvString.trim().split("\\s*:\\s*");
            if (kv.length == 0) continue;
            if (kv.length == 1) {
                ret.put(kv[0], "");
                continue;
            }
            ret.put(kv[0], kv[1]);
        }
        return ret;
    }
}

