/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.ttl.threadpool.agent.internal.transformlet.impl;

import com.alibaba.ttl.internal.javassist.CannotCompileException;
import com.alibaba.ttl.internal.javassist.CtClass;
import com.alibaba.ttl.internal.javassist.CtField;
import com.alibaba.ttl.internal.javassist.CtMethod;
import com.alibaba.ttl.internal.javassist.CtNewMethod;
import com.alibaba.ttl.internal.javassist.NotFoundException;
import com.alibaba.ttl.threadpool.agent.internal.logging.Logger;
import com.alibaba.ttl.threadpool.agent.internal.transformlet.JavassistTransformlet;
import com.alibaba.ttl.threadpool.agent.internal.transformlet.impl.Utils;
import java.io.IOException;

public class TtlForkJoinTransformlet
implements JavassistTransformlet {
    private static final Logger logger = Logger.getLogger(TtlForkJoinTransformlet.class);
    private static final String FORK_JOIN_TASK_CLASS_NAME = "java.util.concurrent.ForkJoinTask";
    private static final String TTL_RECURSIVE_ACTION_CLASS_NAME = "com.alibaba.ttl.TtlRecursiveAction";
    private static final String TTL_RECURSIVE_TASK_CLASS_NAME = "com.alibaba.ttl.TtlRecursiveTask";

    @Override
    public byte[] doTransform(String className, byte[] classFileBuffer, ClassLoader loader) throws IOException, NotFoundException, CannotCompileException {
        if (FORK_JOIN_TASK_CLASS_NAME.equals(className)) {
            CtClass clazz = Utils.getCtClass(classFileBuffer, loader);
            this.updateForkJoinTaskClass(clazz);
            return clazz.toBytecode();
        }
        return null;
    }

    private void updateForkJoinTaskClass(CtClass clazz) throws CannotCompileException, NotFoundException {
        String className = clazz.getName();
        String capturedFieldName = "captured$field$add$by$ttl";
        CtField capturedField = CtField.make("private final Object captured$field$add$by$ttl;", clazz);
        clazz.addField(capturedField, "com.alibaba.ttl.TransmittableThreadLocal.Transmitter.capture();");
        logger.info("add new field captured$field$add$by$ttl to class " + className);
        String doExec_methodName = "doExec";
        CtMethod doExecMethod = clazz.getDeclaredMethod("doExec", new CtClass[0]);
        CtMethod new_doExecMethod = CtNewMethod.copy(doExecMethod, "doExec", clazz, null);
        String original_doExec_method_rename = "original$doExec$method$renamed$by$ttl";
        doExecMethod.setName("original$doExec$method$renamed$by$ttl");
        doExecMethod.setModifiers(doExecMethod.getModifiers() & 0xFFFFFFFE | 2);
        String code = "{\nif (this instanceof com.alibaba.ttl.TtlRecursiveAction || this instanceof com.alibaba.ttl.TtlRecursiveTask) {\n    return original$doExec$method$renamed$by$ttl($$);\n}\nObject backup = com.alibaba.ttl.TransmittableThreadLocal.Transmitter.replay(captured$field$add$by$ttl);\ntry {\n    return original$doExec$method$renamed$by$ttl($$);\n} finally {\n    com.alibaba.ttl.TransmittableThreadLocal.Transmitter.restore(backup);\n}\n}";
        new_doExecMethod.setBody("{\nif (this instanceof com.alibaba.ttl.TtlRecursiveAction || this instanceof com.alibaba.ttl.TtlRecursiveTask) {\n    return original$doExec$method$renamed$by$ttl($$);\n}\nObject backup = com.alibaba.ttl.TransmittableThreadLocal.Transmitter.replay(captured$field$add$by$ttl);\ntry {\n    return original$doExec$method$renamed$by$ttl($$);\n} finally {\n    com.alibaba.ttl.TransmittableThreadLocal.Transmitter.restore(backup);\n}\n}");
        clazz.addMethod(new_doExecMethod);
        logger.info("insert code around method " + Utils.signatureOfMethod(doExecMethod) + " of class " + className + ": " + "{\nif (this instanceof com.alibaba.ttl.TtlRecursiveAction || this instanceof com.alibaba.ttl.TtlRecursiveTask) {\n    return original$doExec$method$renamed$by$ttl($$);\n}\nObject backup = com.alibaba.ttl.TransmittableThreadLocal.Transmitter.replay(captured$field$add$by$ttl);\ntry {\n    return original$doExec$method$renamed$by$ttl($$);\n} finally {\n    com.alibaba.ttl.TransmittableThreadLocal.Transmitter.restore(backup);\n}\n}");
    }
}

