/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.ttl.threadpool.agent.internal.transformlet.impl;

import com.alibaba.ttl.internal.javassist.CannotCompileException;
import com.alibaba.ttl.internal.javassist.CtClass;
import com.alibaba.ttl.internal.javassist.CtField;
import com.alibaba.ttl.internal.javassist.CtMethod;
import com.alibaba.ttl.internal.javassist.CtNewMethod;
import com.alibaba.ttl.internal.javassist.NotFoundException;
import com.alibaba.ttl.threadpool.agent.internal.logging.Logger;
import com.alibaba.ttl.threadpool.agent.internal.transformlet.JavassistTransformlet;
import com.alibaba.ttl.threadpool.agent.internal.transformlet.impl.Utils;
import java.io.IOException;

public class TtlTimerTaskTransformlet
implements JavassistTransformlet {
    private static final Logger logger = Logger.getLogger(TtlTimerTaskTransformlet.class);
    private static final String TIMER_TASK_CLASS_NAME = "java.util.TimerTask";
    private static final String RUN_METHOD_NAME = "run";

    @Override
    public byte[] doTransform(String className, byte[] classFileBuffer, ClassLoader loader) throws IOException, NotFoundException, CannotCompileException {
        if (TIMER_TASK_CLASS_NAME.equals(className)) {
            return null;
        }
        CtClass clazz = Utils.getCtClass(classFileBuffer, loader);
        if (clazz.isPrimitive() || clazz.isArray() || clazz.isInterface() || clazz.isAnnotation()) {
            return null;
        }
        try {
            CtMethod runMethod = clazz.getDeclaredMethod(RUN_METHOD_NAME, new CtClass[0]);
            if (!CtClass.voidType.equals(runMethod.getReturnType())) {
                return null;
            }
        }
        catch (NotFoundException e) {
            return null;
        }
        if (!clazz.subclassOf(clazz.getClassPool().get(TIMER_TASK_CLASS_NAME))) {
            return null;
        }
        logger.info("Transforming class " + className);
        this.updateTimerTaskClass(clazz);
        return clazz.toBytecode();
    }

    private void updateTimerTaskClass(CtClass clazz) throws CannotCompileException, NotFoundException {
        String className = clazz.getName();
        String capturedFieldName = "captured$field$add$by$ttl";
        CtField capturedField = CtField.make("private final Object captured$field$add$by$ttl;", clazz);
        clazz.addField(capturedField, "com.alibaba.ttl.TransmittableThreadLocal.Transmitter.capture();");
        logger.info("add new field captured$field$add$by$ttl to class " + className);
        CtMethod runMethod = clazz.getDeclaredMethod(RUN_METHOD_NAME, new CtClass[0]);
        CtMethod new_runMethod = CtNewMethod.copy(runMethod, RUN_METHOD_NAME, clazz, null);
        String original_run_method_rename = "original$run$method$renamed$by$ttl";
        runMethod.setName("original$run$method$renamed$by$ttl");
        runMethod.setModifiers(runMethod.getModifiers() & 0xFFFFFFFE | 2);
        String code = "{\nObject backup = com.alibaba.ttl.TransmittableThreadLocal.Transmitter.replay(captured$field$add$by$ttl);\ntry {\n    return original$run$method$renamed$by$ttl($$);\n} finally {\n    com.alibaba.ttl.TransmittableThreadLocal.Transmitter.restore(backup);\n}\n}";
        new_runMethod.setBody("{\nObject backup = com.alibaba.ttl.TransmittableThreadLocal.Transmitter.replay(captured$field$add$by$ttl);\ntry {\n    return original$run$method$renamed$by$ttl($$);\n} finally {\n    com.alibaba.ttl.TransmittableThreadLocal.Transmitter.restore(backup);\n}\n}");
        clazz.addMethod(new_runMethod);
        logger.info("insert code around method " + Utils.signatureOfMethod(runMethod) + " of class " + className + ": " + "{\nObject backup = com.alibaba.ttl.TransmittableThreadLocal.Transmitter.replay(captured$field$add$by$ttl);\ntry {\n    return original$run$method$renamed$by$ttl($$);\n} finally {\n    com.alibaba.ttl.TransmittableThreadLocal.Transmitter.restore(backup);\n}\n}");
    }
}

