/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.rpc.client;

import com.alipay.sofa.rpc.base.Destroyable;
import com.alipay.sofa.rpc.bootstrap.ConsumerBootstrap;
import com.alipay.sofa.rpc.client.AddressHolder;
import com.alipay.sofa.rpc.client.AddressHolderFactory;
import com.alipay.sofa.rpc.client.Cluster;
import com.alipay.sofa.rpc.client.ConnectionHolder;
import com.alipay.sofa.rpc.client.ConnectionHolderFactory;
import com.alipay.sofa.rpc.client.LoadBalancer;
import com.alipay.sofa.rpc.client.LoadBalancerFactory;
import com.alipay.sofa.rpc.client.ProviderGroup;
import com.alipay.sofa.rpc.client.ProviderHelper;
import com.alipay.sofa.rpc.client.ProviderInfo;
import com.alipay.sofa.rpc.client.RouterChain;
import com.alipay.sofa.rpc.common.RpcConfigs;
import com.alipay.sofa.rpc.common.utils.ClassUtils;
import com.alipay.sofa.rpc.common.utils.CommonUtils;
import com.alipay.sofa.rpc.common.utils.StringUtils;
import com.alipay.sofa.rpc.config.ConsumerConfig;
import com.alipay.sofa.rpc.context.AsyncRuntime;
import com.alipay.sofa.rpc.context.RpcInternalContext;
import com.alipay.sofa.rpc.context.RpcRuntimeContext;
import com.alipay.sofa.rpc.core.exception.SofaRouteException;
import com.alipay.sofa.rpc.core.exception.SofaRpcException;
import com.alipay.sofa.rpc.core.exception.SofaRpcRuntimeException;
import com.alipay.sofa.rpc.core.invoke.SofaResponseCallback;
import com.alipay.sofa.rpc.core.request.SofaRequest;
import com.alipay.sofa.rpc.core.response.SofaResponse;
import com.alipay.sofa.rpc.event.EventBus;
import com.alipay.sofa.rpc.event.ProviderInfoAddEvent;
import com.alipay.sofa.rpc.event.ProviderInfoRemoveEvent;
import com.alipay.sofa.rpc.event.ProviderInfoUpdateAllEvent;
import com.alipay.sofa.rpc.event.ProviderInfoUpdateEvent;
import com.alipay.sofa.rpc.filter.ConsumerInvoker;
import com.alipay.sofa.rpc.filter.FilterChain;
import com.alipay.sofa.rpc.listener.ConsumerStateListener;
import com.alipay.sofa.rpc.log.LogCodes;
import com.alipay.sofa.rpc.log.Logger;
import com.alipay.sofa.rpc.log.LoggerFactory;
import com.alipay.sofa.rpc.message.ResponseFuture;
import com.alipay.sofa.rpc.transport.ClientTransport;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;

public abstract class AbstractCluster
extends Cluster {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractCluster.class);
    protected volatile boolean initialized = false;
    protected volatile boolean destroyed = false;
    protected AtomicInteger countOfInvoke = new AtomicInteger(0);
    protected RouterChain routerChain;
    protected LoadBalancer loadBalancer;
    protected AddressHolder addressHolder;
    protected ConnectionHolder connectionHolder;
    protected FilterChain filterChain;
    private volatile ProviderInfo lastProviderInfo;

    public AbstractCluster(ConsumerBootstrap consumerBootstrap) {
        super(consumerBootstrap);
    }

    @Override
    public synchronized void init() {
        if (this.initialized) {
            return;
        }
        this.routerChain = RouterChain.buildConsumerChain(this.consumerBootstrap);
        this.loadBalancer = LoadBalancerFactory.getLoadBalancer(this.consumerBootstrap);
        this.addressHolder = AddressHolderFactory.getAddressHolder(this.consumerBootstrap);
        this.connectionHolder = ConnectionHolderFactory.getConnectionHolder(this.consumerBootstrap);
        this.filterChain = FilterChain.buildConsumerChain(this.consumerConfig, new ConsumerInvoker(this.consumerBootstrap));
        if (this.consumerConfig.isLazy() && LOGGER.isInfoEnabled(this.consumerConfig.getAppName())) {
            LOGGER.infoWithApp(this.consumerConfig.getAppName(), "Connection will be initialized when first invoke.");
        }
        this.connectionHolder.init();
        try {
            List<ProviderGroup> all = this.consumerBootstrap.subscribe();
            if (CommonUtils.isNotEmpty(all)) {
                this.updateAllProviders(all);
            }
        }
        catch (SofaRpcRuntimeException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new SofaRpcRuntimeException("Init provider's transport error!", e);
        }
        this.initialized = true;
        if (this.consumerConfig.isCheck() && !this.isAvailable()) {
            throw new SofaRpcRuntimeException("The consumer is depend on alive provider and there is no alive provider, you can ignore it by ConsumerConfig.setCheck(boolean) (default is false)");
        }
    }

    protected void checkClusterState() {
        if (this.destroyed) {
            throw new SofaRpcRuntimeException("Client has been destroyed!");
        }
        if (!this.initialized) {
            this.init();
        }
    }

    @Override
    public void addProvider(ProviderGroup providerGroup) {
        this.addressHolder.addProvider(providerGroup);
        this.connectionHolder.addProvider(providerGroup);
        if (EventBus.isEnable(ProviderInfoAddEvent.class)) {
            ProviderInfoAddEvent event = new ProviderInfoAddEvent(this.consumerConfig, providerGroup);
            EventBus.post(event);
        }
    }

    @Override
    public void removeProvider(ProviderGroup providerGroup) {
        this.addressHolder.removeProvider(providerGroup);
        this.connectionHolder.removeProvider(providerGroup);
        if (EventBus.isEnable(ProviderInfoRemoveEvent.class)) {
            ProviderInfoRemoveEvent event = new ProviderInfoRemoveEvent(this.consumerConfig, providerGroup);
            EventBus.post(event);
        }
    }

    @Override
    public void updateProviders(ProviderGroup providerGroup) {
        this.checkProviderInfo(providerGroup);
        ProviderGroup oldProviderGroup = this.addressHolder.getProviderGroup(providerGroup.getName());
        if (ProviderHelper.isEmpty(providerGroup)) {
            this.addressHolder.updateProviders(providerGroup);
            if (!ProviderHelper.isEmpty(oldProviderGroup) && LOGGER.isWarnEnabled(this.consumerConfig.getAppName())) {
                LOGGER.warnWithApp(this.consumerConfig.getAppName(), "Provider list is emptied, may be all providers has been closed, or this consumer has been add to blacklist");
                this.closeTransports();
            }
        } else {
            this.addressHolder.updateProviders(providerGroup);
            this.connectionHolder.updateProviders(providerGroup);
        }
        if (EventBus.isEnable(ProviderInfoUpdateEvent.class)) {
            ProviderInfoUpdateEvent event = new ProviderInfoUpdateEvent(this.consumerConfig, oldProviderGroup, providerGroup);
            EventBus.post(event);
        }
    }

    @Override
    public void updateAllProviders(List<ProviderGroup> providerGroups) {
        ArrayList<ProviderGroup> oldProviderGroups = new ArrayList<ProviderGroup>(this.addressHolder.getProviderGroups());
        int count = 0;
        if (providerGroups != null) {
            for (ProviderGroup providerGroup : providerGroups) {
                this.checkProviderInfo(providerGroup);
                count += providerGroup.size();
            }
        }
        if (count == 0) {
            Collection<ProviderInfo> currentProviderList = this.currentProviderList();
            this.addressHolder.updateAllProviders(providerGroups);
            if (CommonUtils.isNotEmpty(currentProviderList) && LOGGER.isWarnEnabled(this.consumerConfig.getAppName())) {
                LOGGER.warnWithApp(this.consumerConfig.getAppName(), "Provider list is emptied, may be all providers has been closed, or this consumer has been add to blacklist");
                this.closeTransports();
            }
        } else {
            this.addressHolder.updateAllProviders(providerGroups);
            this.connectionHolder.updateAllProviders(providerGroups);
        }
        if (EventBus.isEnable(ProviderInfoUpdateAllEvent.class)) {
            ProviderInfoUpdateAllEvent event = new ProviderInfoUpdateAllEvent(this.consumerConfig, oldProviderGroups, providerGroups);
            EventBus.post(event);
        }
    }

    protected void checkProviderInfo(ProviderGroup providerGroup) {
        List<ProviderInfo> providerInfos;
        List<ProviderInfo> list = providerInfos = providerGroup == null ? null : providerGroup.getProviderInfos();
        if (CommonUtils.isEmpty(providerInfos)) {
            return;
        }
        for (ProviderInfo providerInfo : providerInfos) {
            if (StringUtils.equals(providerInfo.getProtocolType(), this.consumerConfig.getProtocol()) || !LOGGER.isWarnEnabled(this.consumerConfig.getAppName())) continue;
            LOGGER.warnWithApp(this.consumerConfig.getAppName(), "Unmatched protocol between consumer [{}] and provider [{}].", this.consumerConfig.getProtocol(), providerInfo.getProtocolType());
        }
    }

    @Override
    public SofaResponse invoke(SofaRequest request) throws SofaRpcException {
        SofaResponse response = null;
        try {
            this.checkClusterState();
            this.countOfInvoke.incrementAndGet();
            SofaResponse sofaResponse = response = this.doInvoke(request);
            return sofaResponse;
        }
        catch (SofaRpcException e) {
            throw e;
        }
        finally {
            this.countOfInvoke.decrementAndGet();
        }
    }

    protected abstract SofaResponse doInvoke(SofaRequest var1) throws SofaRpcException;

    protected void checkProviderVersion(ProviderInfo providerInfo, SofaRequest request) {
    }

    protected ProviderInfo select(SofaRequest message) throws SofaRpcException {
        return this.select(message, null);
    }

    protected ProviderInfo select(SofaRequest message, List<ProviderInfo> invokedProviderInfos) throws SofaRpcException {
        ProviderInfo providerInfo;
        ClientTransport lastTransport;
        if (this.consumerConfig.isSticky() && this.lastProviderInfo != null && (lastTransport = this.connectionHolder.getAvailableClientTransport(providerInfo = this.lastProviderInfo)) != null && lastTransport.isAvailable()) {
            this.checkAlias(providerInfo, message);
            return providerInfo;
        }
        List<ProviderInfo> providerInfos = this.routerChain.route(message, null);
        ArrayList<ProviderInfo> orginalProviderInfos = new ArrayList<ProviderInfo>(providerInfos);
        if (CommonUtils.isEmpty(providerInfos)) {
            throw this.noAvailableProviderException(message.getTargetServiceUniqueName());
        }
        if (CommonUtils.isNotEmpty(invokedProviderInfos) && providerInfos.size() > invokedProviderInfos.size()) {
            providerInfos.removeAll(invokedProviderInfos);
        }
        String targetIP = null;
        RpcInternalContext context = RpcInternalContext.peekContext();
        if (context != null) {
            targetIP = (String)RpcInternalContext.getContext().getAttachment(".pinpoint");
        }
        if (StringUtils.isNotBlank(targetIP)) {
            ProviderInfo providerInfo2 = this.selectPinpointProvider(targetIP, providerInfos);
            if (providerInfo2 == null) {
                throw this.unavailableProviderException(message.getTargetServiceUniqueName(), targetIP);
            }
            ClientTransport clientTransport = this.selectByProvider(message, providerInfo2);
            if (clientTransport == null) {
                throw this.unavailableProviderException(message.getTargetServiceUniqueName(), targetIP);
            }
            return providerInfo2;
        }
        do {
            ProviderInfo providerInfo3;
            ClientTransport transport;
            if ((transport = this.selectByProvider(message, providerInfo3 = this.loadBalancer.select(message, providerInfos))) != null) {
                return providerInfo3;
            }
            providerInfos.remove(providerInfo3);
        } while (!providerInfos.isEmpty());
        throw this.unavailableProviderException(message.getTargetServiceUniqueName(), this.convertProviders2Urls(orginalProviderInfos));
    }

    protected ProviderInfo selectPinpointProvider(String targetIP, List<ProviderInfo> providerInfos) {
        ProviderInfo tp = ProviderHelper.toProviderInfo(targetIP);
        for (ProviderInfo providerInfo : providerInfos) {
            if (!providerInfo.getHost().equals(tp.getHost()) || !StringUtils.equals(providerInfo.getProtocolType(), tp.getProtocolType()) || providerInfo.getPort() != tp.getPort()) continue;
            return providerInfo;
        }
        return null;
    }

    protected SofaRouteException noAvailableProviderException(String serviceKey) {
        return new SofaRouteException(LogCodes.getLog("02306", serviceKey));
    }

    protected SofaRouteException unavailableProviderException(String serviceKey, String providerInfo) {
        return new SofaRouteException(LogCodes.getLog("02312", serviceKey, providerInfo));
    }

    protected ClientTransport selectByProvider(SofaRequest message, ProviderInfo providerInfo) {
        ClientTransport transport = this.connectionHolder.getAvailableClientTransport(providerInfo);
        if (transport != null) {
            if (transport.isAvailable()) {
                this.lastProviderInfo = providerInfo;
                this.checkAlias(providerInfo, message);
                return transport;
            }
            this.connectionHolder.setUnavailable(providerInfo, transport);
        }
        return null;
    }

    protected void checkAlias(ProviderInfo providerInfo, SofaRequest message) {
    }

    protected SofaResponse filterChain(ProviderInfo providerInfo, SofaRequest request) throws SofaRpcException {
        RpcInternalContext context = RpcInternalContext.getContext();
        context.setProviderInfo(providerInfo);
        return this.filterChain.invoke(request);
    }

    @Override
    public SofaResponse sendMsg(ProviderInfo providerInfo, SofaRequest request) throws SofaRpcException {
        ClientTransport clientTransport = this.connectionHolder.getAvailableClientTransport(providerInfo);
        if (clientTransport != null && clientTransport.isAvailable()) {
            return this.doSendMsg(providerInfo, clientTransport, request);
        }
        throw this.unavailableProviderException(request.getTargetServiceUniqueName(), providerInfo.getOriginUrl());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected SofaResponse doSendMsg(ProviderInfo providerInfo, ClientTransport transport, SofaRequest request) throws SofaRpcException {
        RpcInternalContext context = RpcInternalContext.getContext();
        RpcInternalContext.getContext().setRemoteAddress(providerInfo.getHost(), providerInfo.getPort());
        try {
            this.checkProviderVersion(providerInfo, request);
            String invokeType = request.getInvokeType();
            int timeout = this.resolveTimeout(request, this.consumerConfig, providerInfo);
            SofaResponse response = null;
            if ("sync".equals(invokeType)) {
                long start = RpcRuntimeContext.now();
                try {
                    response = transport.syncSend(request, timeout);
                }
                finally {
                    if (RpcInternalContext.isAttachmentEnable()) {
                        long elapsed = RpcRuntimeContext.now() - start;
                        context.setAttachment("_client_elapse", elapsed);
                    }
                }
            } else if ("oneway".equals(invokeType)) {
                long start = RpcRuntimeContext.now();
                try {
                    transport.oneWaySend(request, timeout);
                    response = this.buildEmptyResponse(request);
                }
                finally {
                    if (RpcInternalContext.isAttachmentEnable()) {
                        long elapsed = RpcRuntimeContext.now() - start;
                        context.setAttachment("_client_elapse", elapsed);
                    }
                }
            } else if ("callback".equals(invokeType)) {
                SofaResponseCallback methodResponseCallback;
                SofaResponseCallback sofaResponseCallback = request.getSofaResponseCallback();
                if (sofaResponseCallback == null && (methodResponseCallback = this.consumerConfig.getMethodOnreturn(request.getMethodName())) != null) {
                    request.setSofaResponseCallback(methodResponseCallback);
                }
                context.setAttachment("_client_send_time", RpcRuntimeContext.now());
                transport.asyncSend(request, timeout);
                response = this.buildEmptyResponse(request);
            } else if ("future".equals(invokeType)) {
                context.setAttachment("_client_send_time", RpcRuntimeContext.now());
                ResponseFuture future = transport.asyncSend(request, timeout);
                RpcInternalContext.getContext().setFuture(future);
                response = this.buildEmptyResponse(request);
            } else {
                throw new SofaRpcException(299, "Unknown invoke type:" + invokeType);
            }
            return response;
        }
        catch (SofaRpcException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new SofaRpcException(299, e);
        }
    }

    private SofaResponse buildEmptyResponse(SofaRequest request) {
        SofaResponse response = new SofaResponse();
        Method method = request.getMethod();
        if (method != null) {
            response.setAppResponse(ClassUtils.getDefaultPrimitiveValue(method.getReturnType()));
        }
        return response;
    }

    private int resolveTimeout(SofaRequest request, ConsumerConfig consumerConfig, ProviderInfo providerInfo) {
        Integer timeout = request.getTimeout();
        if (timeout == null && ((timeout = Integer.valueOf(consumerConfig.getMethodTimeout(request.getMethodName()))) == null || timeout < 0) && (timeout = (Integer)providerInfo.getDynamicAttr("timeout")) == null) {
            timeout = RpcConfigs.getIntValue("consumer.invoke.timeout");
        }
        return timeout;
    }

    @Override
    public void destroy() {
        this.destroy(null);
    }

    @Override
    public void destroy(Destroyable.DestroyHook hook) {
        if (this.destroyed) {
            return;
        }
        if (hook != null) {
            hook.postDestroy();
        }
        if (this.connectionHolder != null) {
            this.connectionHolder.destroy(new GracefulDestroyHook());
        }
        this.destroyed = true;
        this.initialized = false;
        if (hook != null) {
            hook.postDestroy();
        }
    }

    protected void closeTransports() {
        if (this.connectionHolder != null) {
            this.connectionHolder.closeAllClientTransports(new GracefulDestroyHook());
        }
    }

    @Override
    public boolean isAvailable() {
        if (this.destroyed || !this.initialized) {
            return false;
        }
        List<ProviderGroup> providerGroups = this.addressHolder.getProviderGroups();
        if (CommonUtils.isEmpty(providerGroups)) {
            return false;
        }
        for (ProviderGroup entry : providerGroups) {
            List<ProviderInfo> providerInfos = entry.getProviderInfos();
            for (ProviderInfo providerInfo : providerInfos) {
                ClientTransport transport = this.connectionHolder.getAvailableClientTransport(providerInfo);
                if (transport != null && transport.isAvailable()) {
                    return true;
                }
                this.connectionHolder.setUnavailable(providerInfo, transport);
            }
        }
        return false;
    }

    @Override
    public void checkStateChange(boolean originalState) {
        if (originalState) {
            if (!this.isAvailable()) {
                this.notifyStateChangeToUnavailable();
            }
        } else if (this.isAvailable()) {
            this.notifyStateChangeToAvailable();
        }
    }

    public void notifyStateChangeToUnavailable() {
        final List<ConsumerStateListener> onprepear = this.consumerConfig.getOnAvailable();
        if (onprepear != null) {
            AsyncRuntime.getAsyncThreadPool().execute(new Runnable(){

                @Override
                public void run() {
                    for (ConsumerStateListener listener : onprepear) {
                        try {
                            listener.onUnavailable(AbstractCluster.this.consumerBootstrap.getProxyIns());
                        }
                        catch (Exception e) {
                            LOGGER.error("Failed to notify consumer state listener when state change to unavailable");
                        }
                    }
                }
            });
        }
    }

    public void notifyStateChangeToAvailable() {
        final List<ConsumerStateListener> onprepear = this.consumerConfig.getOnAvailable();
        if (onprepear != null) {
            AsyncRuntime.getAsyncThreadPool().execute(new Runnable(){

                @Override
                public void run() {
                    for (ConsumerStateListener listener : onprepear) {
                        try {
                            listener.onAvailable(AbstractCluster.this.consumerBootstrap.getProxyIns());
                        }
                        catch (Exception e) {
                            LOGGER.error("Failed to notify consumer state listener when state change to available");
                        }
                    }
                }
            });
        }
    }

    public Collection<ProviderInfo> currentProviderList() {
        ArrayList<ProviderInfo> providerInfos = new ArrayList<ProviderInfo>();
        List<ProviderGroup> providerGroups = this.addressHolder.getProviderGroups();
        if (CommonUtils.isNotEmpty(providerGroups)) {
            for (ProviderGroup entry : providerGroups) {
                providerInfos.addAll(entry.getProviderInfos());
            }
        }
        return providerInfos;
    }

    private String convertProviders2Urls(List<ProviderInfo> providerInfos) {
        StringBuilder sb = new StringBuilder();
        if (CommonUtils.isNotEmpty(providerInfos)) {
            for (ProviderInfo providerInfo : providerInfos) {
                sb.append(providerInfo).append(",");
            }
        }
        return sb.toString();
    }

    public ConsumerConfig<?> getConsumerConfig() {
        return this.consumerConfig;
    }

    @Override
    public AddressHolder getAddressHolder() {
        return this.addressHolder;
    }

    @Override
    public ConnectionHolder getConnectionHolder() {
        return this.connectionHolder;
    }

    @Override
    public FilterChain getFilterChain() {
        return this.filterChain;
    }

    @Override
    public RouterChain getRouterChain() {
        return this.routerChain;
    }

    protected class GracefulDestroyHook
    implements Destroyable.DestroyHook {
        protected GracefulDestroyHook() {
        }

        @Override
        public void preDestroy() {
            int count = AbstractCluster.this.countOfInvoke.get();
            int timeout = AbstractCluster.this.consumerConfig.getDisconnectTimeout();
            if (count > 0) {
                long start = RpcRuntimeContext.now();
                if (LOGGER.isWarnEnabled()) {
                    LOGGER.warn("There are {} outstanding call in client, will close transports util return", count);
                }
                while (AbstractCluster.this.countOfInvoke.get() > 0 && RpcRuntimeContext.now() - start < (long)timeout) {
                    try {
                        Thread.sleep(10L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        }

        @Override
        public void postDestroy() {
        }
    }
}

