package com.aliyun.mns.client;

import com.aliyun.mns.common.ClientException;
import org.apache.log4j.Logger;

import java.net.URI;
import java.net.URISyntaxException;

public class Utils {
    public static Logger logger = Logger.getLogger(Utils.class);

    public static URI getHttpURI(String endpoint) {
        if (endpoint == null) {
            logger.warn("参数endpoint为空指针。");
            throw new NullPointerException("参数endpoint为空指针。");
        }

        try {
            if (!endpoint.startsWith("http://") && !endpoint.startsWith("https://")) {
                logger.warn("仅支持http协议。Endpoint必须以http://或https://开头。");
                throw new IllegalArgumentException(
                        "仅支持http协议。Endpoint必须以http://或https://开头。");
            }
            while (endpoint.endsWith("/")) {
                endpoint = endpoint.substring(0, endpoint.length() - 1);
            }

            if (endpoint.length() < "http://".length()) {
                logger.warn("参数endpoint地址无效.");
                throw new IllegalArgumentException("参数endpoint地址无效.");
            }
            return new URI(endpoint);

        } catch (URISyntaxException e) {
            logger.warn("uri syntax error");
            throw new IllegalArgumentException(e);
        }
    }
}
