/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dynamodbv2.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.dynamodbv2.model.AttributeValue;
import com.amazonaws.services.dynamodbv2.model.Condition;
import com.amazonaws.services.dynamodbv2.model.ScanRequest;
import com.amazonaws.services.dynamodbv2.model.transform.AttributeValueJsonMarshaller;
import com.amazonaws.services.dynamodbv2.model.transform.ConditionJsonMarshaller;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.List;
import java.util.Map;

public class ScanRequestMarshaller
implements Marshaller<Request<ScanRequest>, ScanRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public ScanRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    public Request<ScanRequest> marshall(ScanRequest scanRequest) {
        if (scanRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)scanRequest, "AmazonDynamoDBv2");
        request.addHeader("X-Amz-Target", "DynamoDB_20120810.Scan");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            Map<String, AttributeValue> map;
            Map<String, String> map2;
            Map<String, AttributeValue> map3;
            Map<String, Condition> scanFilterMap;
            List<String> attributesToGetList;
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (scanRequest.getTableName() != null) {
                jsonGenerator.writeFieldName("TableName").writeValue(scanRequest.getTableName());
            }
            if (scanRequest.getIndexName() != null) {
                jsonGenerator.writeFieldName("IndexName").writeValue(scanRequest.getIndexName());
            }
            if ((attributesToGetList = scanRequest.getAttributesToGet()) != null) {
                jsonGenerator.writeFieldName("AttributesToGet");
                jsonGenerator.writeStartArray();
                for (String string : attributesToGetList) {
                    if (string == null) continue;
                    jsonGenerator.writeValue(string);
                }
                jsonGenerator.writeEndArray();
            }
            if (scanRequest.getLimit() != null) {
                jsonGenerator.writeFieldName("Limit").writeValue(scanRequest.getLimit().intValue());
            }
            if (scanRequest.getSelect() != null) {
                jsonGenerator.writeFieldName("Select").writeValue(scanRequest.getSelect());
            }
            if ((scanFilterMap = scanRequest.getScanFilter()) != null) {
                jsonGenerator.writeFieldName("ScanFilter");
                jsonGenerator.writeStartObject();
                for (Map.Entry<String, Condition> entry : scanFilterMap.entrySet()) {
                    if (entry.getValue() == null) continue;
                    jsonGenerator.writeFieldName(entry.getKey());
                    ConditionJsonMarshaller.getInstance().marshall(entry.getValue(), jsonGenerator);
                }
                jsonGenerator.writeEndObject();
            }
            if (scanRequest.getConditionalOperator() != null) {
                jsonGenerator.writeFieldName("ConditionalOperator").writeValue(scanRequest.getConditionalOperator());
            }
            if ((map3 = scanRequest.getExclusiveStartKey()) != null) {
                jsonGenerator.writeFieldName("ExclusiveStartKey");
                jsonGenerator.writeStartObject();
                for (Map.Entry<String, AttributeValue> entry : map3.entrySet()) {
                    if (entry.getValue() == null) continue;
                    jsonGenerator.writeFieldName(entry.getKey());
                    AttributeValueJsonMarshaller.getInstance().marshall(entry.getValue(), jsonGenerator);
                }
                jsonGenerator.writeEndObject();
            }
            if (scanRequest.getReturnConsumedCapacity() != null) {
                jsonGenerator.writeFieldName("ReturnConsumedCapacity").writeValue(scanRequest.getReturnConsumedCapacity());
            }
            if (scanRequest.getTotalSegments() != null) {
                jsonGenerator.writeFieldName("TotalSegments").writeValue(scanRequest.getTotalSegments().intValue());
            }
            if (scanRequest.getSegment() != null) {
                jsonGenerator.writeFieldName("Segment").writeValue(scanRequest.getSegment().intValue());
            }
            if (scanRequest.getProjectionExpression() != null) {
                jsonGenerator.writeFieldName("ProjectionExpression").writeValue(scanRequest.getProjectionExpression());
            }
            if (scanRequest.getFilterExpression() != null) {
                jsonGenerator.writeFieldName("FilterExpression").writeValue(scanRequest.getFilterExpression());
            }
            if ((map2 = scanRequest.getExpressionAttributeNames()) != null) {
                jsonGenerator.writeFieldName("ExpressionAttributeNames");
                jsonGenerator.writeStartObject();
                for (Map.Entry<String, String> entry : map2.entrySet()) {
                    if (entry.getValue() == null) continue;
                    jsonGenerator.writeFieldName(entry.getKey());
                    jsonGenerator.writeValue(entry.getValue());
                }
                jsonGenerator.writeEndObject();
            }
            if ((map = scanRequest.getExpressionAttributeValues()) != null) {
                jsonGenerator.writeFieldName("ExpressionAttributeValues");
                jsonGenerator.writeStartObject();
                for (Map.Entry<String, AttributeValue> entry : map.entrySet()) {
                    if (entry.getValue() == null) continue;
                    jsonGenerator.writeFieldName(entry.getKey());
                    AttributeValueJsonMarshaller.getInstance().marshall(entry.getValue(), jsonGenerator);
                }
                jsonGenerator.writeEndObject();
            }
            if (scanRequest.getConsistentRead() != null) {
                jsonGenerator.writeFieldName("ConsistentRead").writeValue(scanRequest.getConsistentRead().booleanValue());
            }
            jsonGenerator.writeEndObject();
            byte[] byArray = jsonGenerator.getBytes();
            request.setContent((InputStream)new ByteArrayInputStream(byArray));
            request.addHeader("Content-Length", Integer.toString(byArray.length));
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

