/*
 * Decompiled with CFR 0.152.
 */
package com.actionsoft.bpms.api;

import com.actionsoft.bpms.api.ApiConverter;
import com.actionsoft.bpms.api.ApiException;
import com.actionsoft.bpms.api.MapConverter;
import com.actionsoft.bpms.api.common.ApiMarshaller;
import com.actionsoft.bpms.api.common.ApiResponse;
import com.actionsoft.bpms.api.common.ApiUtils;
import com.actionsoft.bpms.api.common.MarshallerUtil;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;

public class OpenApiClient {
    public static final String ALGORITHM_HMAC = "HmacSHA1";
    public static final String ALGORITHMHMAC__MD5 = "HmacMD5";
    public static final String ALGORITHM_MD5 = "MD5";
    public static final String FORMAT_JSON = "json";
    public static final String FORMAT_XML = "xml";
    private String serverUrl;
    private String accessKey;
    private String secret;
    private String format = "json";
    private int connectTimeout = 3000;
    private int readTimeout = 15000;
    private static Map<Class<?>, ApiConverter<?>> converterMap = new HashMap();
    private static boolean debug = false;

    public OpenApiClient(String serverUrl, String accessKey, String secret) {
        this.serverUrl = serverUrl;
        this.accessKey = accessKey;
        this.secret = secret;
    }

    public OpenApiClient(String serverUrl, String accessKey, String secret, String format) {
        this(serverUrl, accessKey, secret);
        this.format = format;
    }

    public OpenApiClient(String serverUrl, String accessKey, String secret, String format, int connectTimeout, int readTimeout) {
        this(serverUrl, accessKey, secret, format);
        this.connectTimeout = connectTimeout;
        this.readTimeout = readTimeout;
    }

    public String exec(String cmd, Map<String, Object> params) throws ApiException {
        return this.exec(cmd, params, Collections.EMPTY_LIST);
    }

    public String exec(String cmd, Map<String, Object> params, Collection<String> ignoreSign) throws ApiException {
        HashMap<String, String> t = new HashMap<String, String>();
        if (params != null) {
            for (Map.Entry<String, Object> entry : params.entrySet()) {
                Class<?> type = entry.getValue().getClass();
                ApiConverter convertor = OpenApiClient.getConvertor(type);
                String key = entry.getKey();
                Object fieldValue = entry.getValue();
                if (fieldValue == null) continue;
                if (convertor != null) {
                    String strParamValue = convertor.convert(fieldValue, FORMAT_JSON);
                    t.put(key, strParamValue);
                    continue;
                }
                if (type.isAnnotationPresent(XmlRootElement.class) || type.isAnnotationPresent(XmlType.class) || OpenApiClient.isCollectionOrArray(type) || Map.class.isAssignableFrom(type)) {
                    ByteArrayOutputStream bos = new ByteArrayOutputStream(1024);
                    this.getMarshaller(FORMAT_JSON).marshaller(fieldValue, bos);
                    try {
                        t.put(key, bos.toString("utf-8"));
                        continue;
                    }
                    catch (UnsupportedEncodingException e) {
                        throw new ApiException(e);
                    }
                }
                t.put(key, fieldValue.toString());
            }
        }
        t.put("timestamp", Long.toString(System.currentTimeMillis()));
        t.put("cmd", cmd);
        t.put("format", this.format);
        t.put("access_key", this.accessKey);
        t.put("sig_method", ALGORITHMHMAC__MD5);
        String sig = ApiUtils.makeSig(t, this.secret, ignoreSign);
        t.put("sig", sig);
        String charset = "UTF-8";
        String ctype = "application/x-www-form-urlencoded;charset=" + charset;
        String query = ApiUtils.buildQuery(t, charset);
        if (debug) {
            System.out.println("sig:" + sig + " , query:" + query);
        }
        byte[] content = new byte[]{};
        if (query != null) {
            content = ApiUtils.convertBytes(query);
        }
        try {
            return OpenApiClient._doPost(this.serverUrl, ctype, content, this.connectTimeout, this.readTimeout, null);
        }
        catch (Exception e) {
            throw new ApiException(e);
        }
    }

    private static boolean isCollectionOrArray(Class<?> type) {
        return Collection.class.isAssignableFrom(type) || type.isArray();
    }

    public <T> T exec(String cmd, Map<String, Object> params, Class<T> apiResponse) {
        ApiResponse r;
        String res = this.exec(cmd, params);
        ApiMarshaller apiMarshaller = this.getMarshaller(this.format);
        T t = apiMarshaller.unmarshaller(res, apiResponse);
        if (t instanceof ApiResponse && !(r = (ApiResponse)t).isSuccess()) {
            throw new ApiException(r.getErrorCode(), r.getMsg());
        }
        return t;
    }

    protected ApiMarshaller getMarshaller(String format) {
        return MarshallerUtil.getMarshaller(this.format);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String _doPost(String url, String ctype, byte[] content, int connectTimeout, int readTimeout, Map<String, String> headerMap) throws IOException {
        HttpURLConnection conn = null;
        OutputStream out = null;
        String rsp = null;
        try {
            conn = ApiUtils.getConnection(new URL(url), "POST", ctype, headerMap);
            conn.setConnectTimeout(connectTimeout);
            conn.setReadTimeout(readTimeout);
            out = conn.getOutputStream();
            out.write(content);
            rsp = ApiUtils.getResponseAsString(conn);
        }
        finally {
            if (out != null) {
                out.close();
            }
            if (conn != null) {
                conn.disconnect();
            }
        }
        return rsp;
    }

    private static ApiConverter getConvertor(Class<?> fieldType) {
        for (Class<?> aClass : converterMap.keySet()) {
            if (!aClass.isAssignableFrom(fieldType)) continue;
            return converterMap.get(aClass);
        }
        return null;
    }

    public static void setDebug(boolean debug) {
        OpenApiClient.debug = debug;
    }

    static {
        converterMap.put(Map.class, new MapConverter());
    }
}

