/*
 * Decompiled with CFR 0.152.
 */
package com.actionsoft.bpms.api.common;

import com.actionsoft.bpms.api.common.ApiMarshaller;
import com.actionsoft.bpms.api.common.ApiUtils;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;

public class JaxbXmlMarshaller
implements ApiMarshaller {
    private static Map<Class<?>, JAXBContext> jaxbContextHashMap = new ConcurrentHashMap();

    @Override
    public void marshaller(Object object, OutputStream outputStream) {
        try {
            Marshaller m = this.buildMarshaller(object.getClass());
            m.marshal(object, outputStream);
        }
        catch (JAXBException e) {
            throw new RuntimeException(e);
        }
    }

    private Marshaller buildMarshaller(Class<?> objectType) throws JAXBException {
        JAXBContext context;
        if (!jaxbContextHashMap.containsKey(objectType)) {
            context = JAXBContext.newInstance((Class[])new Class[]{objectType});
            jaxbContextHashMap.put(objectType, context);
        }
        context = jaxbContextHashMap.get(objectType);
        Marshaller marshaller = context.createMarshaller();
        marshaller.setProperty("jaxb.formatted.output", (Object)true);
        marshaller.setProperty("jaxb.encoding", (Object)"utf-8");
        return marshaller;
    }

    private Unmarshaller buildUnMarshaller(Class<?> objectType) throws JAXBException {
        JAXBContext context;
        if (!jaxbContextHashMap.containsKey(objectType)) {
            context = JAXBContext.newInstance((Class[])new Class[]{objectType});
            jaxbContextHashMap.put(objectType, context);
        }
        context = jaxbContextHashMap.get(objectType);
        Unmarshaller marshaller = context.createUnmarshaller();
        return marshaller;
    }

    @Override
    public <T> T unmarshaller(String str, Class<T> apiResponse) {
        try {
            Unmarshaller m = this.buildUnMarshaller(apiResponse);
            return (T)m.unmarshal((InputStream)new ByteArrayInputStream(ApiUtils.convertBytes(str)));
        }
        catch (JAXBException e) {
            throw new RuntimeException(e);
        }
    }
}

