/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.brpc.client;

import com.baidu.brpc.ChannelInfo;
import com.baidu.brpc.RpcContext;
import com.baidu.brpc.RpcMethodInfo;
import com.baidu.brpc.client.AsyncAwareFuture;
import com.baidu.brpc.client.FastFutureStore;
import com.baidu.brpc.client.RpcCallback;
import com.baidu.brpc.client.RpcClient;
import com.baidu.brpc.exceptions.RpcException;
import com.baidu.brpc.protocol.Request;
import com.baidu.brpc.protocol.Response;
import com.baidu.brpc.utils.CollectionUtils;
import io.netty.util.Timeout;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RpcFuture<T>
implements AsyncAwareFuture<T> {
    private static final Logger LOG = LoggerFactory.getLogger(RpcFuture.class);
    protected CountDownLatch latch;
    protected Timeout timeout;
    protected RpcCallback<T> callback;
    protected ChannelInfo channelInfo;
    protected RpcClient rpcClient;
    protected RpcMethodInfo rpcMethodInfo;
    protected Response response;
    protected boolean isDone;
    protected long startTime;
    protected long endTime;
    protected volatile long correlationId;

    public RpcFuture() {
        this.latch = new CountDownLatch(1);
        this.startTime = System.currentTimeMillis();
    }

    public RpcFuture(long correlationId) {
        this.correlationId = correlationId;
        this.latch = new CountDownLatch(1);
        this.startTime = System.currentTimeMillis();
    }

    public RpcFuture(Timeout timeout, RpcMethodInfo rpcMethodInfo, RpcCallback<T> callback, ChannelInfo channelInfo, RpcClient rpcClient) {
        this.init(timeout, rpcMethodInfo, callback, channelInfo, rpcClient);
    }

    public static RpcFuture createRpcFuture(Request request, RpcClient rpcClient) {
        RpcFuture rpcFuture = new RpcFuture();
        rpcFuture.setRpcMethodInfo(request.getRpcMethodInfo());
        rpcFuture.setCallback(request.getCallback());
        rpcFuture.setRpcClient(rpcClient);
        FastFutureStore.getInstance(0).put(rpcFuture);
        return rpcFuture;
    }

    public void init(Timeout timeout, RpcMethodInfo rpcMethodInfo, RpcCallback<T> callback, ChannelInfo channelInfo, RpcClient rpcClient) {
        this.timeout = timeout;
        this.rpcMethodInfo = rpcMethodInfo;
        this.callback = callback;
        this.channelInfo = channelInfo;
        this.latch = new CountDownLatch(1);
        this.startTime = System.currentTimeMillis();
        this.rpcClient = rpcClient;
    }

    public void handleConnection(Response response) {
        this.response = response;
        this.endTime = System.currentTimeMillis();
        if (this.rpcClient.isLongConnection()) {
            if (response != null && response.getResult() != null) {
                this.channelInfo.getChannelGroup().updateLatency((int)(this.endTime - this.startTime));
                this.channelInfo.handleResponseSuccess();
            } else {
                this.channelInfo.getChannelGroup().updateLatencyWithReadTimeOut();
                this.channelInfo.handleResponseFail();
            }
        } else {
            this.channelInfo.close();
        }
        this.timeout.cancel();
        this.latch.countDown();
        this.isDone = true;
    }

    public void handleResponse(Response response) {
        this.handleConnection(response);
        if (this.isAsync() && CollectionUtils.isNotEmpty(this.rpcClient.getInterceptors())) {
            int length = this.rpcClient.getInterceptors().size();
            for (int i = length - 1; i >= 0; --i) {
                this.rpcClient.getInterceptors().get(i).handleResponse(response);
            }
        }
        if (this.isAsync()) {
            this.setRpcContext();
            if (response == null) {
                this.callback.fail(new RpcException(3, "internal error"));
            } else if (response.getResult() != null) {
                this.callback.success(response.getResult());
            } else {
                this.callback.fail(response.getException());
            }
        }
    }

    @Override
    public boolean isAsync() {
        return this.callback != null;
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        return false;
    }

    @Override
    public boolean isCancelled() {
        return false;
    }

    @Override
    public boolean isDone() {
        return this.isDone;
    }

    @Override
    public T get() throws InterruptedException {
        this.latch.await();
        if (this.response != null && this.response.getException() != null) {
            throw new RpcException(this.response.getException());
        }
        if (this.response == null) {
            throw new RpcException(2);
        }
        this.setRpcContext();
        return (T)this.response.getResult();
    }

    @Override
    public T get(long timeout, TimeUnit unit) {
        try {
            boolean ret = this.latch.await(timeout, unit);
            if (!ret) {
                throw new RpcException(2, "timeout");
            }
            assert (this.response != null);
            if (this.response.getException() != null) {
                throw new RpcException(this.response.getException());
            }
            this.setRpcContext();
            return (T)this.response.getResult();
        }
        catch (InterruptedException e) {
            throw new RpcException(0, (Throwable)e);
        }
    }

    public String toString() {
        return super.toString() + "@correlationId = " + this.correlationId;
    }

    protected void setRpcContext() {
        if (this.response == null) {
            return;
        }
        if (this.response.getBinaryAttachment() != null || this.response.getKvAttachment() != null) {
            RpcContext rpcContext = RpcContext.getContext();
            if (this.response.getBinaryAttachment() != null) {
                rpcContext.setResponseBinaryAttachment(this.response.getBinaryAttachment());
            }
            if (this.response.getKvAttachment() != null) {
                rpcContext.setResponseKvAttachment(this.response.getKvAttachment());
            }
        }
    }

    public void setLatch(CountDownLatch latch) {
        this.latch = latch;
    }

    public void setTimeout(Timeout timeout) {
        this.timeout = timeout;
    }

    public void setCallback(RpcCallback<T> callback) {
        this.callback = callback;
    }

    public void setChannelInfo(ChannelInfo channelInfo) {
        this.channelInfo = channelInfo;
    }

    public void setRpcClient(RpcClient rpcClient) {
        this.rpcClient = rpcClient;
    }

    public void setRpcMethodInfo(RpcMethodInfo rpcMethodInfo) {
        this.rpcMethodInfo = rpcMethodInfo;
    }

    public void setResponse(Response response) {
        this.response = response;
    }

    public void setDone(boolean isDone) {
        this.isDone = isDone;
    }

    public void setStartTime(long startTime) {
        this.startTime = startTime;
    }

    public void setEndTime(long endTime) {
        this.endTime = endTime;
    }

    public void setCorrelationId(long correlationId) {
        this.correlationId = correlationId;
    }

    public CountDownLatch getLatch() {
        return this.latch;
    }

    public Timeout getTimeout() {
        return this.timeout;
    }

    public RpcCallback<T> getCallback() {
        return this.callback;
    }

    public ChannelInfo getChannelInfo() {
        return this.channelInfo;
    }

    public RpcClient getRpcClient() {
        return this.rpcClient;
    }

    public RpcMethodInfo getRpcMethodInfo() {
        return this.rpcMethodInfo;
    }

    public Response getResponse() {
        return this.response;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public long getEndTime() {
        return this.endTime;
    }

    public long getCorrelationId() {
        return this.correlationId;
    }
}

