/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.disconf.core.common.zookeeper;

import com.baidu.disconf.core.common.utils.ZooUtils;
import com.baidu.disconf.core.common.zookeeper.inner.ResilientActiveKeyValueStore;
import java.io.IOException;
import java.util.List;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.data.Stat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZookeeperMgr {
    protected static final Logger LOGGER = LoggerFactory.getLogger(ZookeeperMgr.class);
    private ResilientActiveKeyValueStore store;
    private String curHost = "";
    private String curDefaultPrefixString = "";

    public void init(String host, String defaultPrefixString, boolean debug) throws Exception {
        try {
            this.initInternal(host, defaultPrefixString, debug);
            LOGGER.debug("ZookeeperMgr init.");
        }
        catch (Exception e) {
            throw new Exception("zookeeper init failed. ", e);
        }
    }

    private ZookeeperMgr() {
    }

    public static ZookeeperMgr getInstance() {
        return SingletonHolder.instance;
    }

    public void reconnect() {
        this.store.reconnect();
    }

    private void initInternal(String hosts, String defaultPrefixString, boolean debug) throws IOException, InterruptedException {
        this.curHost = hosts;
        this.curDefaultPrefixString = defaultPrefixString;
        this.store = new ResilientActiveKeyValueStore(debug);
        this.store.connect(hosts);
        LOGGER.info("zoo prefix: " + defaultPrefixString);
        this.makeDir(defaultPrefixString, ZooUtils.getIp());
    }

    public void makeDir(String dir, String data) {
        try {
            boolean deafult_path_exist = this.store.exists(dir);
            if (!deafult_path_exist) {
                LOGGER.info("create: " + dir);
                this.writePersistentUrl(dir, data);
            }
        }
        catch (KeeperException e) {
            LOGGER.error("cannot create path: " + dir, (Throwable)e);
        }
        catch (Exception e) {
            LOGGER.error("cannot create path: " + dir, (Throwable)e);
        }
    }

    public void release() throws InterruptedException {
        this.store.close();
    }

    public List<String> getRootChildren() {
        return this.store.getRootChildren();
    }

    public void writePersistentUrl(String url, String value) throws Exception {
        this.store.write(url, value);
    }

    public String readUrl(String url, Watcher watcher) throws Exception {
        return this.store.read(url, watcher, null);
    }

    public ZooKeeper getZk() {
        return this.store.getZk();
    }

    public boolean exists(String path) throws Exception {
        return this.store.exists(path);
    }

    public String createEphemeralNode(String path, String value, CreateMode createMode) throws Exception {
        return this.store.createEphemeralNode(path, value, createMode);
    }

    public String read(String path, Watcher watcher, Stat stat) throws InterruptedException, KeeperException {
        return this.store.read(path, watcher, stat);
    }

    public void deleteNode(String path) {
        this.store.deleteNode(path);
    }

    private static class SingletonHolder {
        private static ZookeeperMgr instance = new ZookeeperMgr();

        private SingletonHolder() {
        }
    }
}

