/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.recipes.lock;

import org.apache.log4j.Logger;

class ZNodeName
implements Comparable<ZNodeName> {
    private final String name;
    private String prefix;
    private int sequence = -1;
    private static final Logger LOG = Logger.getLogger(ZNodeName.class);

    public ZNodeName(String name) {
        if (name == null) {
            throw new NullPointerException("id cannot be null");
        }
        this.name = name;
        this.prefix = name;
        int idx = name.lastIndexOf(45);
        if (idx >= 0) {
            this.prefix = name.substring(0, idx);
            try {
                this.sequence = Integer.parseInt(name.substring(idx + 1));
            }
            catch (NumberFormatException e) {
                LOG.info((Object)("Number format exception for " + idx), (Throwable)e);
            }
            catch (ArrayIndexOutOfBoundsException e) {
                LOG.info((Object)("Array out of bounds for " + idx), (Throwable)e);
            }
        }
    }

    public String toString() {
        return this.name.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ZNodeName sequence = (ZNodeName)o;
        return this.name.equals(sequence.name);
    }

    public int hashCode() {
        return this.name.hashCode() + 37;
    }

    @Override
    public int compareTo(ZNodeName that) {
        int answer = this.prefix.compareTo(that.prefix);
        if (answer == 0) {
            int s1 = this.sequence;
            int s2 = that.sequence;
            if (s1 == -1 && s2 == -1) {
                return this.name.compareTo(that.name);
            }
            answer = s1 == -1 ? 1 : (s2 == -1 ? -1 : s1 - s2);
        }
        return answer;
    }

    public String getName() {
        return this.name;
    }

    public int getZNodeName() {
        return this.sequence;
    }

    public String getPrefix() {
        return this.prefix;
    }
}

