/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.nebula.competence.feign.service.internal;

import com.bizunited.nebula.common.controller.model.ResponseModel;
import com.bizunited.nebula.common.util.JsonUtils;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.bizunited.nebula.competence.feign.feign.CompetenceVoFeign;
import com.bizunited.nebula.competence.sdk.service.CompetenceCacheVoService;
import com.bizunited.nebula.competence.sdk.vo.CompetenceVo;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.Sets;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service
public class CompetenceCacheVoServiceImpl
implements CompetenceCacheVoService {
    @Autowired(required=false)
    private CompetenceVoFeign competenceVoFeign;
    private static volatile Cache<String, CompetenceVo> cache = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public CompetenceCacheVoServiceImpl() {
        if (cache != null) return;
        Class<CompetenceCacheVoServiceImpl> clazz = CompetenceCacheVoServiceImpl.class;
        synchronized (CompetenceCacheVoServiceImpl.class) {
            while (cache == null) {
                cache = CacheBuilder.newBuilder().initialCapacity(10000).expireAfterWrite(30L, TimeUnit.MINUTES).maximumSize(100000L).build();
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public CompetenceVo findCacheByCompetenceCode(String competenceCode) {
        if (StringUtils.isBlank((CharSequence)competenceCode)) {
            return null;
        }
        String cacheKey = StringUtils.join((Object[])new String[]{TenantUtils.getTenantCode(), competenceCode});
        CompetenceVo graph = (CompetenceVo)cache.getIfPresent((Object)cacheKey);
        if (graph != null) {
            return graph;
        }
        ResponseModel responseModel = this.competenceVoFeign.findCacheByCompetenceCode(competenceCode);
        Assert.notNull((Object)responseModel, (String)"\u8c03\u7528MDM\u83dc\u5355\u6a21\u5757\u5931\u8d25!");
        Assert.isTrue((boolean)responseModel.getSuccess(), (String)responseModel.getMessage());
        if (Objects.isNull(responseModel.getData())) {
            return null;
        }
        graph = (CompetenceVo)JsonUtils.convert((Object)responseModel.getData(), CompetenceVo.class);
        cache.put((Object)cacheKey, (Object)graph);
        return graph;
    }

    public Set<CompetenceVo> findByResource(String resource, Integer status) {
        return Sets.newHashSet();
    }
}

