/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.nebula.competence.local.controller;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.bizunited.nebula.common.controller.BaseController;
import com.bizunited.nebula.common.controller.model.ResponseModel;
import com.bizunited.nebula.competence.sdk.register.CompetenceRegister;
import io.swagger.annotations.ApiOperation;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/v1/competences/competenceRegisters"})
public class CompetenceRegisterController
extends BaseController {
    @Autowired(required=false)
    private Set<CompetenceRegister<?, ?>> competenceRegisters;
    private static final Logger LOGGER = LoggerFactory.getLogger(CompetenceRegisterController.class);

    @ApiOperation(value="\u67e5\u8be2\u76ee\u524d\u5df2\u77e5\u7684\u5177\u4f53\u529f\u80fd/\u83dc\u5355\u5b9e\u73b0\u6a21\u5757\u4fe1\u606f")
    @GetMapping(value={"/findRegisters"})
    public ResponseModel findRegisters() {
        try {
            if (CollectionUtils.isEmpty(this.competenceRegisters)) {
                return this.buildHttpResult();
            }
            JSONArray results = new JSONArray();
            for (CompetenceRegister<?, ?> competenceRegister : this.competenceRegisters) {
                String comment = competenceRegister.getComment();
                String type = competenceRegister.getType();
                JSONObject item = new JSONObject();
                item.put("comment", (Object)comment);
                item.put("type", (Object)type);
                results.add((Object)item);
            }
            return this.buildHttpResult(results);
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }
}

